/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.type;

import groove.algebra.SignatureKind;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.EdgeRole;
import groove.graph.ElementFactory;
import groove.graph.Label;
import groove.graph.Morphism;
import groove.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeFactory
implements ElementFactory<TypeNode, TypeEdge> {
    private final Map<SignatureKind, TypeNode> dataTypeMap = new EnumMap<SignatureKind, TypeNode>(SignatureKind.class);
    private int maxNodeNr;
    private TypeNode topNode;
    private Map<TypeLabel, TypeNode> typeNodeMap = new HashMap<TypeLabel, TypeNode>();
    private List<TypeNode> typeNodeList = new ArrayList<TypeNode>();
    private final Map<EdgeRole, Map<String, TypeLabel>> labelMaps = new EnumMap<EdgeRole, Map<String, TypeLabel>>(EdgeRole.class);
    private final TypeGraph typeGraph;

    TypeFactory(TypeGraph typeGraph) {
        Enum[] enumArray = EdgeRole.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            EdgeRole kind = enumArray[n2];
            this.labelMaps.put(kind, new HashMap());
            ++n2;
        }
        assert (typeGraph.isEmpty());
        this.typeGraph = typeGraph;
        enumArray = SignatureKind.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum sig = enumArray[n2];
            this.dataTypeMap.put((SignatureKind)sig, this.createNode(TypeLabel.getLabel((SignatureKind)sig)));
            ++n2;
        }
    }

    @Override
    public TypeNode createNode(int nr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxNodeNr() {
        return this.maxNodeNr;
    }

    public TypeNode getTopNode() {
        if (this.topNode == null) {
            this.topNode = this.createNode(TypeLabel.NODE);
        }
        return this.topNode;
    }

    public TypeNode createNode(TypeLabel label) {
        assert (label.getRole() == EdgeRole.NODE_TYPE);
        TypeNode result = this.typeNodeMap.get(label);
        if (result == null) {
            result = new TypeNode(this.getNextNodeNr(), label, this.getGraph());
            this.typeNodeMap.put(label, result);
            this.typeNodeList.add(result);
            this.getGraph().addNode(result);
        }
        return result;
    }

    public TypeNode getNode(TypeLabel label) {
        assert (label.getRole() == EdgeRole.NODE_TYPE);
        return this.typeNodeMap.get(label);
    }

    @Override
    public TypeLabel createLabel(String text) {
        Pair<EdgeRole, String> parsedLabel = EdgeRole.parseLabel(text);
        return this.createLabel(parsedLabel.one(), parsedLabel.two());
    }

    public TypeLabel createLabel(EdgeRole kind, String text) {
        assert (text != null) : "Label text of type label should not be null";
        return this.newLabel(kind, text);
    }

    @Override
    public TypeEdge createEdge(TypeNode source, String text, TypeNode target) {
        return this.createEdge(source, this.createLabel(text), target, true);
    }

    @Override
    public TypeEdge createEdge(TypeNode source, Label label, TypeNode target) {
        return this.createEdge(source, (TypeLabel)label, target, true);
    }

    public TypeEdge createEdge(TypeNode source, TypeLabel label, TypeNode target, boolean precise) {
        TypeEdge result = null;
        result = this.getGraph().getTypeEdge(source, label, target, precise);
        if (result == null) {
            result = new TypeEdge(source, label, target, this.getGraph());
            this.getGraph().addEdge(result);
        }
        return result;
    }

    @Override
    public Morphism<TypeNode, TypeEdge> createMorphism() {
        throw new UnsupportedOperationException();
    }

    public TypeNode getDataType(SignatureKind signature) {
        return this.dataTypeMap.get((Object)signature);
    }

    public Collection<TypeNode> getDataTypes() {
        return this.dataTypeMap.values();
    }

    public TypeGraph getGraph() {
        return this.typeGraph;
    }

    private TypeLabel newLabel(EdgeRole kind, String text) {
        Map<String, TypeLabel> labelMap = this.labelMaps.get((Object)kind);
        TypeLabel result = labelMap.get(text);
        if (result == null) {
            result = new TypeLabel(text, kind);
            labelMap.put(text, result);
            return result;
        }
        return result;
    }

    private int getNextNodeNr() {
        ++this.maxNodeNr;
        return this.maxNodeNr;
    }

    public static TypeFactory newInstance() {
        return new TypeGraph("implicit", true).getFactory();
    }
}

