/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.type;

import groove.algebra.SignatureKind;
import groove.grammar.model.FormatException;
import groove.grammar.rule.RuleLabel;
import groove.grammar.type.TypeFactory;
import groove.graph.ALabel;
import groove.graph.EdgeRole;
import groove.graph.Label;
import groove.io.HTMLConverter;
import groove.util.ExprParser;
import java.util.EnumMap;
import java.util.Map;

public final class TypeLabel
extends ALabel {
    private final String text;
    private final EdgeRole role;
    private static final Map<SignatureKind, TypeLabel> sigLabelMap = new EnumMap<SignatureKind, TypeLabel>(SignatureKind.class);
    public static final TypeLabel NODE;
    private static TypeFactory typeFactory;

    static {
        SignatureKind[] signatureKindArray = SignatureKind.values();
        int n = signatureKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            SignatureKind sigKind = signatureKindArray[n2];
            sigLabelMap.put(sigKind, new TypeLabel(sigKind.getName(), EdgeRole.NODE_TYPE));
            ++n2;
        }
        NODE = new TypeLabel("\u03a9", EdgeRole.NODE_TYPE);
        typeFactory = TypeFactory.newInstance();
    }

    TypeLabel(String text, EdgeRole kind) {
        this.text = text;
        this.role = kind;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getRole().getPrefix()) + this.text();
    }

    @Override
    public EdgeRole getRole() {
        return this.role;
    }

    public boolean isDataType() {
        return this.getRole() == EdgeRole.NODE_TYPE && SignatureKind.getNames().contains(this.text());
    }

    public static final TypeLabel getLabel(SignatureKind sigKind) {
        return sigLabelMap.get((Object)sigKind);
    }

    public static TypeLabel createLabel(String prefixedText) {
        return typeFactory.createLabel(prefixedText);
    }

    public static TypeLabel createLabelWithCheck(String prefixedText) throws FormatException {
        TypeLabel result = TypeLabel.createLabel(prefixedText);
        if (result.getRole() != EdgeRole.BINARY && !ExprParser.isIdentifier(result.text())) {
            throw new FormatException("%s label '%s' is not a valid identifier", result.getRole().getDescription(true), result.text());
        }
        return result;
    }

    public static TypeLabel createBinaryLabel(String text) {
        return typeFactory.createLabel(EdgeRole.BINARY, text);
    }

    public static TypeLabel createLabel(EdgeRole kind, String text, boolean test) throws FormatException {
        if (test && kind != EdgeRole.BINARY && !ExprParser.isIdentifier(text)) {
            throw new FormatException("%s label '%s' is not a valid identifier", kind.getDescription(true), text);
        }
        return TypeLabel.createLabel(kind, text);
    }

    public static TypeLabel createLabel(EdgeRole kind, String text) {
        return typeFactory.createLabel(kind, text);
    }

    public static String toHtmlString(Label label) {
        String result = HTMLConverter.toHtml(label.text());
        switch (label.getRole()) {
            case NODE_TYPE: {
                result = HTMLConverter.STRONG_TAG.on(result);
                break;
            }
            case FLAG: {
                result = HTMLConverter.ITALIC_TAG.on(result);
                break;
            }
            default: {
                RuleLabel ruleLabel;
                if (!(label instanceof RuleLabel) || (ruleLabel = (RuleLabel)label).isAtom() || ruleLabel.isSharp()) break;
                result = HTMLConverter.ITALIC_TAG.on(result);
            }
        }
        return result;
    }

    public String toPrefixedString() {
        return String.valueOf(this.getRole().getPrefix()) + this.text();
    }
}

