/*
 * Decompiled with CFR 0.152.
 */
package groove.graph;

import groove.graph.AElementMap;
import groove.graph.Edge;
import groove.graph.ElementFactory;
import groove.graph.Node;
import groove.util.Fixable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class AElementBiMap<SN extends Node, SE extends Edge, TN extends Node, TE extends Edge>
extends AElementMap<SN, SE, TN, TE>
implements Fixable {
    private Map<TN, Set<SN>> inverseNodeMap;
    private Map<TE, Set<SE>> inverseEdgeMap;

    public AElementBiMap(ElementFactory<TN, TE> factory) {
        super(factory);
    }

    @Override
    public boolean setFixed() {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result) {
            this.getInverseNodeMap();
            this.getInverseEdgeMap();
        }
        return result;
    }

    @Override
    public boolean isFixed() {
        return this.inverseNodeMap != null;
    }

    @Override
    public void testFixed(boolean fixed) {
        if (this.isFixed() != fixed) {
            throw new IllegalStateException("Map is not fixed as expected.");
        }
    }

    public Map<TN, Set<SN>> getInverseNodeMap() {
        if (this.inverseNodeMap == null) {
            this.inverseNodeMap = this.computeInverse(this.nodeMap());
        }
        return this.inverseNodeMap;
    }

    public Map<TE, Set<SE>> getInverseEdgeMap() {
        if (this.inverseEdgeMap == null) {
            this.inverseEdgeMap = this.computeInverse(this.edgeMap());
        }
        return this.inverseEdgeMap;
    }

    private <K, V> Map<V, Set<K>> computeInverse(Map<K, V> map) {
        HashMap<V, LinkedHashSet<K>> result = new HashMap<V, LinkedHashSet<K>>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V value = entry.getValue();
            LinkedHashSet<K> keys = (LinkedHashSet<K>)result.get(value);
            if (keys == null) {
                keys = new LinkedHashSet<K>();
                result.put(value, keys);
            }
            keys.add(entry.getKey());
        }
        return result;
    }

    public Set<? extends SN> getPreImages(Node node) {
        Set<Object> result = this.getInverseNodeMap().get(node);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public Set<? extends SE> getPreImages(Edge edge) {
        Set<Object> result = this.getInverseEdgeMap().get(edge);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }
}

