/*
 * Decompiled with CFR 0.152.
 */
package groove.graph;

import groove.graph.Edge;
import groove.graph.ElementFactory;
import groove.graph.GGraph;
import groove.graph.Graph;
import groove.graph.GraphCache;
import groove.graph.GraphInfo;
import groove.graph.Label;
import groove.graph.Node;
import groove.graph.iso.CertificateStrategy;
import groove.graph.iso.PartitionRefiner;
import groove.util.Dispenser;
import groove.util.cache.AbstractCacheHolder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AGraph<N extends Node, E extends Edge>
extends AbstractCacheHolder<GraphCache<N, E>>
implements GGraph<N, E> {
    private String name = "nameless graph";
    private GraphInfo graphInfo;
    private static final boolean GATHER_STATISTICS = true;
    private static int modifiableGraphCount = 0;
    private static CertificateStrategy certificateFactory = new PartitionRefiner(null);

    protected AGraph(String name) {
        super(null);
        ++modifiableGraphCount;
        assert (name != null);
        this.name = name;
    }

    @Override
    public int nodeCount() {
        return this.nodeSet().size();
    }

    @Override
    public int edgeCount() {
        return this.edgeSet().size();
    }

    @Override
    public boolean containsNode(Node elem) {
        assert (this.isTypeCorrect(elem));
        return this.nodeSet().contains(elem);
    }

    @Override
    public boolean containsEdge(Edge elem) {
        assert (this.isTypeCorrect(elem)) : String.format("Edge %s is not of correct type", elem);
        return this.edgeSet().contains(elem);
    }

    @Override
    public int size() {
        return this.nodeCount() + this.edgeCount();
    }

    @Override
    public boolean isEmpty() {
        return this.nodeCount() == 0;
    }

    @Override
    public Set<? extends E> edgeSet(Node node) {
        assert (this.isTypeCorrect(node));
        Set result = ((GraphCache)this.getCache()).getNodeEdgeMap().get(node);
        if (result == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<? extends E> outEdgeSet(Node node) {
        assert (this.isTypeCorrect(node)) : String.format("Type %s of node %s incorrect for this graph", node.getClass().getName(), node);
        Set result = ((GraphCache)this.getCache()).getNodeOutEdgeMap().get(node);
        if (result == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<? extends E> inEdgeSet(Node node) {
        assert (this.isTypeCorrect(node));
        Set result = ((GraphCache)this.getCache()).getNodeInEdgeMap().get(node);
        if (result == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<? extends E> edgeSet(Label label) {
        assert (this.isTypeCorrect(label));
        Set result = ((GraphCache)this.getCache()).getLabelEdgeMap().get(label);
        if (result != null) {
            return Collections.unmodifiableSet(result);
        }
        return Collections.emptySet();
    }

    @Override
    public boolean hasInfo() {
        return this.graphInfo != null;
    }

    @Override
    public GraphInfo getInfo() {
        if (this.graphInfo == null) {
            assert (!this.isFixed());
            this.graphInfo = new GraphInfo();
        }
        return this.graphInfo;
    }

    @Override
    public boolean isFixed() {
        return this.isCacheCollectable();
    }

    @Override
    public boolean setFixed() {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result) {
            this.setCacheCollectable();
            if (this.hasInfo()) {
                this.getInfo().setFixed();
            }
            --modifiableGraphCount;
        }
        return result;
    }

    @Override
    public void testFixed(boolean fixed) throws IllegalStateException {
        if (this.isFixed() != fixed) {
            throw new IllegalStateException(String.format("Expected graph '%s' to be %s", this.getName(), fixed ? "fixed" : "unfixed"));
        }
    }

    public String toString() {
        return AGraph.toString(this);
    }

    protected void fireAddNode(N node) {
        if (this.hasCache()) {
            ((GraphCache)this.getCache()).addUpdate(node);
        }
    }

    protected void fireAddEdge(E edge) {
        if (this.hasCache()) {
            ((GraphCache)this.getCache()).addUpdate(edge);
        }
    }

    protected void fireRemoveNode(N node) {
        if (this.hasCache()) {
            ((GraphCache)this.getCache()).removeUpdate(node);
        }
    }

    protected void fireRemoveEdge(E edge) {
        if (this.hasCache()) {
            ((GraphCache)this.getCache()).removeUpdate(edge);
        }
    }

    protected boolean isTypeCorrect(Node node) {
        return true;
    }

    protected boolean isTypeCorrect(Label node) {
        return true;
    }

    protected boolean isTypeCorrect(Edge edge) {
        return true;
    }

    protected final N createNode(int nr) {
        return this.getFactory().createNode(nr);
    }

    protected final Dispenser getNodeCounter() {
        return ((GraphCache)this.getCache()).getNodeCounter();
    }

    protected E createEdge(N source, Label label, N target) {
        return this.getFactory().createEdge(source, label, target);
    }

    @Override
    public N addNode() {
        N freshNode = this.createNode(this.getNodeCounter().getNext());
        assert (!this.nodeSet().contains(freshNode)) : String.format("Fresh node %s already in node set %s", freshNode, this.nodeSet());
        this.addNode(freshNode);
        return freshNode;
    }

    @Override
    public N addNode(int nr) {
        N freshNode = this.createNode(nr);
        assert (!this.nodeSet().contains(freshNode)) : String.format("Fresh node %s already in node set %s", freshNode, this.nodeSet());
        this.addNode(freshNode);
        return freshNode;
    }

    @Override
    public boolean addNodeSet(Collection<? extends N> nodeSet) {
        boolean added = false;
        for (Node node : nodeSet) {
            added |= this.addNode(node);
        }
        return added;
    }

    @Override
    public E addEdge(N source, String label, N target) {
        return this.addEdge(source, this.getFactory().createLabel(label), target);
    }

    @Override
    public E addEdge(N source, Label label, N target) {
        assert (this.containsNode((Node)source));
        assert (this.containsNode((Node)target));
        E result = this.createEdge(source, label, target);
        this.addEdge(result);
        return result;
    }

    @Override
    public boolean addEdgeContext(E edge) {
        boolean added;
        assert (!this.isFixed()) : "Trying to add " + edge + " to unmodifiable graph";
        boolean bl = added = !this.containsEdge((Edge)edge);
        if (added) {
            this.addNode(edge.source());
            this.addNode(edge.target());
            this.addEdge(edge);
        }
        return added;
    }

    @Override
    public boolean addEdgeSetContext(Collection<? extends E> edgeSet) {
        boolean added = false;
        for (Edge edge : edgeSet) {
            added |= this.addEdgeContext(edge);
        }
        return added;
    }

    @Override
    public boolean removeNodeContext(N node) {
        assert (!this.isFixed()) : "Trying to remove " + node + " from unmodifiable graph";
        boolean removed = this.containsNode((Node)node);
        if (removed) {
            for (Edge edge : this.edgeSet((Node)node)) {
                this.removeEdge(edge);
            }
            this.removeNode(node);
        }
        return removed;
    }

    @Override
    public boolean removeNodeSetContext(Collection<? extends N> nodeSet) {
        boolean removed = false;
        for (Node node : nodeSet) {
            removed |= this.removeNodeContext(node);
        }
        return removed;
    }

    @Override
    public boolean removeNodeSet(Collection<? extends N> nodeSet) {
        boolean removed = false;
        for (Node node : nodeSet) {
            removed |= this.removeNode(node);
        }
        return removed;
    }

    @Override
    public boolean removeEdgeSet(Collection<? extends E> edgeSet) {
        boolean removed = false;
        for (Edge edge : edgeSet) {
            removed |= this.removeEdge(edge);
        }
        return removed;
    }

    public boolean mergeNodes(N from, N to) {
        assert (this.isTypeCorrect((Node)from));
        assert (this.isTypeCorrect((Node)to));
        if (!from.equals(to)) {
            for (Edge edge : new HashSet<E>(this.edgeSet((Node)from))) {
                Node target;
                boolean changed = false;
                Node source = edge.source();
                if (source.equals(from)) {
                    source = to;
                    changed = true;
                }
                if ((target = edge.target()).equals(from)) {
                    target = to;
                    changed = true;
                }
                if (!changed) continue;
                Label label = edge.label();
                E newEdge = this.createEdge(source, label, target);
                this.addEdge(newEdge);
                this.removeEdge(edge);
            }
            this.removeNode(from);
            return true;
        }
        return false;
    }

    @Override
    public abstract AGraph<N, E> clone();

    public boolean hasCertifier(boolean strong) {
        return this.hasCache() && ((GraphCache)this.getCache()).hasCertifier(strong);
    }

    public CertificateStrategy getCertifier(boolean strong) {
        return ((GraphCache)this.getCache()).getCertifier(strong);
    }

    @Override
    protected GraphCache createCache() {
        return new GraphCache(this);
    }

    @Override
    public ElementFactory<N, E> getFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setName(String name) {
        assert (!this.isFixed());
        assert (name != null);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static int getModifiableGraphCount() {
        return modifiableGraphCount;
    }

    public static String toString(Graph graph) {
        StringBuffer result = new StringBuffer();
        if (graph.hasInfo()) {
            result.append(graph.getInfo());
        }
        result.append(String.format("Nodes: %s%n", graph.nodeSet()));
        result.append(String.format("Edges: %s%n", graph.edgeSet()));
        return "Nodes: " + graph.nodeSet() + "; Edges: " + graph.edgeSet();
    }

    public static void setCertificateFactory(CertificateStrategy certificateFactory) {
        AGraph.certificateFactory = certificateFactory;
    }

    public static CertificateStrategy getCertificateFactory() {
        return certificateFactory;
    }
}

