/*
 * Decompiled with CFR 0.152.
 */
package groove.graph;

import groove.grammar.model.FormatError;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.graph.ElementMap;
import groove.graph.Graph;
import groove.graph.GraphProperties;
import groove.gui.layout.LayoutMap;
import groove.util.DefaultFixable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GraphInfo
extends DefaultFixable {
    private Map<String, Object> data = new HashMap<String, Object>();
    private static final String ERRORS_KEY = "errors";
    private static final String PROPERTIES_KEY = "properties";
    private static final String LAYOUT_KEY = "layout";
    private static final GraphProperties EMPTY_PROPERTIES = new GraphProperties();

    static {
        EMPTY_PROPERTIES.setFixed();
    }

    public GraphInfo() {
        this.data.put(LAYOUT_KEY, new LayoutMap());
        this.data.put(PROPERTIES_KEY, new GraphProperties());
        this.data.put(ERRORS_KEY, new FormatErrorSet());
    }

    private FormatErrorSet getErrors() {
        return (FormatErrorSet)this.data.get(ERRORS_KEY);
    }

    private void setErrors(Collection<FormatError> errors) {
        this.data.put(ERRORS_KEY, new FormatErrorSet((Collection<? extends FormatError>)errors));
    }

    private LayoutMap getLayoutMap() {
        return (LayoutMap)this.data.get(LAYOUT_KEY);
    }

    private void setLayoutMap(LayoutMap layoutMap) {
        this.getLayoutMap().load(layoutMap);
    }

    private GraphProperties getProperties() {
        return (GraphProperties)this.data.get(PROPERTIES_KEY);
    }

    private void setProperties(GraphProperties properties) {
        this.testFixed(false);
        GraphProperties props = this.getProperties();
        props.clear();
        props.putAll((Map<?, ?>)properties);
    }

    private void load(GraphInfo other) {
        this.setErrors(other.getErrors());
        this.setProperties(other.getProperties());
        this.setLayoutMap(other.getLayoutMap());
    }

    @Override
    public boolean setFixed() {
        boolean result = super.setFixed();
        if (result) {
            this.getProperties().setFixed();
            this.data = Collections.unmodifiableMap(this.data);
        }
        return result;
    }

    public String toString() {
        return "Graph information: " + this.data;
    }

    public static void transfer(Graph source, Graph target, ElementMap elementMap) {
        if (source.hasInfo()) {
            GraphInfo sourceInfo = source.getInfo();
            GraphInfo targetInfo = target.getInfo();
            targetInfo.load(sourceInfo);
            if (elementMap != null) {
                LayoutMap sourceLayoutMap = sourceInfo.getLayoutMap();
                targetInfo.setLayoutMap(sourceLayoutMap.afterInverse(elementMap));
                FormatErrorSet sourceErrors = sourceInfo.getErrors();
                targetInfo.setErrors(sourceErrors.transfer(elementMap.nodeMap()).transfer(elementMap.edgeMap()));
            }
            GraphProperties properties = sourceInfo.getProperties();
            assert (!target.isFixed());
            targetInfo.setProperties(properties);
        }
    }

    public static boolean hasErrors(Graph graph) {
        return graph.hasInfo() && !graph.getInfo().getErrors().isEmpty();
    }

    public static Collection<FormatError> getErrors(Graph graph) {
        FormatErrorSet result = graph.hasInfo() ? graph.getInfo().getErrors() : new FormatErrorSet();
        return Collections.unmodifiableCollection(result);
    }

    public static void setErrors(Graph graph, Collection<FormatError> errors) {
        if (!errors.isEmpty()) {
            assert (!graph.isFixed());
            graph.getInfo().setErrors(errors);
        }
    }

    public static void addErrors(Graph graph, Collection<FormatError> errors) {
        if (!errors.isEmpty()) {
            assert (!graph.isFixed());
            graph.getInfo().getErrors().addAll(errors);
        }
    }

    public static void throwException(Graph graph) throws FormatException {
        if (graph.hasInfo()) {
            graph.getInfo().getErrors().throwException();
        }
    }

    public static LayoutMap getLayoutMap(Graph graph) {
        LayoutMap result = null;
        if (graph.hasInfo()) {
            result = graph.getInfo().getLayoutMap();
        }
        return result;
    }

    public static void setLayoutMap(Graph graph, LayoutMap layoutMap) {
        graph.getInfo().setLayoutMap(layoutMap);
    }

    public static GraphProperties getProperties(Graph graph) {
        GraphProperties result = null;
        if (graph.hasInfo()) {
            result = graph.getInfo().getProperties().clone();
            result.setFixed();
        } else {
            result = EMPTY_PROPERTIES;
        }
        return result;
    }

    public static void setProperties(Graph graph, GraphProperties properties) {
        assert (!graph.isFixed());
        graph.getInfo().setProperties(properties);
    }

    public static int getPriority(Graph graph) {
        return Integer.parseInt(GraphInfo.getProperty(graph, GraphProperties.Key.PRIORITY));
    }

    public static void setPriority(Graph graph, int priority) {
        GraphInfo.setProperty(graph, GraphProperties.Key.PRIORITY, "" + priority);
    }

    public static boolean isEnabled(Graph graph) {
        return Boolean.parseBoolean(GraphInfo.getProperty(graph, GraphProperties.Key.ENABLED));
    }

    public static void setEnabled(Graph graph, boolean enabled) {
        GraphInfo.setProperty(graph, GraphProperties.Key.ENABLED, Boolean.toString(enabled));
    }

    public static String getRemark(Graph graph) {
        return GraphInfo.getProperty(graph, GraphProperties.Key.REMARK);
    }

    public static void setRemark(Graph graph, String remark) {
        GraphInfo.setProperty(graph, GraphProperties.Key.REMARK, remark);
    }

    public static String getFormatString(Graph graph) {
        return GraphInfo.getProperty(graph, GraphProperties.Key.FORMAT);
    }

    public static void setFormatString(Graph graph, String formatString) {
        GraphInfo.setProperty(graph, GraphProperties.Key.FORMAT, formatString);
    }

    public static String getTransitionLabel(Graph graph) {
        return GraphInfo.getProperty(graph, GraphProperties.Key.TRANSITION_LABEL);
    }

    public static void setTransitionLabel(Graph graph, String label) {
        GraphInfo.setProperty(graph, GraphProperties.Key.TRANSITION_LABEL, label);
    }

    public static String getVersion(Graph graph) {
        return GraphInfo.getProperty(graph, GraphProperties.Key.VERSION);
    }

    private static String getProperty(Graph graph, GraphProperties.Key key) {
        String result = graph.hasInfo() ? graph.getInfo().getProperties().getProperty(key) : key.getDefaultValue();
        return result;
    }

    private static void setProperty(Graph graph, GraphProperties.Key key, String value) {
        GraphProperties properties = graph.getInfo().getProperties();
        properties.setProperty(key, value);
    }
}

