/*
 * Decompiled with CFR 0.152.
 */
package groove.graph.iso;

import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.type.TypeLabel;
import groove.graph.Edge;
import groove.graph.Graph;
import groove.graph.Label;
import groove.graph.Node;
import groove.graph.iso.CertificateStrategy;
import groove.util.collect.TreeHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.TreeMap;

public class PaigeTarjanMcKay
extends CertificateStrategy {
    private final boolean strong;
    NodePartition partition;
    private int iterateCount;
    private List<List<Block>> partitionRecord;
    private static final int TREE_RESOLUTION = 3;
    private static final boolean SPLIT_ONE_AT_A_TIME = false;
    private static final boolean BREAK_DUPLICATES = false;
    private static int totalSymmetryBreakCount;
    private static final int INT_WIDTH = 32;
    private static final boolean RECORD = false;

    public PaigeTarjanMcKay(Graph graph) {
        this(graph, true);
    }

    public PaigeTarjanMcKay(Graph graph, boolean strong) {
        super(graph);
        this.strong = strong;
    }

    @Override
    public PaigeTarjanMcKay newInstance(Graph graph, boolean strong) {
        return new PaigeTarjanMcKay(graph, strong);
    }

    @Override
    public int getNodePartitionCount() {
        if (this.partition == null) {
            this.computeCertificates();
        }
        return this.partition.size();
    }

    @Override
    public boolean getStrength() {
        return this.strong;
    }

    @Override
    void iterateCertificates() {
        this.partition = new NodePartition(this.nodeCerts);
        LinkedList<Block> splitters = new LinkedList<Block>();
        Iterator iter = this.partition.sortedIterator();
        while (iter.hasNext()) {
            Block block = (Block)iter.next();
            block.setSplitter(true);
            splitters.add(block);
        }
        this.split(splitters);
        if (this.strong && this.partition.size() < this.nodeCertCount) {
            Block nontrivialBlock;
            while ((nontrivialBlock = this.selectNontrivialBlock()) != null) {
                this.checkpointCertificates();
                MyNodeCert[] myNodeCertArray = nontrivialBlock.getNodes().toArray();
                int n = myNodeCertArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MyNodeCert duplicate = myNodeCertArray[n2];
                    duplicate.breakSymmetry();
                    this.split(new LinkedList<Block>(duplicate.getBlock().split()));
                    this.rollBackCertificates();
                    this.partition = new NodePartition(this.nodeCerts);
                    ++n2;
                }
                this.accumulateCertificates();
                this.partition = new NodePartition(this.nodeCerts);
            }
        }
    }

    private void split(Queue<Block> splitterList) {
        while (!splitterList.isEmpty()) {
            if (splitterList.peek().size() > 0) {
                this.splitNext(splitterList);
                ++this.iterateCount;
                continue;
            }
            splitterList.poll();
        }
        PaigeTarjanMcKay.recordIterateCount(this.iterateCount);
    }

    private void splitNext(Queue<Block> splitterList) {
        NodePartition splitBlocks = new NodePartition();
        this.markNodes(splitterList.poll(), splitBlocks);
        while (!splitterList.isEmpty()) {
            this.markNodes(splitterList.poll(), splitBlocks);
        }
        Iterator splitBlockIter = splitBlocks.sortedIterator();
        while (splitBlockIter.hasNext()) {
            Block block = (Block)splitBlockIter.next();
            Collection<Block> newBlocks = block.split();
            splitterList.addAll(newBlocks);
        }
    }

    private void markNodes(Block splitter, NodePartition splitBlocks) {
        MyNodeCert[] myNodeCertArray = splitter.getNodes().toArray();
        int n = myNodeCertArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isNew;
            Block splitBlock;
            MyNodeCert splitterNode = myNodeCertArray[n2];
            for (MyEdge2Cert outEdge : splitterNode.getOutEdges()) {
                outEdge.updateTarget();
                splitBlock = outEdge.getTarget().mark();
                if (splitBlock == null) continue;
                isNew = splitBlocks.add(splitBlock);
                assert (isNew);
            }
            for (MyEdge2Cert inEdge : splitterNode.getInEdges()) {
                inEdge.updateSource();
                splitBlock = inEdge.getSource().mark();
                if (splitBlock == null) continue;
                isNew = splitBlocks.add(splitBlock);
                assert (isNew);
            }
            ++n2;
        }
        splitter.setSplitter(false);
    }

    private void checkpointCertificates() {
        int i = 0;
        while (i < this.nodeCerts.length) {
            MyNodeCert nodeCert = (MyNodeCert)this.nodeCerts[i];
            nodeCert.setCheckpoint();
            ++i;
        }
    }

    private void rollBackCertificates() {
        int i = 0;
        while (i < this.nodeCerts.length) {
            MyNodeCert nodeCert = (MyNodeCert)this.nodeCerts[i];
            nodeCert.rollBack();
            ++i;
        }
    }

    private void accumulateCertificates() {
        int i = 0;
        while (i < this.nodeCerts.length) {
            MyNodeCert nodeCert = (MyNodeCert)this.nodeCerts[i];
            nodeCert.accumulate(this.iterateCount);
            ++i;
        }
    }

    private Block selectNontrivialBlock() {
        Block result = null;
        int i = 0;
        while (i < this.nodeCerts.length) {
            Block block;
            MyNodeCert nodeCert = (MyNodeCert)this.nodeCerts[i];
            if (!(nodeCert.isBroken() || (block = nodeCert.getBlock()).size() <= 1 || result != null && nodeCert.getValue() >= result.getValue())) {
                result = block;
            }
            ++i;
        }
        return result;
    }

    @Override
    MyValueNodeCert createValueNodeCertificate(ValueNode node) {
        return new MyValueNodeCert(node);
    }

    @Override
    MyNodeCert createNodeCertificate(Node node) {
        return new MyNodeCert(node);
    }

    @Override
    MyEdge1Cert createEdge1Certificate(Edge edge, CertificateStrategy.NodeCertificate source) {
        return new MyEdge1Cert(edge, (MyNodeCert)source);
    }

    @Override
    CertificateStrategy.EdgeCertificate createEdge2Certificate(Edge edge, CertificateStrategy.NodeCertificate source, CertificateStrategy.NodeCertificate target) {
        return new MyEdge2Cert(edge, (MyNodeCert)source, (MyNodeCert)target);
    }

    public static int getSymmetryBreakCount() {
        return totalSymmetryBreakCount;
    }

    private class Block
    implements Comparable<Block>,
    Cloneable {
        private int value;
        private NodeCertificateList nodes;
        private int size;
        private NodeCertificateList markedNodes;
        private int markedSize;
        private boolean splitter;

        Block(int value) {
            this.value = value;
            this.nodes = new NodeCertificateList(this);
            this.markedNodes = new NodeCertificateList(this);
            PaigeTarjanMcKay.this.graphCertificate += (long)this.value;
        }

        boolean isSplitter() {
            return this.splitter;
        }

        void setSplitter(boolean splitter) {
            this.splitter = splitter;
        }

        boolean isFinal() {
            return !this.isSplitter() && this.size == 1;
        }

        NodeCertificateList getNodes() {
            return this.nodes;
        }

        Collection<Block> split() {
            if (this.size == 1) {
                PaigeTarjanMcKay.this.partition.remove(this);
                MyNodeCert node = this.markedNodes.first();
                node.unmark();
                node.insertAfter(this.nodes);
                this.markedSize = 0;
                int oldValue = this.value;
                this.value = node.setNextValue();
                PaigeTarjanMcKay.this.partition.add(this, oldValue);
                return Collections.emptySet();
            }
            TreeMap<Integer, Block> blockMap = new TreeMap<Integer, Block>();
            Block lastBlock = null;
            Block largestBlock = null;
            int largestSize = 0;
            int largestValue = 0;
            for (MyNodeCert markedNode : this.markedNodes) {
                markedNode.unmark();
                int newValue = markedNode.setNextValue();
                if ((lastBlock == null || lastBlock.value != newValue) && (lastBlock = (Block)blockMap.get(newValue)) == null) {
                    lastBlock = new Block(newValue);
                    blockMap.put(newValue, lastBlock);
                    lastBlock.setSplitter(true);
                }
                lastBlock.add(markedNode);
                if (lastBlock.size() <= largestSize && (lastBlock.size() != largestSize || newValue <= largestValue)) continue;
                largestSize = lastBlock.size();
                largestValue = newValue;
                largestBlock = lastBlock;
            }
            this.size -= this.markedSize;
            this.markedSize = 0;
            for (Block newBlock : blockMap.values()) {
                PaigeTarjanMcKay.this.partition.add(newBlock, this.value);
            }
            if (this.size == 0) {
                PaigeTarjanMcKay.this.partition.remove(this);
            }
            if (!this.isSplitter() && this.size < largestSize) {
                largestBlock.setSplitter(false);
                blockMap.remove(largestValue);
                if (this.size > 0) {
                    this.setSplitter(true);
                    blockMap.put(this.value, this);
                }
            }
            return blockMap.values();
        }

        final void add(MyNodeCert node) {
            node.insertAfter(this.nodes);
            ++this.size;
        }

        final int size() {
            return this.size;
        }

        final int markedSize() {
            return this.markedSize;
        }

        int getValue() {
            return this.value;
        }

        void setValue(int value) {
            this.value = value;
        }

        boolean markNode(MyNodeCert node) {
            assert (node.getBlock() == this);
            boolean result = this.markedSize == 0;
            node.insertAfter(this.markedNodes);
            ++this.markedSize;
            return result;
        }

        @Override
        public int compareTo(Block other) {
            int result = this.size() - other.size();
            if (result != 0) {
                return result;
            }
            return this.value < other.value ? -1 : (this.value > other.value ? 1 : 0);
        }

        public boolean equals(Object obj) {
            return obj instanceof Block && ((Block)obj).value == this.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            ArrayList<Node> content = new ArrayList<Node>();
            for (MyNodeCert nodeCert : this.getNodes()) {
                content.add(nodeCert.getElement());
            }
            return String.format("B%dx%d%s", this.size, this.value, content);
        }

        public Block clone() {
            try {
                Block result = (Block)super.clone();
                result.nodes = new NodeCertificateList(result);
                for (MyNodeCert node : this.getNodes()) {
                    result.add(node.clone());
                }
                result.size = this.size;
                result.markedNodes = new NodeCertificateList(result);
                for (MyNodeCert markedNode : this.markedNodes) {
                    markedNode.clone().insertAfter(result.markedNodes);
                }
                result.markedSize = this.markedSize;
                return result;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    private class MyEdge1Cert
    implements CertificateStrategy.EdgeCertificate {
        private final Edge edge;
        private final Label label;
        private final MyNodeCert sourceCert;
        protected final int initValue;
        private final int value;

        MyEdge1Cert(Edge edge, MyNodeCert sourceCert) {
            this.edge = edge;
            this.sourceCert = sourceCert;
            this.label = edge.label();
            this.value = this.initValue = this.label.hashCode();
            sourceCert.addSelf(this);
        }

        @Override
        public final Edge getElement() {
            return this.edge;
        }

        public int hashCode() {
            return this.sourceCert.hashCode() + this.initValue;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MyEdge1Cert)) {
                return false;
            }
            MyEdge1Cert other = (MyEdge1Cert)obj;
            return other.sourceCert.equals(this.sourceCert) && other.label.equals(this.label);
        }

        public String toString() {
            return "[" + this.getSource() + "," + this.label + "(" + this.label.hashCode() + ")]";
        }

        @Override
        public final int getValue() {
            return this.value;
        }

        @Override
        public void modifyValue(int mod) {
        }

        final MyNodeCert getSource() {
            return this.sourceCert;
        }
    }

    private class MyEdge2Cert
    extends MyEdge1Cert {
        private final MyNodeCert targetCert;

        MyEdge2Cert(Edge edge, MyNodeCert sourceCert, MyNodeCert targetCert) {
            super(edge, sourceCert);
            this.targetCert = targetCert;
            sourceCert.addOutEdge(this);
            targetCert.addInEdge(this);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + (this.getTarget().hashCode() << 2);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            return obj instanceof MyEdge2Cert && ((MyEdge2Cert)obj).getTarget().equals(this.getTarget());
        }

        @Override
        public String toString() {
            return "[" + this.getSource() + "," + this.getElement().label() + "(" + this.initValue + ")," + this.getTarget() + "]";
        }

        MyNodeCert getTarget() {
            return this.targetCert;
        }

        void updateSource() {
            this.getSource().addNextValue(3 * this.computeValue());
        }

        void updateTarget() {
            this.getTarget().addNextValue(-5 * this.computeValue());
        }

        private int computeValue() {
            int shift = (this.initValue & 0xF) + 1;
            int targetValue = this.targetCert.getValue();
            int sourceValue = this.getSource().getValue();
            int result = (sourceValue << shift | sourceValue >>> 32 - shift) + (targetValue >>> shift | targetValue << 32 - shift) + this.initValue;
            PaigeTarjanMcKay.this.graphCertificate += (long)result;
            return result;
        }
    }

    private class MyNodeCert
    implements CertificateStrategy.NodeCertificate,
    Cloneable {
        private static final int INIT_NODE_VALUE = 4715;
        private int nextValue;
        int value;
        private final Node element;
        private final TypeLabel label;
        private final List<MyEdge2Cert> inEdges = new ArrayList<MyEdge2Cert>();
        private final List<MyEdge2Cert> outEdges = new ArrayList<MyEdge2Cert>();
        private Block block;
        MyNodeCert next;
        MyNodeCert prev;
        private boolean marked;
        private int checkpointValue;
        private int cumulativeValue;
        private boolean broken;
        static final int TARGET_MASK = 21845;

        MyNodeCert(Block block) {
            this((Node)null);
            this.block = block;
            this.value = block.value;
        }

        public MyNodeCert(Node node) {
            this.element = node;
            if (node instanceof HostNode) {
                this.label = ((HostNode)node).getType().label();
                this.value = this.label.hashCode();
            } else {
                this.label = null;
                this.value = 4715;
            }
            this.next = this;
            this.prev = this;
        }

        public String toString() {
            return "c" + this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MyNodeCert)) {
                return false;
            }
            MyNodeCert other = (MyNodeCert)obj;
            if (this.value != other.value) {
                return false;
            }
            if (this.label == null) {
                return true;
            }
            return this.label.equals(other.label);
        }

        public int hashCode() {
            return this.value;
        }

        protected MyNodeCert clone() throws CloneNotSupportedException {
            return (MyNodeCert)super.clone();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public void modifyValue(int mod) {
            this.value += mod;
        }

        void setValue(int value) {
            this.value = value;
        }

        void addNextValue(int value) {
            this.nextValue += value;
        }

        int setNextValue() {
            this.value += this.nextValue;
            this.nextValue = 0;
            PaigeTarjanMcKay.this.graphCertificate += (long)this.value;
            return this.value;
        }

        @Override
        public Node getElement() {
            return this.element;
        }

        void addSelf(MyEdge1Cert edgeCert) {
            this.value += edgeCert.getValue();
        }

        void addOutEdge(MyEdge2Cert edgeCert) {
            this.outEdges.add(edgeCert);
            this.value += edgeCert.getValue();
        }

        void addInEdge(MyEdge2Cert edgeCert) {
            this.inEdges.add(edgeCert);
            this.value += edgeCert.getValue() ^ 0x5555;
        }

        List<MyEdge2Cert> getInEdges() {
            return this.inEdges;
        }

        List<MyEdge2Cert> getOutEdges() {
            return this.outEdges;
        }

        final Block getBlock() {
            return this.block;
        }

        final void setBlock(Block container) {
            this.block = container;
        }

        void insertAfter(MyNodeCert other) {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.block = other.getBlock();
            this.prev = other;
            this.next = other.next;
            other.next = this;
            this.next.prev = this;
        }

        Block mark() {
            if (this.block.isFinal()) {
                this.nextValue = 0;
                return null;
            }
            if (this.marked) {
                return null;
            }
            this.marked = true;
            return this.getBlock().markNode(this) ? this.getBlock() : null;
        }

        void unmark() {
            this.marked = false;
        }

        void breakSymmetry() {
            this.value ^= this.value << 5 ^ this.value >> 3;
            this.broken = true;
            this.mark();
        }

        final boolean isBroken() {
            return this.broken;
        }

        void setCheckpoint() {
            this.checkpointValue = this.value;
        }

        void rollBack() {
            this.cumulativeValue += this.value;
            this.value = this.checkpointValue;
        }

        void accumulate(int round) {
            this.value += this.cumulativeValue;
            this.cumulativeValue = 0;
        }
    }

    private class MyValueNodeCert
    extends MyNodeCert {
        private final Object nodeValue;

        public MyValueNodeCert(ValueNode node) {
            super(node);
            this.nodeValue = node.getValue();
            this.value = this.nodeValue.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof MyValueNodeCert && this.nodeValue.equals(((MyValueNodeCert)obj).nodeValue);
        }
    }

    private class NodeCertificateList
    extends MyNodeCert
    implements Iterable<MyNodeCert> {
        NodeCertificateList(Block block) {
            super(block);
        }

        @Override
        public Iterator<MyNodeCert> iterator() {
            return new Iterator<MyNodeCert>(){
                private MyNodeCert next;

                @Override
                public boolean hasNext() {
                    if (this.next == null) {
                        this.next = NodeCertificateList.this.next;
                    }
                    return this.next != NodeCertificateList.this;
                }

                @Override
                public MyNodeCert next() {
                    if (this.hasNext()) {
                        MyNodeCert result = this.next;
                        this.next = this.next.next;
                        return result;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        MyNodeCert first() {
            return this.next == this ? null : this.next;
        }

        MyNodeCert[] toArray() {
            assert (this == this.getBlock().getNodes());
            MyNodeCert[] result = new MyNodeCert[this.getBlock().size() - this.getBlock().markedSize()];
            int i = 0;
            MyNodeCert cert = this.next;
            while (cert != this) {
                result[i] = cert;
                cert = cert.next;
                ++i;
            }
            return result;
        }
    }

    private class NodePartition
    extends TreeHashSet<Block> {
        NodePartition() {
            super(3);
        }

        NodePartition(CertificateStrategy.NodeCertificate[] nodes) {
            super(3);
            int i = 0;
            while (i < nodes.length) {
                MyNodeCert nodeCert = (MyNodeCert)nodes[i];
                nodeCert.setNextValue();
                Block block = new Block(nodeCert.getValue());
                Block previous = this.put(block);
                if (previous != null) {
                    block = previous;
                }
                block.add(nodeCert);
                ++i;
            }
        }

        @Override
        protected boolean allEqual() {
            return true;
        }

        void add(Block block, int incr) {
            boolean isNew = this.add(block);
            if (!isNew) {
                incr = incr == 0 ? 1 : incr;
                int newValue = block.getValue();
                do {
                    block.setValue(newValue += ++incr);
                } while (!(isNew = this.add(block)));
                for (MyNodeCert node : block.getNodes()) {
                    node.setValue(newValue);
                }
            }
        }
    }
}

