/*
 * Decompiled with CFR 0.152.
 */
package groove.graph.plain;

import groove.graph.AGraph;
import groove.graph.Edge;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.graph.plain.PlainEdge;
import groove.graph.plain.PlainFactory;
import groove.graph.plain.PlainNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class PlainGraph
extends AGraph<PlainNode, PlainEdge>
implements Cloneable {
    private final Map<PlainNode, Set<PlainEdge>> edgeMap = new LinkedHashMap<PlainNode, Set<PlainEdge>>();
    private GraphRole role = GraphRole.NONE;

    public static PlainGraph getPrototype() {
        return new PlainGraph("nameless graph");
    }

    public PlainGraph(String name) {
        super(name);
    }

    protected PlainGraph(PlainGraph graph) {
        super(graph.getName());
        for (Map.Entry<PlainNode, Set<PlainEdge>> edgeEntry : graph.edgeMap.entrySet()) {
            this.edgeMap.put(edgeEntry.getKey(), new LinkedHashSet(edgeEntry.getValue()));
        }
    }

    @Override
    public boolean containsNode(Node node) {
        return this.edgeMap.containsKey(node);
    }

    @Override
    public boolean containsEdge(Edge edge) {
        Set<PlainEdge> edgeSet = this.edgeMap.get(edge.source());
        return edgeSet != null && edgeSet.contains(edge);
    }

    @Override
    public Set<? extends PlainEdge> edgeSet() {
        LinkedHashSet result = new LinkedHashSet();
        for (Map.Entry<PlainNode, Set<PlainEdge>> edgeEntry : this.edgeMap.entrySet()) {
            result.addAll(edgeEntry.getValue());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<? extends PlainEdge> outEdgeSet(Node node) {
        return Collections.unmodifiableSet(this.edgeMap.get(node));
    }

    @Override
    public Set<? extends PlainNode> nodeSet() {
        return Collections.unmodifiableSet(this.edgeMap.keySet());
    }

    @Override
    public PlainGraph clone() {
        PlainGraph result = new PlainGraph(this);
        return result;
    }

    @Override
    public PlainGraph newGraph(String name) {
        return new PlainGraph(this.getName());
    }

    public PlainFactory getFactory() {
        return PlainFactory.instance();
    }

    @Override
    public boolean addNode(PlainNode node) {
        boolean added;
        assert (!this.isFixed()) : "Trying to add " + node + " to unmodifiable graph";
        boolean bl = added = !this.containsNode(node);
        if (added) {
            this.edgeMap.put(node, new LinkedHashSet());
            this.fireAddNode(node);
        }
        return added;
    }

    @Override
    public boolean addEdge(PlainEdge edge) {
        assert (this.isTypeCorrect(edge));
        assert (!this.isFixed()) : "Trying to add " + edge + " to unmodifiable graph";
        Set<PlainEdge> sourceOutEdges = this.edgeMap.get(edge.source());
        boolean added = sourceOutEdges.add(edge);
        if (added) {
            this.fireAddEdge(edge);
        }
        return added;
    }

    @Override
    public boolean removeEdge(PlainEdge edge) {
        boolean removed;
        assert (!this.isFixed()) : "Trying to remove " + edge + " from unmodifiable graph";
        Set<PlainEdge> outEdgeSet = this.edgeMap.get(edge.source());
        boolean bl = removed = outEdgeSet != null && outEdgeSet.remove(edge);
        if (removed) {
            this.fireRemoveEdge(edge);
        }
        return removed;
    }

    @Override
    public boolean removeNodeContext(PlainNode node) {
        assert (!this.isFixed()) : "Trying to remove " + node + " from unmodifiable graph";
        boolean result = false;
        Set<PlainEdge> outEdges = this.edgeMap.remove(node);
        if (outEdges != null) {
            result = true;
            for (PlainEdge plainEdge : outEdges) {
                this.fireRemoveEdge(plainEdge);
            }
            for (Set set : this.edgeMap.values()) {
                Iterator edgeIter = set.iterator();
                while (edgeIter.hasNext()) {
                    PlainEdge edge = (PlainEdge)edgeIter.next();
                    if (!((PlainNode)edge.source()).equals(node) && !((PlainNode)edge.target()).equals(node)) continue;
                    edgeIter.remove();
                    this.fireRemoveEdge(edge);
                }
            }
            this.fireRemoveNode(node);
        }
        return result;
    }

    @Override
    public boolean removeNode(PlainNode node) {
        assert (!this.isFixed()) : "Trying to remove " + node + " from unmodifiable graph";
        boolean result = false;
        Set<PlainEdge> outEdges = this.edgeMap.remove(node);
        if (outEdges != null) {
            result = true;
            this.fireRemoveNode(node);
        }
        return result;
    }

    @Override
    public final GraphRole getRole() {
        return this.role;
    }

    public final void setRole(GraphRole role) {
        this.role = role;
    }
}

