/*
 * Decompiled with CFR 0.152.
 */
package groove.gui;

import groove.explore.Exploration;
import groove.explore.util.ExplorationStatistics;
import groove.grammar.Grammar;
import groove.grammar.GrammarProperties;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.GraphBasedModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.ResourceModel;
import groove.grammar.model.TextBasedModel;
import groove.grammar.type.TypeLabel;
import groove.graph.GraphInfo;
import groove.gui.SimulatorListener;
import groove.gui.display.DisplayKind;
import groove.gui.list.SearchResult;
import groove.io.store.DefaultFileSystemStore;
import groove.io.store.SystemStore;
import groove.lts.GTS;
import groove.lts.GTSAdapter;
import groove.lts.GTSCounter;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.lts.MatchResult;
import groove.lts.RuleTransition;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimulatorModel
implements Cloneable {
    private SimulatorModel old;
    private Set<Change> changes = EnumSet.noneOf(Change.class);
    private GTS gts;
    private GraphState state;
    private MatchResult match;
    private GraphTransition trans;
    private final Set<RuleTransition> trace = new HashSet<RuleTransition>();
    private Map<ResourceKind, Set<String>> resources = new EnumMap<ResourceKind, Set<String>>(ResourceKind.class);
    private GrammarModel grammar;
    private Exploration exploration;
    private ExplorationStatistics explorationStats;
    private boolean abstractionMode;
    private DisplayKind display;
    private final Map<Change, List<SimulatorListener>> listeners;
    private final MyLTSListener ltsListener;
    private final GTSCounter gtsCounter;

    public SimulatorModel() {
        for (ResourceKind resource : ResourceKind.all(false)) {
            this.resources.put(resource, Collections.emptySet());
        }
        this.exploration = new Exploration();
        this.abstractionMode = false;
        this.display = DisplayKind.HOST;
        this.listeners = new EnumMap<Change, List<SimulatorListener>>(Change.class);
        Change[] changeArray = Change.values();
        int n = changeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Change change = changeArray[n2];
            this.listeners.put(change, new ArrayList());
            ++n2;
        }
        this.ltsListener = new MyLTSListener();
        this.gtsCounter = new GTSCounter();
    }

    public void doDelete(ResourceKind resource, Set<String> names) throws IOException {
        this.start();
        try {
            boolean change = new HashSet<String>(names).removeAll(this.getGrammar().getActiveNames(resource));
            switch (resource) {
                case CONTROL: 
                case PROLOG: 
                case GROOVY: {
                    this.getStore().deleteTexts(resource, names);
                    break;
                }
                case HOST: 
                case RULE: 
                case TYPE: {
                    this.getStore().deleteGraphs(resource, names);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.changeGrammar(change);
        }
        finally {
            this.finish();
        }
    }

    public boolean doRename(ResourceKind resource, String oldName, String newName) throws IOException {
        boolean result = false;
        this.start();
        try {
            result = this.getGrammar().getActiveNames(resource).contains(oldName);
            this.getStore().rename(resource, oldName, newName);
            this.changeSelected(resource, newName);
            this.changeGrammar(result);
            this.changeDisplay(DisplayKind.toDisplay(resource));
        }
        finally {
            this.finish();
        }
        return result;
    }

    public boolean doEnable(ResourceKind resource, Set<String> names) throws IOException {
        this.start();
        boolean result = true;
        try {
            this.setEnabled(resource, names);
            this.changeDisplay(DisplayKind.toDisplay(resource));
            this.changeGrammar(result);
        }
        finally {
            this.finish();
        }
        return result;
    }

    private void setEnabled(ResourceKind kind, Set<String> names) throws IOException {
        switch (kind) {
            case RULE: {
                ArrayList<AspectGraph> newRules = new ArrayList<AspectGraph>(names.size());
                for (String ruleName : names) {
                    AspectGraph oldRule = this.getStore().getGraphs(ResourceKind.RULE).get(ruleName);
                    AspectGraph newRule = oldRule.clone();
                    GraphInfo.setEnabled(newRule, !GraphInfo.isEnabled(oldRule));
                    newRule.setFixed();
                    newRules.add(newRule);
                }
                this.getStore().putGraphs(ResourceKind.RULE, newRules, false);
                break;
            }
            case HOST: 
            case TYPE: 
            case CONTROL: 
            case PROLOG: {
                GrammarProperties newProperties = this.getGrammar().getProperties().clone();
                ArrayList<String> actives = new ArrayList<String>(newProperties.getActiveNames(kind));
                for (String typeName : names) {
                    if (actives.remove(typeName)) continue;
                    actives.add(typeName);
                }
                newProperties.setActiveNames(kind, actives);
                this.getStore().putProperties(newProperties);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public boolean doEnableUniquely(ResourceKind kind, String name) throws IOException {
        this.start();
        boolean result = true;
        try {
            this.setEnabledUniquely(kind, name);
            this.changeDisplay(DisplayKind.toDisplay(kind));
            this.changeGrammar(result);
        }
        finally {
            this.finish();
        }
        return result;
    }

    private void setEnabledUniquely(ResourceKind kind, String name) throws IOException {
        switch (kind) {
            case HOST: 
            case TYPE: 
            case CONTROL: 
            case PROLOG: {
                GrammarProperties newProperties = this.getGrammar().getProperties().clone();
                newProperties.setActiveNames(kind, Collections.singleton(name));
                this.getStore().putProperties(newProperties);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public boolean doAddGraph(ResourceKind kind, AspectGraph newGraph, boolean layout) throws IOException {
        assert (newGraph.isFixed());
        this.start();
        try {
            String name = newGraph.getName();
            boolean oldEnabled = this.isEnabled(kind, name);
            this.getStore().putGraphs(kind, Collections.singleton(newGraph), layout);
            if (layout) {
                return false;
            }
            boolean result = this.isEnabled(kind, name) || oldEnabled;
            this.changeGrammar(result);
            this.changeSelected(kind, name);
            this.changeDisplay(DisplayKind.toDisplay(kind));
            boolean bl = result;
            return bl;
        }
        finally {
            this.finish();
        }
    }

    private boolean isEnabled(ResourceKind kind, String name) {
        return this.getGrammar().getActiveNames(kind).contains(name);
    }

    public boolean doAddText(ResourceKind kind, String name, String program) throws IOException {
        this.start();
        try {
            GrammarModel grammar = this.getGrammar();
            boolean result = grammar.getActiveNames(kind).contains(name);
            this.getStore().putTexts(kind, Collections.singletonMap(name, program));
            this.changeGrammar(result);
            this.changeSelected(kind, name);
            this.changeDisplay(DisplayKind.toDisplay(kind));
            boolean bl = result;
            return bl;
        }
        finally {
            this.finish();
        }
    }

    public boolean doSetPriority(Map<String, Integer> priorityMap) throws IOException {
        this.start();
        ResourceKind resource = ResourceKind.RULE;
        HashSet<AspectGraph> newGraphs = new HashSet<AspectGraph>();
        for (Map.Entry<String, Integer> entry : priorityMap.entrySet()) {
            AspectGraph oldGraph = this.getStore().getGraphs(resource).get(entry.getKey());
            AspectGraph newGraph = oldGraph.clone();
            GraphInfo.setPriority(newGraph, entry.getValue());
            newGraph.setFixed();
            newGraphs.add(newGraph);
        }
        try {
            this.getStore().putGraphs(resource, newGraphs, false);
            this.changeGrammar(true);
            this.changeDisplay(DisplayKind.toDisplay(resource));
            return true;
        }
        finally {
            this.finish();
        }
    }

    public boolean doSetDefaultExploration(Exploration exploration) throws IOException {
        GrammarProperties properties = this.getGrammar().getProperties();
        GrammarProperties newProperties = properties.clone();
        newProperties.setExploration(exploration.toParsableString());
        return this.doSetProperties(newProperties);
    }

    public boolean doSetProperties(GrammarProperties newProperties) throws IOException {
        this.start();
        try {
            this.getStore().putProperties(newProperties);
            this.changeGrammar(true);
            return true;
        }
        finally {
            this.finish();
        }
    }

    public boolean doSetStartGraph(AspectGraph graph) {
        this.start();
        try {
            this.getGrammar().setStartGraph(graph);
            this.changeGrammar(true);
            this.changeDisplay(DisplayKind.HOST);
            return true;
        }
        finally {
            this.finish();
        }
    }

    public boolean doNewGrammar(File grammarFile) throws IOException {
        GrammarModel grammar = GrammarModel.newInstance(grammarFile, true);
        this.setGrammar(grammar);
        return true;
    }

    public boolean doRefreshGrammar() throws IOException {
        this.start();
        try {
            boolean result = false;
            if (this.getStore() != null) {
                this.getStore().reload();
                this.changeGrammar(true);
                result = true;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.finish();
        }
    }

    public boolean doRelabel(TypeLabel oldLabel, TypeLabel newLabel) throws IOException {
        this.start();
        try {
            this.getStore().relabel(oldLabel, newLabel);
            this.changeGrammar(true);
            return true;
        }
        finally {
            this.finish();
        }
    }

    public boolean doRenumber() throws IOException {
        this.start();
        try {
            boolean result = false;
            if (this.getStore() instanceof DefaultFileSystemStore) {
                ((DefaultFileSystemStore)this.getStore()).renumber();
                this.changeGrammar(true);
                result = true;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.finish();
        }
    }

    public final boolean doSetStateAndMatch(GraphState state, RuleTransition trans) {
        assert (state != null);
        this.start();
        if (trans != null) {
            assert (state == trans.target());
            assert (this.old.match != null && this.old.match.equals(trans.getKey()));
            this.old.trans = trans;
        }
        this.changeGts();
        this.changeState(state);
        MatchResult match = this.getMatch(state);
        this.changeMatch(match);
        this.changeTransition(match != null && match.hasRuleTransitionFrom(state) ? match.getRuleTransition() : null);
        if (this.getDisplay() != DisplayKind.LTS) {
            this.changeDisplay(DisplayKind.STATE);
        }
        return this.finish();
    }

    private MatchResult getMatch(GraphState state) {
        MatchResult result = state.getMatch();
        if (result == null) {
            for (RuleTransition trans : state.getRuleTransitions()) {
                if (trans.target() == state) continue;
                result = trans.getKey();
                if (!trans.target().isClosed()) break;
            }
        }
        return result;
    }

    public final boolean hasGts() {
        return this.getGts() != null;
    }

    public final GTS getGts() {
        return this.gts;
    }

    public final boolean refreshGts() {
        this.start();
        this.changeGts();
        return this.finish();
    }

    private final boolean changeGts() {
        boolean result = this.ltsListener.isChanged();
        if (result) {
            this.ltsListener.clear();
            this.changes.add(Change.GTS);
        }
        return result;
    }

    public final boolean setGts(GTS gts, boolean switchTab) {
        this.start();
        if (this.changeGts(gts, false)) {
            this.changeState(gts == null ? null : gts.startState());
            this.changeMatch(null);
            this.changeTransition(null);
            this.trace.clear();
        } else if (this.ltsListener.isChanged()) {
            this.ltsListener.clear();
            this.changes.add(Change.GTS);
        }
        if (gts != null && this.getState() == null) {
            this.changeState(gts.startState());
        }
        if (switchTab && this.getDisplay() != DisplayKind.STATE) {
            this.changeDisplay(DisplayKind.LTS);
        }
        return this.finish();
    }

    public final boolean setGts() {
        try {
            Grammar grammar = this.getGrammar().toGrammar();
            GTS gts = new GTS(grammar);
            gts.getRecord().setRandomAccess(true);
            return this.setGts(gts, false);
        }
        catch (FormatException formatException) {
            return this.setGts(null, false);
        }
    }

    private final boolean changeGts(GTS gts, boolean always) {
        boolean result;
        boolean bl = result = always || this.gts != gts;
        if (result) {
            if (this.gts != null) {
                this.gts.removeLTSListener(this.ltsListener);
            }
            if (gts != null) {
                gts.addLTSListener(this.ltsListener);
            }
            this.gtsCounter.setGTS(gts);
            this.ltsListener.clear();
            this.gts = gts;
            this.changes.add(Change.GTS);
        }
        return result;
    }

    public final boolean hasState() {
        return this.getState() != null;
    }

    public final GraphState getState() {
        return this.state;
    }

    public final boolean setState(GraphState state) {
        this.start();
        this.changeGts();
        if (this.changeState(state)) {
            this.changeMatch(null);
            this.changeTransition(null);
            if (state != null && this.getDisplay() != DisplayKind.LTS) {
                this.changeDisplay(DisplayKind.STATE);
            }
        }
        return this.finish();
    }

    private final boolean changeState(GraphState state) {
        boolean result;
        boolean bl = result = state != this.state || this.changes.contains((Object)Change.GTS);
        if (result) {
            this.state = state;
            this.changes.add(Change.STATE);
        }
        return result;
    }

    public final boolean hasMatch() {
        return this.getMatch() != null;
    }

    public final MatchResult getMatch() {
        return this.match;
    }

    public final boolean setMatch(GraphState state, MatchResult match) {
        this.start();
        boolean stateChanged = this.changeState(state);
        boolean matchChanged = this.changeMatch(match);
        if (matchChanged || stateChanged) {
            if (match != null && match.hasRuleTransitionFrom(state)) {
                this.changeTransition(match.getRuleTransition());
            } else {
                this.changeTransition(null);
            }
            if (this.getDisplay() != DisplayKind.LTS) {
                this.changeDisplay(DisplayKind.STATE);
            }
        }
        if (matchChanged) {
            this.changeSelected(ResourceKind.RULE, match == null ? null : match.getRule().getFullName());
        }
        return this.finish();
    }

    public final Set<RuleTransition> getTrace() {
        return this.trace;
    }

    public final boolean hasTransition() {
        return this.getTransition() != null;
    }

    public final GraphTransition getTransition() {
        return this.trans;
    }

    public final boolean setTransition(GraphTransition trans) {
        this.start();
        if (this.changeTransition(trans) && trans != null) {
            RuleTransition ruleTrans = trans.getInitial();
            MatchResult match = ruleTrans.getKey();
            this.changeMatch(match);
            this.changeSelected(ResourceKind.RULE, match.getRule().getFullName());
            this.changeState(trans.source());
            if (this.getDisplay() != DisplayKind.LTS) {
                this.changeDisplay(DisplayKind.STATE);
            }
        }
        return this.finish();
    }

    private final boolean changeMatch(MatchResult match) {
        boolean result;
        boolean bl = result = match != this.match;
        if (result) {
            this.match = match;
            this.changes.add(Change.MATCH);
        }
        return result;
    }

    private final boolean changeTransition(GraphTransition trans) {
        boolean result;
        boolean bl = result = trans != this.trans;
        if (result) {
            this.trans = trans;
            this.changes.add(Change.MATCH);
        }
        return result;
    }

    public final boolean hasGrammar() {
        return this.getGrammar() != null;
    }

    public final GrammarModel getGrammar() {
        return this.grammar;
    }

    public final void setGrammar(GrammarModel grammar) {
        this.start();
        if (this.changeGrammar(grammar)) {
            this.changeGts(null, false);
            this.changeState(null);
            this.changeMatch(null);
            this.changeTransition(null);
            this.changeExploration();
            for (ResourceKind resource : ResourceKind.all(false)) {
                this.changeSelected(resource, null);
            }
            if (this.getExploration() != null && grammar != null && !grammar.hasErrors()) {
                try {
                    this.getExploration().test(grammar.toGrammar());
                }
                catch (FormatException formatException) {
                    this.changeExploration(new Exploration());
                }
            }
        }
        this.finish();
    }

    private final void changeGrammar(boolean reset) {
        this.changes.add(Change.GRAMMAR);
        GrammarModel grammar = this.grammar;
        this.changeGrammar(grammar);
        if (reset) {
            this.changeGts(null, false);
            this.changeState(null);
            this.changeMatch(null);
            this.changeTransition(null);
            this.changeExploration();
        }
        for (ResourceKind resource : ResourceKind.all(false)) {
            LinkedHashSet<String> newNames = new LinkedHashSet<String>();
            newNames.addAll(this.getSelectSet(resource));
            newNames.retainAll(grammar.getNames(resource));
            this.changeSelectedSet(resource, newNames);
        }
    }

    private final boolean changeGrammar(GrammarModel grammar) {
        boolean result = grammar != this.grammar;
        this.grammar = grammar;
        this.changes.add(Change.GRAMMAR);
        return result;
    }

    public final SystemStore getStore() {
        return this.grammar == null ? null : this.grammar.getStore();
    }

    public final ResourceModel<?> getResource(ResourceKind resource) {
        String name = this.getSelected(resource);
        return name == null ? null : this.getGrammar().getResource(resource, name);
    }

    public final GraphBasedModel<?> getGraphResource(ResourceKind resource) {
        String name = this.getSelected(resource);
        return name == null ? null : this.getGrammar().getGraphResource(resource, name);
    }

    public final TextBasedModel<?> getTextResource(ResourceKind resource) {
        String name = this.getSelected(resource);
        return name == null ? null : this.getGrammar().getTextResource(resource, name);
    }

    public final List<SearchResult> searchLabel(TypeLabel label) {
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        ResourceKind[] resourceKindArray = ResourceKind.values();
        int n = resourceKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceKind kind = resourceKindArray[n2];
            if (kind.isGraphBased()) {
                for (String name : this.getGrammar().getNames(kind)) {
                    AspectGraph graph = this.getGrammar().getGraphResource(kind, name).getSource();
                    graph.getSearchResults(label, searchResults);
                }
            }
            ++n2;
        }
        return searchResults;
    }

    public final void synchronize(boolean reset) {
        this.start();
        this.changeGrammar(reset);
        this.finish();
    }

    public final boolean isSelected(ResourceKind kind) {
        return this.getSelected(kind) != null;
    }

    public final String getSelected(ResourceKind kind) {
        Set<String> resourceSet = this.resources.get((Object)kind);
        return resourceSet.isEmpty() ? null : resourceSet.iterator().next();
    }

    public final Set<String> getSelectSet(ResourceKind kind) {
        return this.resources.get((Object)kind);
    }

    public final boolean doSelect(ResourceKind kind, String name) {
        this.start();
        this.changeSelected(kind, name);
        if (this.isSelected(kind) || kind == ResourceKind.HOST && this.hasState()) {
            this.changeDisplay(DisplayKind.toDisplay(kind));
        }
        return this.finish();
    }

    public final boolean doSelectSet(ResourceKind kind, Collection<String> names) {
        this.start();
        this.changeSelectedSet(kind, names);
        return this.finish();
    }

    private boolean changeSelected(ResourceKind kind, String name) {
        return this.changeSelectedSet(kind, name == null ? Collections.emptySet() : Collections.singleton(name));
    }

    private final boolean changeSelectedSet(ResourceKind resource, Collection<String> names) {
        boolean result = false;
        LinkedHashSet<String> newSelection = new LinkedHashSet<String>(names);
        Set<String> allNames = this.getGrammar().getNames(resource);
        if (newSelection.isEmpty() && this.getGrammar() != null) {
            String name = null;
            Set<String> activeNames = this.getGrammar().getActiveNames(resource);
            if (!activeNames.isEmpty()) {
                newSelection.add(activeNames.iterator().next());
            }
            if (newSelection.isEmpty() && !allNames.isEmpty()) {
                name = allNames.iterator().next();
            }
            if (name != null) {
                newSelection.add(name);
            }
        }
        newSelection.retainAll(allNames);
        if (!newSelection.equals(this.getSelectSet(resource))) {
            this.resources.put(resource, newSelection);
            this.changes.add(Change.toChange(resource));
        }
        return result;
    }

    public boolean isAbstractionMode() {
        return this.abstractionMode;
    }

    public boolean setAbstractionMode(boolean value) {
        this.start();
        this.changeAbstractionMode(value);
        return this.finish();
    }

    private boolean changeAbstractionMode(boolean value) {
        boolean result = false;
        if (value != this.abstractionMode) {
            this.abstractionMode = value;
            this.changes.add(Change.ABSTRACT);
        }
        return result;
    }

    public Exploration getExploration() {
        return this.exploration;
    }

    public void setExploration(Exploration exploration) throws FormatException {
        if (this.hasGrammar() && !this.getGrammar().hasErrors()) {
            exploration.test(this.getGrammar().toGrammar());
        }
        this.changeExploration(exploration);
    }

    public void changeExploration() {
        Exploration exploration = this.getGrammar().getDefaultExploration();
        if (exploration != null) {
            this.changeExploration(exploration);
        }
    }

    public void changeExploration(Exploration exploration) {
        this.exploration = exploration;
    }

    public final DisplayKind getDisplay() {
        return this.display;
    }

    public final boolean setDisplay(DisplayKind display) {
        this.start();
        this.changeDisplay(display);
        return this.finish();
    }

    private boolean changeDisplay(DisplayKind display) {
        boolean result = false;
        if (display != this.display) {
            this.display = display;
            this.changes.add(Change.DISPLAY);
        }
        return result;
    }

    public ExplorationStatistics getExplorationStats() {
        if (this.explorationStats == null || this.explorationStats.getGts() != this.getGts()) {
            this.explorationStats = new ExplorationStatistics(this.getGts());
            this.explorationStats.configureForSimulator();
        }
        return this.explorationStats;
    }

    public String toString() {
        return "GuiState [gts=" + this.gts + ", state=" + this.state + ", match=" + this.match + ", grammar=" + this.grammar + ", resources=" + this.resources + ", changes=" + this.changes + "]";
    }

    public void addListener(SimulatorListener listener, Change ... changes) {
        if (changes.length == 0) {
            changes = Change.values();
        }
        Change[] changeArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            Change change = changeArray[n2];
            List<SimulatorListener> listeners = this.listeners.get((Object)change);
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
            ++n2;
        }
    }

    public void removeListener(SimulatorListener listener, Change ... changes) {
        if (changes.length == 0) {
            changes = Change.values();
        }
        Change[] changeArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            Change change = changeArray[n2];
            this.listeners.get((Object)change).remove(listener);
            ++n2;
        }
    }

    public GTSCounter getGTSCounter() {
        return this.gtsCounter;
    }

    private void start() {
        assert (this.old == null);
        this.old = this.clone();
        this.changes.clear();
    }

    private boolean finish() {
        boolean result;
        assert (this.old != null);
        boolean bl = result = !this.changes.isEmpty();
        if (result) {
            this.fireUpdate();
        }
        this.old = null;
        this.changes.clear();
        return result;
    }

    protected SimulatorModel clone() {
        SimulatorModel result;
        block3: {
            result = null;
            try {
                result = (SimulatorModel)super.clone();
                result.resources = new EnumMap<ResourceKind, Set<String>>(ResourceKind.class);
                for (ResourceKind resource : ResourceKind.all(false)) {
                    result.resources.put(resource, new LinkedHashSet(this.resources.get((Object)resource)));
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        return result;
    }

    private void fireUpdate() {
        HashSet<SimulatorListener> notified = new HashSet<SimulatorListener>();
        for (Change change : this.changes) {
            for (SimulatorListener listener : new ArrayList(this.listeners.get((Object)change))) {
                if (!notified.add(listener)) continue;
                listener.update(this, this.old, this.changes);
            }
        }
    }

    public static enum Change {
        ABSTRACT,
        CONTROL(ResourceKind.CONTROL),
        GRAMMAR,
        GTS,
        HOST(ResourceKind.HOST),
        MATCH,
        PROLOG(ResourceKind.PROLOG),
        CONFIG(ResourceKind.CONFIG),
        GROOVY(ResourceKind.GROOVY),
        RULE(ResourceKind.RULE),
        STATE,
        DISPLAY,
        TYPE(ResourceKind.TYPE);

        private final ResourceKind resource;
        private static Map<ResourceKind, Change> resourceToChangeMap;

        static {
            resourceToChangeMap = new EnumMap<ResourceKind, Change>(ResourceKind.class);
            Change[] changeArray = Change.values();
            int n = changeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Change change = changeArray[n2];
                ResourceKind resource = change.getResourceKind();
                if (resource != null) {
                    resourceToChangeMap.put(resource, change);
                }
                ++n2;
            }
        }

        private Change() {
            this(null);
        }

        private Change(ResourceKind resource) {
            this.resource = resource;
        }

        public ResourceKind getResourceKind() {
            return this.resource;
        }

        public static Change toChange(ResourceKind resource) {
            return resourceToChangeMap.get((Object)resource);
        }
    }

    private class MyLTSListener
    extends GTSAdapter {
        private boolean changed;

        MyLTSListener() {
        }

        public void clear() {
            this.changed = false;
        }

        @Override
        public void addUpdate(GTS gts, GraphState state) {
            this.changed = true;
        }

        @Override
        public void addUpdate(GTS gts, GraphTransition transition) {
            this.changed = true;
        }

        @Override
        public void statusUpdate(GTS graph, GraphState explored, GraphState.Flag flag) {
            this.changed = true;
        }

        public boolean isChanged() {
            return this.changed;
        }
    }
}

