/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.model.ResourceKind;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.EditStateAction;
import groove.gui.action.SimulatorAction;
import groove.io.store.EditType;

public class EditAction
extends SimulatorAction {
    private final EditStateAction editStateAction;

    public EditAction(Simulator simulator, ResourceKind resource) {
        super(simulator, EditType.MODIFY, resource);
        this.putValue("AcceleratorKey", Options.EDIT_KEY);
        this.editStateAction = simulator.getActions().getEditStateAction();
    }

    @Override
    public void execute() {
        if (this.isForState()) {
            this.editStateAction.execute();
        } else {
            for (String name : this.getSimulatorModel().getSelectSet(this.getResourceKind())) {
                this.getDisplay().startEditResource(name);
            }
        }
    }

    @Override
    public void refresh() {
        boolean enabled = this.getGrammarModel() != null && this.getGrammarStore().isModifiable() && (this.getSimulatorModel().isSelected(this.getResourceKind()) || this.isForState());
        this.setEnabled(enabled);
        if (this.getResourceKind() == ResourceKind.HOST) {
            String name = this.isForState() ? (String)this.editStateAction.getValue("Name") : this.getEditActionName();
            this.putValue("Name", name);
            this.putValue("ShortDescription", name);
        }
    }

    private boolean isForState() {
        return this.getDisplaysPanel().getSelectedDisplay() == this.getLtsDisplay() && this.getLtsDisplay().isActive();
    }
}

