/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.model.ResourceKind;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.io.store.EditType;
import java.io.IOException;

public class RenameAction
extends SimulatorAction {
    public RenameAction(Simulator simulator, ResourceKind resource) {
        super(simulator, EditType.RENAME, resource);
        this.putValue("AcceleratorKey", Options.RENAME_KEY);
    }

    @Override
    public void execute() {
        String newName;
        ResourceKind resource = this.getResourceKind();
        String oldName = this.getSimulatorModel().getSelected(resource);
        if (this.getDisplay().saveEditor(oldName, true, true) && (newName = this.askNewName(oldName, false)) != null && !newName.equals(oldName)) {
            try {
                this.getSimulatorModel().doRename(resource, oldName, newName);
            }
            catch (IOException exc) {
                this.showErrorDialog(exc, String.format("Error while renaming %s '%s' into '%s'", resource.getDescription(), oldName, newName), new Object[0]);
            }
        }
    }

    @Override
    public void refresh() {
        this.setEnabled(this.getSimulatorModel().getSelectSet(this.getResourceKind()).size() == 1 && this.getSimulatorModel().getStore().isModifiable());
    }
}

