/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.aspect.Aspect;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectKind;
import groove.grammar.model.FormatException;
import groove.grammar.model.ResourceKind;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.EdgeRole;
import groove.graph.GraphRole;
import groove.graph.Label;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.gui.display.GraphTab;
import groove.gui.display.ResourceDisplay;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JGraph;
import groove.gui.tree.LabelTree;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;

public class SelectColorAction
extends SimulatorAction
implements GraphSelectionListener,
TreeSelectionListener {
    private TypeLabel label;
    private final JColorChooser chooser;

    public SelectColorAction(Simulator simulator) {
        super(simulator, "Select Color...", null);
        this.putValue("ShortDescription", "Select Color...");
        this.addAsListener(this.getHostDisplay());
        this.addAsListener(this.getRuleDisplay());
        this.addAsListener(this.getTypeDisplay());
        this.refresh();
        this.chooser = new JColorChooser();
    }

    private void addAsListener(ResourceDisplay display) {
        assert (display.getResourceKind().isGraphBased());
        AspectJGraph jGraph = ((GraphTab)display.getMainTab()).getJGraph();
        jGraph.addGraphSelectionListener(this);
        if (this.label == null) {
            this.checkJGraph(jGraph);
        }
        LabelTree labelTree = jGraph.getLabelTree();
        labelTree.addTreeSelectionListener(this);
        if (this.label == null) {
            this.checkLabelTree(labelTree);
        }
    }

    private void checkJGraph(JGraph<?> jGraph) {
        this.label = null;
        Object[] selection = jGraph.getSelectionCells();
        if (selection != null) {
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            block0: while (n2 < n) {
                Object cell = objectArray[n2];
                for (Label entry : ((JCell)cell).getKeys()) {
                    if (!(entry instanceof TypeNode)) continue;
                    this.label = ((TypeNode)entry).label();
                    break block0;
                }
                ++n2;
            }
        }
        this.refresh();
    }

    private void checkLabelTree(LabelTree<?> tree) {
        this.label = null;
        TreePath[] selection = tree.getSelectionPaths();
        if (selection != null) {
            TreePath[] treePathArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Label selectedLabel;
                TreePath path = treePathArray[n2];
                Object treeNode = path.getLastPathComponent();
                if (treeNode instanceof LabelTree.EntryNode && (selectedLabel = ((LabelTree.EntryNode)treeNode).getEntry().getLabel()) instanceof TypeLabel && selectedLabel.getRole() == EdgeRole.NODE_TYPE) {
                    this.label = (TypeLabel)selectedLabel;
                    break;
                }
                ++n2;
            }
        }
        this.refresh();
    }

    @Override
    public void execute() {
        Color initColour = this.getGrammarModel().getTypeGraph().getNode(this.label).getColor();
        if (initColour != null) {
            this.chooser.setColor(initColour);
        }
        JDialog dialog = JColorChooser.createDialog(this.getFrame(), "Choose colour for type", false, this.chooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectColorAction.this.setColour(SelectColorAction.this.chooser.getColor());
            }
        }, null);
        dialog.setVisible(true);
    }

    private void setColour(Color newColour) {
        Aspect colourAspect;
        block6: {
            colourAspect = null;
            if (!newColour.equals(Color.black)) {
                String colourString = String.format("%s,%s,%s", newColour.getRed(), newColour.getGreen(), newColour.getBlue());
                try {
                    colourAspect = AspectKind.COLOR.getAspect().newInstance(colourString, GraphRole.TYPE);
                }
                catch (FormatException formatException) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
        }
        for (AspectGraph typeGraph : this.getGrammarStore().getGraphs(ResourceKind.TYPE).values()) {
            AspectGraph newTypeGraph = typeGraph.colour(this.label, colourAspect);
            if (newTypeGraph == typeGraph) continue;
            try {
                this.getSimulatorModel().doAddGraph(ResourceKind.TYPE, newTypeGraph, false);
            }
            catch (IOException exc) {
                this.showErrorDialog(exc, String.format("Error while saving type graph '%s'", typeGraph.getName()), new Object[0]);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.checkLabelTree((LabelTree)e.getSource());
    }

    public void valueChanged(GraphSelectionEvent e) {
        this.checkJGraph((JGraph)((Object)e.getSource()));
    }

    @Override
    public void refresh() {
        super.setEnabled(this.label != null && this.getGrammarModel().getTypeModel().isEnabled());
    }
}

