/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import groove.explore.strategy.Boundary;
import groove.explore.strategy.GraphNodeSizeBoundary;
import groove.explore.strategy.RuleSetBoundary;
import groove.grammar.Action;
import groove.grammar.Grammar;
import groove.grammar.Rule;
import groove.gui.layout.SpringUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BoundedModelCheckingDialog {
    protected Grammar grammar;
    private List<String> ruleNames;
    protected final Set<String> selectedRuleNames = new HashSet<String>();
    private Boundary boundary;
    private static final String DIALOG_TITLE = "Set the boundary";
    JDialog dialog = new JDialog();
    JOptionPane pane;
    private JButton okButton;
    private JButton cancelButton;
    private JButton addButton;
    protected JButton deleteButton;
    private JLabel boundLabel;
    private JTextField boundField;
    private JLabel deltaLabel;
    private JTextField deltaField;
    private JRadioButton graphBoundButton;
    private JRadioButton ruleSetBoundButton;
    private JList ruleList;
    private JList selectedRuleList;
    private final SelectionListener selectionListener = new SelectionListener();

    JOptionPane createContentPane() {
        Object[] buttons = new Object[]{this.getOkButton(), this.getCancelButton()};
        this.pane = new JOptionPane(this.createPanel(), -1, 2, null, buttons);
        return this.pane;
    }

    private JPanel createPanel() {
        SpringLayout layout = new SpringLayout();
        JPanel panel = new JPanel(layout);
        ButtonGroup group = new ButtonGroup();
        this.graphBoundButton = new JRadioButton("graph size");
        this.graphBoundButton.addActionListener(this.selectionListener);
        this.graphBoundButton.setSelected(true);
        this.ruleSetBoundButton = new JRadioButton("rule set");
        this.ruleSetBoundButton.addActionListener(this.selectionListener);
        this.deleteButton = new JButton("<<");
        this.deleteButton.addActionListener(this.selectionListener);
        this.deleteButton.setEnabled(false);
        this.addButton = new JButton(">>");
        this.addButton.addActionListener(this.selectionListener);
        this.addButton.setEnabled(false);
        this.ruleList = new JList();
        this.ruleList.setListData(this.ruleNames.toArray());
        this.ruleList.setEnabled(false);
        this.ruleList.setSelectionMode(2);
        this.ruleList.addListSelectionListener(this.selectionListener);
        String[] singleton = new String[]{"empty"};
        this.selectedRuleList = new JList();
        this.selectedRuleList.setListData(singleton);
        this.selectedRuleList.setEnabled(false);
        this.selectedRuleList.setSelectionMode(2);
        this.selectedRuleList.addListSelectionListener(this.selectionListener);
        this.boundLabel = new JLabel("Initial bound:");
        this.boundField = new JTextField(20);
        this.deltaLabel = new JLabel("Delta:");
        this.deltaField = new JTextField(20);
        group.add(this.graphBoundButton);
        group.add(this.ruleSetBoundButton);
        panel.add(this.graphBoundButton);
        panel.add(new JLabel(""));
        panel.add(new JLabel(""));
        panel.add(new JLabel(""));
        panel.add(new JLabel(""));
        panel.add(this.boundLabel);
        panel.add(this.boundField);
        panel.add(new JLabel(""));
        panel.add(new JLabel(""));
        panel.add(new JLabel(""));
        panel.add(this.deltaLabel);
        panel.add(this.deltaField);
        panel.add(new JLabel(""));
        panel.add(new JLabel(""));
        panel.add(new JLabel(""));
        panel.add(this.ruleSetBoundButton);
        panel.add(new JLabel(""));
        panel.add(new JLabel(""));
        panel.add(new JLabel(""));
        panel.add(new JLabel(""));
        panel.add(new JLabel(""));
        panel.add(this.ruleList);
        panel.add(this.deleteButton);
        panel.add(this.addButton);
        panel.add(this.selectedRuleList);
        SpringUtilities.makeCompactGrid(panel, 5, 5, 5, 5, 10, 10);
        return panel;
    }

    JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new CloseListener());
        }
        return this.okButton;
    }

    JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new CloseListener());
        }
        return this.cancelButton;
    }

    public void showDialog(JFrame frame) {
        this.dialog = this.createContentPane().createDialog(frame, this.createTitle());
        this.dialog.setResizable(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    private String createTitle() {
        return DIALOG_TITLE;
    }

    public Boundary getBoundary() {
        return this.boundary;
    }

    public void setGrammar(Grammar grammar) {
        this.grammar = grammar;
        this.ruleNames = new ArrayList<String>();
        for (Action rule : grammar.getActions()) {
            this.ruleNames.add(rule.getFullName());
        }
    }

    private class CloseListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getSource() == BoundedModelCheckingDialog.this.getOkButton()) {
                    this.setBoundary();
                }
                BoundedModelCheckingDialog.this.dialog.getContentPane().setVisible(false);
                BoundedModelCheckingDialog.this.dialog.dispose();
            }
            catch (NumberFormatException numberFormatException) {}
        }

        private void setBoundary() {
            BoundedModelCheckingDialog aDialog = BoundedModelCheckingDialog.this;
            if (aDialog.graphBoundButton.isSelected()) {
                int graphBound = Integer.parseInt(aDialog.boundField.getText());
                int delta = Integer.parseInt(aDialog.deltaField.getText());
                aDialog.boundary = new GraphNodeSizeBoundary(graphBound, delta);
            } else if (aDialog.ruleSetBoundButton.isSelected()) {
                HashSet<Rule> selectedRules = new HashSet<Rule>();
                for (String ruleName : aDialog.selectedRuleNames) {
                    selectedRules.add(aDialog.grammar.getRule(ruleName));
                }
                aDialog.boundary = new RuleSetBoundary(selectedRules);
            }
        }
    }

    private class SelectionListener
    implements ActionListener,
    ListSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BoundedModelCheckingDialog aDialog = BoundedModelCheckingDialog.this;
            if (e.getSource() == aDialog.graphBoundButton) {
                aDialog.boundField.setEditable(true);
                aDialog.deltaField.setEditable(true);
                aDialog.ruleList.setEnabled(false);
                aDialog.selectedRuleList.setEnabled(false);
            } else if (e.getSource() == aDialog.ruleSetBoundButton) {
                aDialog.ruleList.setEnabled(true);
                aDialog.selectedRuleList.setEnabled(true);
                aDialog.boundField.setEditable(false);
                aDialog.deltaField.setEditable(false);
            } else if (e.getSource() == aDialog.addButton) {
                Object[] objectArray = aDialog.ruleList.getSelectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    aDialog.selectedRuleNames.add(object.toString());
                    ++n2;
                }
                aDialog.selectedRuleList.setListData(aDialog.selectedRuleNames.toArray());
            } else if (e.getSource() == aDialog.deleteButton) {
                Object[] objectArray = aDialog.selectedRuleList.getSelectedValues();
                int n = objectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Object object = objectArray[n3];
                    aDialog.selectedRuleNames.remove(object.toString());
                    ++n3;
                }
                aDialog.selectedRuleList.setListData(aDialog.selectedRuleNames.toArray());
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            BoundedModelCheckingDialog aDialog = BoundedModelCheckingDialog.this;
            if (e.getSource() == aDialog.ruleList) {
                if (aDialog.ruleList.getSelectedValues().length > 0) {
                    aDialog.addButton.setEnabled(true);
                } else {
                    aDialog.addButton.setEnabled(false);
                }
            } else if (e.getSource() == aDialog.selectedRuleList) {
                if (aDialog.selectedRuleList.getSelectedValues().length > 0) {
                    aDialog.deleteButton.setEnabled(true);
                } else {
                    aDialog.deleteButton.setEnabled(false);
                }
            }
        }
    }
}

