/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import groove.io.HTMLConverter;
import groove.io.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class LibrariesTable
extends JTable {
    private final URLRenderer urlRenderer = new URLRenderer();
    private static LibrariesTable instance = new LibrariesTable();

    private LibrariesTable() {
        this.addMouseListener(this.urlRenderer);
        this.addMouseMotionListener(this.urlRenderer);
        this.setModel(new TableModel(Util.readCSV("libraries", ';')));
        int i = 0;
        while (i < this.getColumnCount()) {
            this.getColumnModel().getColumn(i).setPreferredWidth(0);
            ++i;
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int rowIx, int colIx) {
        Component result = super.prepareRenderer(renderer, rowIx, colIx);
        TableColumn col = this.getColumnModel().getColumn(colIx);
        col.setPreferredWidth(Math.max(result.getPreferredSize().width, col.getPreferredWidth()));
        return result;
    }

    @Override
    public int convertColumnIndexToModel(int viewColumnIndex) {
        int result = viewColumnIndex;
        if (result >= Column.DESCRIPTION.ordinal()) {
            ++result;
        }
        return result;
    }

    @Override
    public int convertColumnIndexToView(int modelColumnIndex) {
        int result = modelColumnIndex;
        if (result == Column.DESCRIPTION.ordinal()) {
            result = -1;
        } else if (result > Column.DESCRIPTION.ordinal()) {
            --result;
        }
        return result;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (this.convertColumnIndexToModel(column) == Column.URL.ordinal()) {
            return this.urlRenderer;
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        int row = this.rowAtPoint(evt.getPoint());
        return "Library for " + this.getModel().getValueAt(row, Column.DESCRIPTION.ordinal());
    }

    public void showDialog(Component parent) {
        JScrollPane scrollPane = new JScrollPane(this);
        Dimension size = scrollPane.getPreferredSize();
        size.height = this.getPreferredSize().height;
        scrollPane.getViewport().setPreferredSize(size);
        JOptionPane optionPane = new JOptionPane(scrollPane, -1);
        JDialog dialog = optionPane.createDialog(parent, "External libraries used in GROOVE");
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        LibrariesTable.instance().showDialog(null);
    }

    public static LibrariesTable instance() {
        return instance;
    }

    private static enum Column {
        NAME("Name"),
        DESCRIPTION("Description"),
        URL("URL"){

            @Override
            public URL format(String value) {
                try {
                    return new URL(value);
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
        }
        ,
        VERSION("Version");

        private final String header;

        private Column(String header) {
            this.header = header;
        }

        Object format(String value) {
            return value;
        }

        public String getHeader() {
            return this.header;
        }
    }

    private class TableModel
    extends AbstractTableModel {
        private final List<String[]> data;

        TableModel(List<String[]> data) {
            this.data = data;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return Column.values().length - 1;
        }

        @Override
        public String getColumnName(int column) {
            return Column.values()[LibrariesTable.this.convertColumnIndexToModel(column)].getHeader();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String result = this.data.get(rowIndex)[columnIndex];
            return Column.values()[columnIndex].format(result);
        }
    }

    private static class URLRenderer
    extends DefaultTableCellRenderer
    implements MouseListener,
    MouseMotionListener {
        private int row = -1;
        private int col = -1;
        private static final HTMLConverter.HTMLTag BLUE_TAG = HTMLConverter.createColorTag(Color.BLUE);

        private URLRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            StringBuilder text = new StringBuilder(value.toString());
            BLUE_TAG.on(text);
            if (this.row == row && this.col == column) {
                HTMLConverter.UNDERLINE_TAG.on(text);
            }
            this.setText(HTMLConverter.HTML_TAG.on(text).toString());
            return this;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            Point pt = e.getPoint();
            int prev_row = this.row;
            int prev_col = this.col;
            this.row = table.rowAtPoint(pt);
            this.col = table.columnAtPoint(pt);
            if (this.row != prev_row || this.col != prev_col) {
                Rectangle r = table.getCellRect(this.row, this.col, false);
                r = r.union(table.getCellRect(prev_row, prev_col, false));
                table.repaint(r);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            table.repaint(table.getCellRect(this.row, this.col, false));
            this.row = -1;
            this.col = -1;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            Point pt = e.getPoint();
            int ccol = table.columnAtPoint(pt);
            int crow = table.rowAtPoint(pt);
            Object value = table.getValueAt(crow, ccol);
            if (value instanceof URL) {
                URL url = (URL)value;
                try {
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().browse(url.toURI());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }
    }
}

