/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import java.awt.Dimension;
import java.awt.Frame;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ProgressBarDialog
extends JDialog {
    private JLabel label;
    private JProgressBar bar;
    private Timer activation;
    private static final int BORDER_WIDTH = 20;
    private static final int DIALOG_WIDTH = 200;
    private static final int DIALOG_HEIGHT = 100;
    private static final int LABEL_WIDTH = 160;
    private static final int LABEL_HEIGHT = 25;

    public ProgressBarDialog(JFrame parent, String title) {
        super((Frame)parent, title);
        this.setLocationRelativeTo(parent);
        this.getContentPane().add(this.getPanel());
        this.pack();
    }

    public synchronized void activate(long millis) {
        this.deactivate();
        this.activation = new Timer();
        this.activation.schedule(new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProgressBarDialog.this.setVisible(true);
                        ProgressBarDialog progressBarDialog = ProgressBarDialog.this;
                        synchronized (progressBarDialog) {
                            if (ProgressBarDialog.this.activation != null) {
                                ProgressBarDialog.this.activation.cancel();
                            }
                        }
                    }
                });
            }
        }, millis);
    }

    public synchronized void deactivate() {
        if (this.activation != null) {
            this.activation.cancel();
            this.activation = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressBarDialog.this.setVisible(false);
            }
        });
    }

    public void setMessage(String text) {
        this.getLabel().setText(text);
    }

    public void setRange(int lower, int upper) {
        this.getBar().setMinimum(lower);
        this.getBar().setMaximum(upper);
        this.getBar().setValue(lower);
        this.getBar().setIndeterminate(false);
    }

    public void setProgress(int progress) {
        this.getBar().setValue(progress);
    }

    public void incProgress() {
        this.getBar().setValue(this.getBar().getValue() + 1);
    }

    private Box getPanel() {
        Box result = Box.createVerticalBox();
        result.setBorder(new EmptyBorder(20, 20, 20, 20));
        result.add(this.getLabel());
        result.add(Box.createVerticalGlue());
        result.add(this.getBar());
        result.setPreferredSize(new Dimension(200, 100));
        return result;
    }

    private JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel();
            this.label.setSize(160, 25);
        }
        return this.label;
    }

    private JProgressBar getBar() {
        if (this.bar == null) {
            this.bar = new JProgressBar();
            this.bar.setSize(160, 25);
            this.bar.setIndeterminate(true);
            this.bar.setStringPainted(true);
        }
        return this.bar;
    }
}

