/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import groove.graph.GraphProperties;
import groove.gui.dialog.PropertyKey;
import groove.util.Property;
import groove.util.collect.ListComparator;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class PropertiesTable
extends JTable {
    private final boolean editable;
    private final Map<String, ? extends PropertyKey> defaultKeys;
    private int nonSystemKeyCount;
    private final SortedMap<String, String> properties;
    private TableModel tableModel;
    private CellEditor cellEditor;
    private boolean changed;
    public static final String DIALOG_TITLE = "Properties editor";
    public static final String PROPERTY_HEADER = "Property";
    public static final String VALUE_HEADER = "Value";
    private static final int PROPERTY_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private static final int ROW_HEIGHT = 15;

    public PropertiesTable(Map<String, ? extends PropertyKey> defaultKeys, boolean editable) {
        this.editable = editable;
        this.defaultKeys = defaultKeys;
        this.properties = new TreeMap<String, String>(new ListComparator<String>(this.defaultKeys.keySet()));
        TableModel model = this.getTableModel();
        this.setModel(model);
        this.setIntercellSpacing(new Dimension(2, -2));
        this.setDefaultRenderer(this.getColumnClass(0), new CellRenderer());
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public void setProperties(Properties properties) {
        this.properties.clear();
        for (PropertyKey propertyKey : this.defaultKeys.values()) {
            if (propertyKey.isSystem()) continue;
            this.properties.put(propertyKey.getName(), propertyKey.getDefaultValue());
        }
        this.nonSystemKeyCount = this.properties.size();
        for (Map.Entry entry : properties.entrySet()) {
            String keyword = (String)entry.getKey();
            PropertyKey key = this.defaultKeys.get(keyword);
            if (key != null && key.isSystem()) continue;
            this.properties.put(keyword, (String)entry.getValue());
        }
        this.setPreferredScrollableViewportSize(new Dimension(300, Math.max((this.getModel().getRowCount() + 2) * 15, 80)));
        this.setEnabled(true);
        this.getTableModel().fireTableDataChanged();
        this.setChanged(false);
    }

    public void resetProperties() {
        this.properties.clear();
        this.setChanged(false);
        this.setEnabled(false);
        this.repaint();
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 0) {
            return this.getKeyEditor();
        }
        return this.getValueEditor(((TableModel)this.getModel()).getPropertyKey(row));
    }

    public final Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isEditable() {
        return this.editable;
    }

    private TableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new TableModel();
            this.tableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    PropertiesTable.this.setChanged(true);
                }
            });
        }
        return this.tableModel;
    }

    void setChanged(boolean changed) {
        this.changed = changed;
    }

    CellEditor getKeyEditor() {
        if (this.cellEditor == null) {
            this.cellEditor = this.createCellEditor();
        }
        this.cellEditor.setEditingKey();
        return this.cellEditor;
    }

    final Map<String, ? extends PropertyKey> getDefaultKeys() {
        return this.defaultKeys;
    }

    TableCellEditor getValueEditor(String key) {
        if (this.cellEditor == null) {
            this.cellEditor = this.createCellEditor();
        }
        this.cellEditor.setEditingValueForKey(key);
        return this.cellEditor;
    }

    CellEditor createCellEditor() {
        return new CellEditor();
    }

    private class CellEditor
    extends DefaultCellEditor {
        private String editingValueForKey;

        public CellEditor() {
            super(new JTextField());
            this.setClickCountToStart(1);
        }

        private JTextField getTextField() {
            return (JTextField)super.getComponent();
        }

        @Override
        public JTextField getComponent() {
            PropertyKey key;
            JTextField result = this.getTextField();
            if (this.editingValueForKey != null && (key = PropertiesTable.this.getDefaultKeys().get(this.editingValueForKey)) != null) {
                Property<String> test = key.getFormat();
                result.setToolTipText(test == null ? null : test.toString());
            }
            return result;
        }

        @Override
        public boolean stopCellEditing() {
            boolean result;
            String editedValue = (String)this.getCellEditorValue();
            if (editedValue.length() == 0 || this.isEditedValueCorrect(editedValue)) {
                result = super.stopCellEditing();
            } else if (this.showContinueDialog(editedValue)) {
                this.getComponent().setSelectionStart(0);
                this.getComponent().setSelectionEnd(this.getComponent().getText().length());
                result = false;
            } else {
                super.cancelCellEditing();
                result = true;
            }
            return result;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
        }

        private boolean isEditedValueCorrect(String value) {
            Property<String> test;
            if (this.editingValueForKey == null) {
                return GraphProperties.isValidUserKey(value) && !PropertiesTable.this.defaultKeys.containsKey(value);
            }
            PropertyKey key = PropertiesTable.this.getDefaultKeys().get(this.editingValueForKey);
            Property<String> property = test = key == null ? null : key.getFormat();
            return test == null || test.isSatisfied(value);
        }

        private boolean showContinueDialog(String value) {
            int response = JOptionPane.showConfirmDialog(PropertiesTable.this, this.getContinueQuestion(value), null, 0);
            return response == 0;
        }

        private String getContinueQuestion(String value) {
            StringBuilder result = new StringBuilder();
            if (this.editingValueForKey == null) {
                if (PropertiesTable.this.properties.containsKey(value)) {
                    result.append(String.format("Property key '%s' already exists", value));
                } else {
                    result.append(String.format("Property key '%s' is not a valid identifier.", value));
                }
            } else {
                String description;
                Property<String> test = PropertiesTable.this.getDefaultKeys().get(this.editingValueForKey).getFormat();
                String string = description = test == null ? null : test.getDescription();
                if (description == null) {
                    result.append(String.format("Incorrect value '%s' for key '%s'.", this.editingValueForKey));
                } else {
                    result.append(String.format("Key '%s' expects %s.", this.editingValueForKey, description));
                }
            }
            result.append(" Continue?");
            return result.toString();
        }

        void setEditingKey() {
            this.editingValueForKey = null;
        }

        void setEditingValueForKey(String key) {
            this.editingValueForKey = key;
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        public CellRenderer() {
            this.setMinimumSize(new Dimension(0, 30));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String keyword;
            String tip = null;
            String text = (String)value;
            if (PropertiesTable.this.getDefaultKeys() != null && row < table.getRowCount() && (keyword = (String)table.getValueAt(row, 0)) != null && PropertiesTable.this.getDefaultKeys().containsKey(keyword)) {
                PropertyKey key = PropertiesTable.this.getDefaultKeys().get(keyword);
                Property<String> format = key.getFormat();
                if (column == 0) {
                    text = key.getDescription();
                    if (format != null) {
                        tip = format.getComment();
                    }
                } else {
                    if (text == null || text.isEmpty()) {
                        text = key.getDefaultValue();
                    }
                    if (format != null) {
                        tip = format.getDescription();
                    }
                }
            }
            this.setToolTipText(tip);
            return super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
        }
    }

    private class TableModel
    extends AbstractTableModel {
        private List<String> propertyKeyList;

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            int size = PropertiesTable.this.getProperties().size();
            return PropertiesTable.this.isEditable() ? size + 1 : size;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return PropertiesTable.PROPERTY_HEADER;
            }
            return PropertiesTable.VALUE_HEADER;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex == PropertiesTable.this.getProperties().size()) {
                return "";
            }
            if (columnIndex == 0) {
                return this.getPropertyKey(rowIndex);
            }
            return PropertiesTable.this.getProperties().get(this.getPropertyKey(rowIndex));
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            Property<String> property;
            if (!PropertiesTable.this.isEditable()) {
                return false;
            }
            if (columnIndex == 0) {
                return rowIndex >= PropertiesTable.this.nonSystemKeyCount;
            }
            if (rowIndex >= PropertiesTable.this.getProperties().size()) {
                return false;
            }
            PropertyKey key = PropertiesTable.this.getDefaultKeys().get(this.getPropertyKey(rowIndex));
            Property<String> property2 = property = key == null ? null : key.getFormat();
            return property == null || property.isEditable();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (rowIndex == PropertiesTable.this.getProperties().size()) {
                if (aValue instanceof String && ((String)aValue).length() > 0) {
                    PropertiesTable.this.getProperties().put((String)aValue, "");
                    this.refreshPropertyKeys();
                }
            } else if (columnIndex == 1) {
                String keyword = this.getPropertyKey(rowIndex);
                if (!aValue.equals(PropertiesTable.this.getProperties().get(keyword))) {
                    PropertiesTable.this.getProperties().put(keyword, (String)aValue);
                    this.fireTableCellUpdated(rowIndex, columnIndex);
                }
            } else {
                String value = PropertiesTable.this.getProperties().remove(this.getPropertyKey(rowIndex));
                if (aValue instanceof String && ((String)aValue).length() > 0) {
                    PropertiesTable.this.getProperties().put((String)aValue, value);
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
                this.refreshPropertyKeys();
            }
        }

        private List<String> getPropertyKeyList() {
            if (this.propertyKeyList == null) {
                this.initPropertyKeys();
            }
            return this.propertyKeyList;
        }

        private void refreshPropertyKeys() {
            this.initPropertyKeys();
            this.fireTableDataChanged();
        }

        private void initPropertyKeys() {
            this.propertyKeyList = new ArrayList<String>(PropertiesTable.this.getProperties().keySet());
        }

        String getPropertyKey(int rowIndex) {
            return this.getPropertyKeyList().get(rowIndex);
        }
    }
}

