/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorListener;
import groove.gui.SimulatorModel;
import groove.gui.display.Display;
import groove.gui.display.DisplayKind;
import groove.gui.display.DisplayWindow;
import groove.gui.display.GraphEditorTab;
import groove.gui.display.GraphTab;
import groove.gui.display.JGraphPanel;
import groove.gui.display.LTSDisplay;
import groove.gui.display.ResourceDisplay;
import groove.gui.display.StateDisplay;
import groove.gui.display.TabLabel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DisplaysPanel
extends JTabbedPane
implements SimulatorListener {
    private final Simulator simulator;
    private final Map<DisplayKind, Display> displaysMap = new HashMap<DisplayKind, Display>();
    private final Map<DisplayKind, DisplayWindow> detachedMap = new HashMap<DisplayKind, DisplayWindow>();
    private JTabbedPane upperListsPanel;
    private JTabbedPane lowerListsPanel;
    private JPanel infoPanel;
    private ChangeListener tabListener;
    private boolean changingTabs;
    private Component lastSelected;

    public DisplaysPanel(Simulator simulator) {
        super(1);
        this.setBorder(null);
        this.simulator = simulator;
        DisplayKind[] displayKindArray = DisplayKind.values();
        int n = displayKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayKind kind = displayKindArray[n2];
            this.addTab(this.getDisplay(kind));
            ++n2;
        }
        this.setSelectedIndex(0);
        this.getUpperListsPanel().setSelectedIndex(0);
        this.getLowerListsPanel().setSelectedIndex(0);
        this.installListeners();
        this.setVisible(true);
    }

    private void addTab(Display component) {
        DisplayKind kind = component.getKind();
        if (Options.getOptionalTabs().contains((Object)kind.getResource())) {
            this.showOrHideTab(kind.getResource());
        } else {
            this.attach(component);
        }
    }

    private boolean showOrHideTab(ResourceKind resource) {
        String optionName = Options.getShowTabOption(resource);
        boolean show = this.simulator.getOptions().isSelected(optionName);
        if (!show) {
            GrammarModel grammar = this.getSimulatorModel().getGrammar();
            show = grammar != null && !grammar.getResourceSet(resource).isEmpty();
        }
        ResourceDisplay display = this.getDisplayFor(resource);
        DisplayKind displayKind = DisplayKind.toDisplay(resource);
        if (show) {
            if (!this.detachedMap.containsKey((Object)displayKind)) {
                this.attach(display);
            }
        } else {
            this.remove(display);
            Display.ListPanel listPanel = display.getListPanel();
            if (listPanel != null) {
                this.getListsPanel(displayKind).remove(listPanel);
            }
        }
        return show;
    }

    private void installListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    JPopupMenu menu;
                    int index = DisplaysPanel.this.indexAtLocation(e.getX(), e.getY());
                    if (index >= 0) {
                        Display panel = DisplaysPanel.this.getDisplayAt(index);
                        menu = DisplaysPanel.this.createDetachMenu(panel);
                    } else {
                        menu = DisplaysPanel.this.createOptionalsMenu();
                    }
                    menu.show(DisplaysPanel.this, e.getX(), e.getY());
                }
            }
        });
        this.tabListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DisplaysPanel.this.changingTabs = true;
                DisplayKind displayKind = DisplaysPanel.this.getSelectedDisplay().getKind();
                if (displayKind != null) {
                    DisplaysPanel.this.getSimulatorModel().setDisplay(displayKind);
                }
                DisplaysPanel.this.changingTabs = false;
            }
        };
        Options options = this.simulator.getOptions();
        for (final ResourceKind optionalTab : Options.getOptionalTabs()) {
            String optionName = Options.getShowTabOption(optionalTab);
            options.getItem(optionName).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (DisplaysPanel.this.showOrHideTab(optionalTab)) {
                        DisplaysPanel.this.getSimulatorModel().setDisplay(DisplayKind.toDisplay(optionalTab));
                    }
                }
            });
        }
        this.simulator.getModel().addListener(this, SimulatorModel.Change.DISPLAY, SimulatorModel.Change.GRAMMAR);
        this.activateListeners();
    }

    private void activateListeners() {
        this.addChangeListener(this.tabListener);
    }

    private void suspendListeners() {
        this.removeChangeListener(this.tabListener);
    }

    public Display getDisplay(DisplayKind kind) {
        Display result = this.displaysMap.get((Object)kind);
        if (result == null) {
            result = Display.newDisplay(this.simulator, kind);
            this.displaysMap.put(kind, result);
        }
        return result;
    }

    public JTabbedPane getUpperListsPanel() {
        if (this.upperListsPanel == null) {
            this.upperListsPanel = new JTabbedPane();
        }
        return this.upperListsPanel;
    }

    public JTabbedPane getLowerListsPanel() {
        if (this.lowerListsPanel == null) {
            this.lowerListsPanel = new JTabbedPane();
        }
        return this.lowerListsPanel;
    }

    public JPanel getInfoPanel() {
        JPanel result = this.infoPanel;
        if (result == null) {
            this.infoPanel = result = new JPanel();
            result.setBorder(null);
            result.setLayout(new CardLayout());
        }
        return result;
    }

    private JTabbedPane getListsPanel(DisplayKind kind) {
        JTabbedPane result = null;
        switch (kind.getListPanel()) {
            case 0: {
                result = this.getUpperListsPanel();
                break;
            }
            case 1: {
                result = this.getLowerListsPanel();
            }
        }
        return result;
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        this.suspendListeners();
        if (changes.contains((Object)SimulatorModel.Change.GRAMMAR)) {
            for (ResourceKind optionalTab : Options.getOptionalTabs()) {
                this.showOrHideTab(optionalTab);
            }
        }
        if (changes.contains((Object)SimulatorModel.Change.DISPLAY)) {
            boolean changeList;
            DisplayKind newDisplayKind = source.getDisplay();
            if (!this.changingTabs) {
                Display panel = this.getDisplay(newDisplayKind);
                if (this.indexOfComponent(panel) >= 0) {
                    this.setSelectedComponent(panel);
                } else {
                    DisplayWindow window = this.detachedMap.get((Object)source.getDisplay());
                    if (window == null) {
                        this.attach(panel);
                    } else {
                        window.toFront();
                    }
                }
            }
            JTabbedPane listsTabPane = this.getListsPanel(newDisplayKind);
            Display.ListPanel newListPanel = this.getDisplay(newDisplayKind).getListPanel();
            boolean bl = changeList = listsTabPane != null;
            if (changeList) {
                DisplayKind oldListDisplayKind = ((Display.ListPanel)listsTabPane.getSelectedComponent()).getDisplayKind();
                changeList = oldListDisplayKind != newDisplayKind && newListPanel != null && listsTabPane.indexOfComponent(newListPanel) >= 0;
                switch (oldListDisplayKind) {
                    case RULE: {
                        changeList &= newDisplayKind != DisplayKind.STATE;
                        break;
                    }
                    case STATE: {
                        changeList &= newDisplayKind != DisplayKind.RULE;
                    }
                }
            }
            if (changeList) {
                listsTabPane.setSelectedComponent(newListPanel);
            }
            ((CardLayout)this.getInfoPanel().getLayout()).show(this.getInfoPanel(), newDisplayKind.toString());
        } else if (this.getSelectedComponent() != null) {
            Display panel;
            String changedTo = null;
            ResourceKind resource = this.getSelectedDisplay().getResourceKind();
            if (changes.contains((Object)SimulatorModel.Change.toChange(resource)) && source.isSelected(resource)) {
                changedTo = source.getResource(resource).getFullName();
            }
            if (changedTo == null && (panel = this.getDisplay(source.getDisplay())) != null && this.indexOfComponent(panel) >= 0) {
                this.setSelectedComponent(panel);
            }
        }
        this.activateListeners();
    }

    public Display getSelectedDisplay() {
        return this.getDisplayAt(this.getSelectedIndex());
    }

    public JGraphPanel<?> getGraphPanel() {
        JComponent result = null;
        Display display = this.getSelectedDisplay();
        if (display.getResourceKind() != null) {
            Component selectedComponent = ((ResourceDisplay)display).getTabPane().getSelectedComponent();
            if (selectedComponent instanceof GraphEditorTab) {
                result = ((GraphEditorTab)selectedComponent).getEditArea();
            } else if (selectedComponent instanceof GraphTab) {
                result = ((GraphTab)selectedComponent).getEditArea();
            } else if (selectedComponent instanceof JGraphPanel) {
                result = (JGraphPanel)selectedComponent;
            }
        } else if (display.getKind() == DisplayKind.LTS) {
            result = ((LTSDisplay)display).getGraphPanel();
        } else if (display.getKind() == DisplayKind.STATE) {
            result = ((StateDisplay)display).getGraphPanel();
        }
        return result;
    }

    public ResourceDisplay getDisplayFor(ResourceKind resource) {
        return (ResourceDisplay)this.getDisplay(DisplayKind.toDisplay(resource));
    }

    public void attach(Display display) {
        DisplayKind otherKind;
        int index;
        if (this.indexOfComponent(display) >= 0) {
            return;
        }
        this.detachedMap.remove((Object)display.getKind());
        DisplayKind myKind = display.getKind();
        Display.ListPanel listPanel = display.getListPanel();
        JTabbedPane listsPanel = this.getListsPanel(display.getKind());
        if (listPanel != null && listsPanel.indexOfComponent(listPanel) < 0) {
            index = 0;
            while (index < listsPanel.getTabCount()) {
                otherKind = ((Display.ListPanel)listsPanel.getComponentAt(index)).getDisplayKind();
                if (otherKind == null || myKind.compareTo(otherKind) < 0) break;
                ++index;
            }
            listsPanel.insertTab(null, myKind.getTabIcon(), listPanel, myKind.getTip(), index);
        }
        if (myKind.showDisplay()) {
            this.getInfoPanel().add((Component)display.getInfoPanel(), display.getKind().toString());
            index = 0;
            while (index < this.getTabCount()) {
                otherKind = this.getDisplayAt(index).getKind();
                if (otherKind == null || myKind.compareTo(otherKind) < 0) break;
                ++index;
            }
            this.insertTab(null, null, display, myKind.getTip(), index);
            TabLabel tabComponent = new TabLabel(this, display, (Icon)myKind.getTabIcon(), null);
            tabComponent.setFocusable(false);
            this.setTabComponentAt(index, tabComponent);
            this.setTabEnabled(index, index == this.getSelectedIndex());
        }
    }

    public void detach(Display display) {
        this.revertSelection();
        this.detachedMap.put(display.getKind(), new DisplayWindow(this, display));
    }

    public JFrame getFrameOf(Component panel) {
        if (this.indexOfComponent(panel) < 0) {
            Container window = panel.getParent();
            while (window != null && !(window instanceof DisplayWindow)) {
                window = window.getParent();
            }
            return (JFrame)window;
        }
        return null;
    }

    public void dispose() {
        for (DisplayWindow window : this.detachedMap.values()) {
            window.dispose();
        }
    }

    @Override
    public void remove(Component component) {
        if (this.indexOfComponent(component) < 0) {
            JFrame frame = this.getFrameOf(component);
            if (frame != null) {
                frame.dispose();
            }
            DisplayKind kind = ((Display)component).getKind();
            this.detachedMap.remove((Object)kind);
        } else {
            if (this.getSelectedComponent() == component) {
                this.revertSelection();
            }
            super.remove(component);
        }
    }

    private JPopupMenu createDetachMenu(final Display display) {
        assert (this.indexOfComponent(display) >= 0);
        JPopupMenu result = new JPopupMenu();
        result.add(new AbstractAction("Detach"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplaysPanel.this.detach(display);
            }
        });
        return result;
    }

    private JPopupMenu createOptionalsMenu() {
        JPopupMenu result = new JPopupMenu();
        for (ResourceKind optionalTab : Options.getOptionalTabs()) {
            String optionName = Options.getShowTabOption(optionalTab);
            result.add(this.simulator.getOptions().getItem(optionName));
        }
        return result;
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.getSelectedIndex() != index) {
            int selectedIndex = this.getSelectedIndex();
            if (selectedIndex >= 0) {
                this.setTabEnabled(selectedIndex, false);
            }
            this.setTabEnabled(index, true);
            this.lastSelected = this.getSelectedComponent();
            super.setSelectedIndex(index);
        }
        this.getSelectedComponent().requestFocus();
    }

    private void setTabEnabled(int index, boolean enabled) {
        TabLabel label = (TabLabel)this.getTabComponentAt(index);
        if (label != null) {
            label.setFont(label.getFont().deriveFont(1));
            label.setEnabled(enabled);
            label.setTitle(enabled ? this.getDisplayAt(index).getKind().getTitle() : null);
        }
    }

    protected Display getDisplayAt(int index) {
        return (Display)this.getComponentAt(index);
    }

    public void revertSelection() {
        if (this.lastSelected != null && this.indexOfComponent(this.lastSelected) >= 0) {
            this.setSelectedComponent(this.lastSelected);
        } else {
            this.lastSelected = null;
        }
    }

    public boolean saveAllEditors(boolean dispose) {
        boolean result = true;
        DisplayKind[] displayKindArray = DisplayKind.values();
        int n = displayKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayKind kind = displayKindArray[n2];
            if (kind.hasResource() && !(result = ((ResourceDisplay)this.getDisplay(kind)).saveAllEditors(dispose))) break;
            ++n2;
        }
        return result;
    }

    private SimulatorModel getSimulatorModel() {
        return this.simulator.getModel();
    }
}

