/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.graph.Graph;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JGraphMode;
import groove.gui.jgraph.JModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JGraphPanel<G extends Graph>
extends JPanel {
    private JScrollPane scrollPane;
    private JPanel statusBar;
    private JLabel statusLabel;
    private final JGraph<G> jGraph;
    private Color enabledBackground = Color.WHITE;
    public static final int MINIMUM_LABEL_PANE_WIDTH = 100;

    public JGraphPanel(JGraph<G> jGraph) {
        super(false);
        this.setFocusable(false);
        this.setFocusCycleRoot(true);
        this.jGraph = jGraph;
    }

    public void initialise() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getScrollPane(), "Center");
        this.add((Component)this.getStatusBar(), "South");
        this.installListeners();
        this.setEnabled(false);
    }

    private void installListeners() {
        this.getJGraph().addJGraphModeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JGraphPanel.this.getScrollPane().setWheelScrollingEnabled(evt.getNewValue() != JGraphMode.PAN_MODE);
            }
        });
        this.getJGraph().addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JModel jModel = (JModel)((Object)evt.getNewValue());
                JGraphPanel.this.setEnabled(jModel != null);
            }
        });
    }

    private JScrollPane getScrollPane() {
        JScrollPane result = this.scrollPane;
        if (result == null) {
            result = this.scrollPane = new JScrollPane((Component)((Object)this.getJGraph()));
            result.getVerticalScrollBar().setUnitIncrement(10);
            result.setDoubleBuffered(false);
            result.setPreferredSize(new Dimension(500, 400));
        }
        return result;
    }

    public JPanel getStatusBar() {
        JPanel result = this.statusBar;
        if (result == null) {
            result = this.statusBar = new JPanel();
            result.setBorder(null);
            result.setLayout(new BorderLayout());
            result.add((Component)this.getStatusLabel(), "Center");
        }
        return result;
    }

    private boolean hasStatusBar() {
        return this.statusBar != null;
    }

    public JLabel getStatusLabel() {
        JLabel result = this.statusLabel;
        if (result == null) {
            result = this.statusLabel = new JLabel();
            result.setBorder(null);
        }
        return result;
    }

    public JGraph<G> getJGraph() {
        return this.jGraph;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jGraph.setEnabled(enabled);
        this.getScrollPane().getHorizontalScrollBar().setEnabled(enabled);
        this.getScrollPane().getVerticalScrollBar().setEnabled(enabled);
        if (this.hasStatusBar()) {
            this.getStatusBar().setEnabled(enabled);
        }
        super.setEnabled(enabled);
        Color background = enabled ? this.getEnabledBackground() : null;
        this.getJGraph().setBackground(background);
    }

    protected Color getEnabledBackground() {
        return this.enabledBackground;
    }

    protected void setEnabledBackground(Color enabledBackground) {
        this.enabledBackground = enabledBackground;
        if (this.isEnabled()) {
            this.getJGraph().setBackground(enabledBackground);
        }
    }
}

