/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.grammar.model.GrammarModel;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorListener;
import groove.gui.SimulatorModel;
import groove.gui.display.Display;
import groove.gui.display.DisplayKind;
import groove.gui.display.JGraphPanel;
import groove.gui.display.TitledPanel;
import groove.gui.jgraph.JAttr;
import groove.gui.jgraph.JGraphMode;
import groove.gui.jgraph.LTSJEdge;
import groove.gui.jgraph.LTSJGraph;
import groove.gui.jgraph.LTSJModel;
import groove.gui.jgraph.LTSJVertex;
import groove.gui.tree.LabelTree;
import groove.lts.GTS;
import groove.lts.GTSAdapter;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jgraph.graph.GraphModel;

public class LTSDisplay
extends Display
implements SimulatorListener {
    private JToggleButton filterLTSButton;
    private JPanel boundSpinnerPanel;
    private JSpinner boundSpinner;
    private SpinnerNumberModel boundSpinnerModel;
    private LTSGraphPanel graphPanel;
    private LTSJGraph jGraph;
    private LabelTree<GTS> labelTree;
    private final MyLTSListener ltsListener = new MyLTSListener();

    public LTSDisplay(Simulator simulator) {
        super(simulator, DisplayKind.LTS);
        this.setStateBound(100);
    }

    @Override
    protected void buildDisplay() {
        this.setLayout(new BorderLayout());
        JToolBar toolBar = Options.createToolBar();
        this.fillToolBar(toolBar);
        this.add((Component)toolBar, "North");
        this.add(this.getGraphPanel());
    }

    @Override
    protected void installListeners() {
        this.getJGraph().addMouseListener(new MyMouseListener());
        this.getSimulatorModel().addListener(this, SimulatorModel.Change.GRAMMAR, SimulatorModel.Change.GTS, SimulatorModel.Change.STATE, SimulatorModel.Change.MATCH);
    }

    @Override
    protected Display.ListPanel createListPanel() {
        return null;
    }

    @Override
    protected JTree createList() {
        return null;
    }

    @Override
    protected JToolBar createListToolBar() {
        return null;
    }

    @Override
    protected JComponent createInfoPanel() {
        LabelTree<GTS> labelTree = this.getLabelTree();
        final TitledPanel result = new TitledPanel("Transition labels", labelTree, null, true);
        result.setEnabledBackground(JAttr.STATE_BACKGROUND);
        this.getJGraph().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("background") && evt.getNewValue() != null) {
                    result.setEnabledBackground((Color)evt.getNewValue());
                }
            }
        });
        return result;
    }

    private void fillToolBar(JToolBar result) {
        result.removeAll();
        result.add(this.getActions().getExplorationDialogAction());
        result.addSeparator();
        result.add(this.getActions().getStartSimulationAction());
        result.add(this.getActions().getApplyMatchAction());
        result.add(this.getActions().getAnimateAction());
        result.add(this.getActions().getExploreAction());
        result.addSeparator();
        result.add(this.getActions().getBackAction());
        result.add(this.getActions().getForwardAction());
        result.addSeparator();
        result.add(this.getJGraph().getModeButton(JGraphMode.SELECT_MODE));
        result.add(this.getJGraph().getModeButton(JGraphMode.PAN_MODE));
        result.addSeparator();
        result.add(this.getFilterLTSButton());
        result.add(this.getBoundSpinnerPanel());
        result.add(Box.createGlue());
    }

    private JToggleButton getFilterLTSButton() {
        if (this.filterLTSButton == null) {
            this.filterLTSButton = Options.createToggleButton(this.getActions().getFilterLTSAction());
        }
        return this.filterLTSButton;
    }

    public boolean isFilteringLts() {
        return this.getFilterLTSButton().isSelected();
    }

    private JPanel getBoundSpinnerPanel() {
        JPanel result = this.boundSpinnerPanel;
        if (result == null) {
            result = new JPanel();
            result.setLayout(new BoxLayout(result, 0));
            result.add(Box.createRigidArea(new Dimension(5, 0)));
            result.add(new JLabel("Show states up to"));
            result.add(Box.createRigidArea(new Dimension(5, 0)));
            result.add(this.getBoundSpinner());
            result.add(Box.createGlue());
            this.boundSpinnerPanel = result;
        }
        return this.boundSpinnerPanel;
    }

    private JSpinner getBoundSpinner() {
        if (this.boundSpinner == null) {
            this.boundSpinner = new JSpinner(this.getBoundSpinnerModel());
            this.boundSpinner.setMaximumSize(new Dimension(10, 100));
            this.boundSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (LTSDisplay.this.getJModel() != null) {
                        LTSDisplay.this.getActions().getReloadLTSAction().execute();
                    }
                }
            });
        }
        return this.boundSpinner;
    }

    private SpinnerNumberModel getBoundSpinnerModel() {
        if (this.boundSpinnerModel == null) {
            this.boundSpinnerModel = new SpinnerNumberModel();
            this.boundSpinnerModel.setMinimum(Integer.valueOf(100));
            this.boundSpinnerModel.setMaximum(Integer.valueOf(100000));
            this.boundSpinnerModel.setStepSize(100);
            this.boundSpinnerModel.setValue(100);
        }
        return this.boundSpinnerModel;
    }

    public void setStateBound(int bound) {
        this.getBoundSpinnerModel().setValue(bound);
    }

    public int getStateBound() {
        return (Integer)this.getBoundSpinnerModel().getValue();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getBoundSpinner().setEnabled(enabled);
        ((JSpinner.NumberEditor)this.getBoundSpinner().getEditor()).getTextField().setBackground(enabled ? this.getGraphPanel().getEnabledBackground() : null);
    }

    public void emphasiseStates(List<GraphState> counterExamples, boolean showTransitions) {
        if (this.getJModel() == null) {
            return;
        }
        HashSet jCells = new HashSet();
        int i = 0;
        while (i < counterExamples.size()) {
            GraphState state = counterExamples.get(i);
            jCells.add(this.getJModel().getJCellForNode(state));
            if (showTransitions && i + 1 < counterExamples.size()) {
                for (GraphTransition graphTransition : state.getTransitions(GraphTransition.Class.ANY)) {
                    if (graphTransition.target() != counterExamples.get(i + 1)) continue;
                    jCells.add(this.getJModel().getJCellForEdge(graphTransition));
                    break;
                }
            }
            ++i;
        }
        this.getJGraph().setSelectionCells(jCells.toArray());
    }

    public LTSGraphPanel getGraphPanel() {
        LTSGraphPanel result = this.graphPanel;
        if (result == null) {
            result = this.graphPanel = new LTSGraphPanel(this.getJGraph());
            result.initialise();
        }
        return result;
    }

    public LTSJGraph getJGraph() {
        LTSJGraph result = this.jGraph;
        if (result == null) {
            result = this.jGraph = new LTSJGraph(this.getSimulator());
            result.setLabelTree(this.getLabelTree());
            result.addProgressObserver(new ProgressObserver());
        }
        return result;
    }

    public LTSJModel getJModel() {
        return this.getJGraph().getModel();
    }

    private LabelTree<GTS> getLabelTree() {
        LabelTree<GTS> result = this.labelTree;
        if (result == null) {
            result = this.labelTree = new LabelTree<GTS>(this.getJGraph(), true);
        }
        return result;
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        if (changes.contains((Object)SimulatorModel.Change.GTS) || changes.contains((Object)SimulatorModel.Change.GRAMMAR)) {
            GTS gts = source.getGts();
            if (gts == null) {
                this.getJGraph().setModel(null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GrammarModel grammar = LTSDisplay.this.getSimulatorModel().getGrammar();
                        if (grammar != null && grammar.getErrors().isEmpty()) {
                            LTSDisplay.this.getActions().getStartSimulationAction().execute();
                        }
                    }
                });
            } else {
                LTSJModel ltsModel;
                if (gts != oldModel.getGts()) {
                    ltsModel = (LTSJModel)this.getJGraph().newModel();
                    this.getJGraph().setFiltering(this.isFilteringLts());
                    ltsModel.setStateBound(this.getStateBound());
                    ltsModel.loadGraph(gts);
                    this.getJGraph().setModel((GraphModel)ltsModel);
                } else {
                    ltsModel = this.getJModel();
                    if (ltsModel.size() != gts.size()) {
                        ltsModel.loadGraph(gts);
                    }
                    GraphState state = source.getState();
                    GraphTransition transition = source.getTransition();
                    this.getJGraph().setActive(state, transition);
                }
                this.getGraphPanel().refreshBackground();
                this.getJGraph().refreshFiltering();
                this.getJGraph().doLayout(true);
                this.setEnabled(true);
            }
            if (gts != oldModel.getGts()) {
                if (oldModel.getGts() != null) {
                    oldModel.getGts().removeLTSListener(this.ltsListener);
                }
                if (gts != null) {
                    gts.addLTSListener(this.ltsListener);
                    this.updateStatus(gts);
                }
            }
        }
        if ((changes.contains((Object)SimulatorModel.Change.STATE) || changes.contains((Object)SimulatorModel.Change.MATCH)) && this.getJModel() != null) {
            GraphState state = source.getState();
            GraphTransition transition = source.getTransition();
            this.getJGraph().setActive(state, transition);
        }
    }

    public void toggleFilterLts() {
        boolean isFiltering = this.isFilteringLts();
        this.getJGraph().setFiltering(isFiltering);
        this.getJGraph().refreshFiltering();
        if (!isFiltering) {
            this.getJGraph().doLayout(false);
        }
        this.getGraphPanel().refreshBackground();
        this.setEnabled(true);
    }

    public static LTSDisplay newInstance(Simulator simulator) {
        LTSDisplay result = new LTSDisplay(simulator);
        result.buildDisplay();
        return result;
    }

    private void updateStatus(GTS gts) {
        StringBuilder text = new StringBuilder();
        if (gts == null) {
            text.append("No start state loaded");
        } else {
            text.append("Currently explored: ");
            text.append(gts.nodeCount());
            text.append(" states");
            if (gts.openStateCount() > 0 || gts.hasFinalStates()) {
                text.append(" (");
                if (gts.openStateCount() > 0) {
                    text.append(String.valueOf(gts.openStateCount()) + " open");
                    if (gts.hasFinalStates()) {
                        text.append(", ");
                    }
                }
                if (gts.hasFinalStates()) {
                    text.append(String.valueOf(gts.getFinalStates().size()) + " final");
                }
                text.append(")");
            }
            text.append(", ");
            text.append(gts.edgeCount());
            text.append(" transitions");
        }
        this.getGraphPanel().getStatusLabel().setText(text.toString());
    }

    public class LTSGraphPanel
    extends JGraphPanel<GTS> {
        public LTSGraphPanel(LTSJGraph jGraph) {
            super(jGraph);
            this.getJGraph().setToolTipEnabled(true);
            this.setEnabledBackground(JAttr.STATE_BACKGROUND);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.getJGraph().getModeAction(JGraphMode.SELECT_MODE).setEnabled(enabled);
            this.getJGraph().getModeAction(JGraphMode.PAN_MODE).setEnabled(enabled);
            if (enabled) {
                this.getJGraph().getModeButton(JGraphMode.SELECT_MODE).doClick();
            }
            LTSDisplay.this.setEnabled(enabled);
        }

        public void refreshBackground() {
            boolean incomplete = LTSDisplay.this.isFilteringLts();
            LTSJModel jModel = (LTSJModel)this.getJGraph().getModel();
            if (!incomplete) {
                incomplete = jModel.getStateBound() < jModel.getGraph().nodeCount();
            }
            Color background = incomplete ? JAttr.FILTER_BACKGROUND : JAttr.STATE_BACKGROUND;
            this.setEnabledBackground(background);
        }
    }

    private class MyLTSListener
    extends GTSAdapter {
        MyLTSListener() {
        }

        @Override
        public void addUpdate(GTS gts, GraphState state) {
            assert (gts == LTSDisplay.this.getSimulatorModel().getGts()) : "I want to listen only to my lts";
            LTSDisplay.this.updateStatus(gts);
        }

        @Override
        public void addUpdate(GTS gts, GraphTransition transition) {
            assert (gts == LTSDisplay.this.getSimulatorModel().getGts()) : "I want to listen only to my lts";
            LTSDisplay.this.updateStatus(gts);
        }

        @Override
        public void statusUpdate(GTS gts, GraphState closed, GraphState.Flag flag) {
            assert (gts == LTSDisplay.this.getSimulatorModel().getGts()) : "I want to listen only to my lts";
            LTSDisplay.this.updateStatus(gts);
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (LTSDisplay.this.getJGraph().getMode() == JGraphMode.SELECT_MODE && evt.getButton() == 1) {
                if (!LTSDisplay.this.isEnabled() && LTSDisplay.this.getActions().getStartSimulationAction().isEnabled()) {
                    LTSDisplay.this.getActions().getStartSimulationAction().execute();
                } else {
                    Point loc = evt.getPoint();
                    Object cell = LTSDisplay.this.getJGraph().getFirstCellForLocation(loc.x, loc.y);
                    if (cell instanceof LTSJEdge) {
                        GraphTransition trans = ((LTSJEdge)cell).getEdge();
                        LTSDisplay.this.getSimulatorModel().setTransition(trans);
                    } else if (cell instanceof LTSJVertex) {
                        GraphState node = ((LTSJVertex)cell).getNode();
                        LTSDisplay.this.getSimulatorModel().setState(node);
                        if (evt.getClickCount() == 2) {
                            LTSDisplay.this.getActions().getExploreAction().doExploreState();
                        }
                    }
                }
            }
        }
    }

    private class ProgressObserver
    implements Observer {
        private final JProgressBar bar = new JProgressBar();

        ProgressObserver() {
            this.bar.setStringPainted(true);
            this.bar.setIndeterminate(true);
            LTSDisplay.this.getGraphPanel().getStatusBar().add((Component)this.bar, "East");
            this.bar.setVisible(false);
        }

        @Override
        public void update(Observable o, Object arg) {
            String message = (String)arg;
            if (message.length() == 0) {
                this.hideProgressBar();
            } else {
                this.showProgressBar(message);
            }
        }

        private void showProgressBar(String message) {
            this.bar.setVisible(true);
            this.bar.setString(message);
        }

        private void hideProgressBar() {
            this.bar.setVisible(false);
        }
    }
}

