/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import gnu.prolog.io.TermWriter;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.PrologException;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.display.ResourceDisplay;
import groove.gui.display.TitledPanel;
import groove.lts.MatchResult;
import groove.prolog.GrooveEnvironment;
import groove.prolog.GrooveState;
import groove.prolog.PrologEngine;
import groove.prolog.QueryResult;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PrologDisplay
extends ResourceDisplay {
    private static final int MAX_HISTORY = 50;
    static final Preferences PREFS = Preferences.userNodeForPackage(PrologDisplay.class);
    private GrooveEnvironment environment;
    private PrologEngine engine;
    private JComboBox queryField;
    private JTextComponent queryEdit;
    private JPanel resultsPanel;
    private JTextArea results;
    private final JLabel resultsStatus = new JLabel(" ");
    private OutputStream userOutput;
    private JTabbedPane syntaxHelp;
    private JTree prologTree;
    private JTree grooveTree;
    private JTree userTree;
    private JButton nextResultButton;
    private int solutionCount;
    static final Font EDIT_FONT = new Font("Monospaced", 0, 12);

    PrologDisplay(Simulator simulator) {
        super(simulator, ResourceKind.PROLOG);
        Environment.setDefaultOutputStream((OutputStream)this.getUserOutput());
    }

    @Override
    protected void buildDisplay() {
        JPanel queryPane = new JPanel(new BorderLayout());
        JLabel leading = new JLabel(" ?- ");
        leading.setFont(leading.getFont().deriveFont(1));
        queryPane.add((Component)leading, "West");
        queryPane.add((Component)this.getQueryField(), "Center");
        JPanel buttonsPane = new JPanel(new FlowLayout(1, 0, 0));
        buttonsPane.add(this.createExecuteButton());
        buttonsPane.add(this.getNextResultButton());
        buttonsPane.setBorder(null);
        queryPane.add((Component)buttonsPane, "East");
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(0.4);
        splitPane.setBottomComponent(this.getTabPane());
        splitPane.setTopComponent(this.getResultsPanel());
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.add((Component)queryPane, "North");
        mainPane.add((Component)splitPane, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)mainPane, "Center");
    }

    @Override
    protected JComponent createInfoPanel() {
        return new TitledPanel("Available predicates", this.getSyntaxHelp(), null, false);
    }

    @Override
    protected void buildInfoPanel() {
        this.getInfoPanel().setEnabled(this.isEnabled());
    }

    private OutputStream getUserOutput() {
        if (this.userOutput == null) {
            this.userOutput = new JTextAreaOutputStream(this.getResultsArea());
        }
        return this.userOutput;
    }

    private JTextComponent getQueryEdit() {
        if (this.queryEdit == null) {
            this.getQueryField();
        }
        return this.queryEdit;
    }

    private JComboBox getQueryField() {
        if (this.queryField == null) {
            this.queryField = new JComboBox<String>(PREFS.get("queryHistory", "").split("\\n"));
            this.queryField.setFont(EDIT_FONT);
            this.queryField.setEditable(true);
            this.queryField.setEnabled(true);
            this.queryField.setPrototypeDisplayValue("groove+prolog");
            this.queryEdit = (JTextComponent)this.queryField.getEditor().getEditorComponent();
            this.queryEdit.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        PrologDisplay.this.executeQuery();
                        PrologDisplay.this.giveFocusToNextResultButton();
                    }
                }
            });
        }
        return this.queryField;
    }

    private JTabbedPane getSyntaxHelp() {
        if (this.syntaxHelp == null) {
            this.syntaxHelp = this.createSyntaxHelp();
        }
        return this.syntaxHelp;
    }

    private JTabbedPane createSyntaxHelp() {
        JTabbedPane treePane = new JTabbedPane(){

            @Override
            public void setEnabled(boolean enabled) {
                PrologDisplay.this.getGrooveTree().setEnabled(enabled);
                PrologDisplay.this.getPrologTree().setEnabled(enabled);
                PrologDisplay.this.getUserTree().setEnabled(enabled);
            }
        };
        treePane.add("Groove", new JScrollPane(this.getGrooveTree()));
        treePane.add("Prolog", new JScrollPane(this.getPrologTree()));
        treePane.add("User", new JScrollPane(this.getUserTree()));
        return treePane;
    }

    private JTree getGrooveTree() {
        if (this.grooveTree == null) {
            this.grooveTree = this.createPredicateTree(true);
            this.loadSyntaxHelpTree(this.grooveTree, this.getEnvironment().getGrooveTags());
        }
        return this.grooveTree;
    }

    private JTree getPrologTree() {
        if (this.prologTree == null) {
            this.prologTree = this.createPredicateTree(false);
            this.loadSyntaxHelpTree(this.prologTree, this.getEnvironment().getPrologTags());
        }
        return this.prologTree;
    }

    private JTree getUserTree() {
        if (this.userTree == null) {
            this.userTree = this.createPredicateTree(false);
            this.loadSyntaxHelpTree(this.userTree, this.getEnvironment().getUserTags());
        }
        return this.userTree;
    }

    private void loadSyntaxHelpTree(JTree tree, Set<CompoundTermTag> tags) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)tree.getModel().getRoot();
        rootNode.removeAllChildren();
        HashMap<AtomTerm, DefaultMutableTreeNode> nodes = new HashMap<AtomTerm, DefaultMutableTreeNode>();
        for (CompoundTermTag tag : tags) {
            DefaultMutableTreeNode baseNode = (DefaultMutableTreeNode)nodes.get(tag.functor);
            if (baseNode == null) {
                baseNode = new DefaultMutableTreeNode(tag);
                rootNode.add(baseNode);
                nodes.put(tag.functor, baseNode);
                continue;
            }
            if (baseNode.getChildCount() == 0) {
                baseNode.add(new DefaultMutableTreeNode(baseNode.getUserObject()));
                baseNode.setUserObject(tag.functor.value);
            }
            DefaultMutableTreeNode predNode = new DefaultMutableTreeNode(tag);
            baseNode.add(predNode);
        }
        ((DefaultTreeModel)tree.getModel()).reload();
        tree.expandPath(new TreePath(rootNode.getPath()));
    }

    private JPanel getResultsPanel() {
        if (this.resultsPanel == null) {
            this.resultsPanel = new JPanel(new BorderLayout());
            this.resultsPanel.setBorder(null);
            this.resultsPanel.setPreferredSize(new Dimension(0, 200));
            this.resultsPanel.add(new JScrollPane(this.getResultsArea()));
            this.resultsPanel.add((Component)this.resultsStatus, "South");
        }
        return this.resultsPanel;
    }

    private JTextArea getResultsArea() {
        if (this.results == null) {
            this.results = new JTextArea();
            this.results.setFont(EDIT_FONT);
            this.results.setText("");
            this.results.setEditable(false);
            this.results.setEnabled(true);
            this.results.setBackground(Color.WHITE);
        }
        return this.results;
    }

    private JButton createExecuteButton() {
        return Options.createButton(this.getActions().getPrologFirstResultAction());
    }

    private JButton getNextResultButton() {
        if (this.nextResultButton == null) {
            this.nextResultButton = Options.createButton(this.getActions().getPrologNextResultAction());
            this.nextResultButton.setFocusable(true);
        }
        return this.nextResultButton;
    }

    private Action getNextResultAction() {
        return this.getActions().getPrologNextResultAction();
    }

    private JTree createPredicateTree(final boolean toolTips) {
        final JTree result = new JTree(new DefaultMutableTreeNode()){

            @Override
            public String getToolTipText(MouseEvent evt) {
                if (!toolTips || this.getRowForLocation(evt.getX(), evt.getY()) == -1) {
                    return null;
                }
                TreePath curPath = this.getPathForLocation(evt.getX(), evt.getY());
                Object userObject = ((DefaultMutableTreeNode)curPath.getLastPathComponent()).getUserObject();
                if (userObject instanceof CompoundTermTag) {
                    return PrologDisplay.this.getEngine().getEnvironment().getToolTipText((CompoundTermTag)userObject);
                }
                return null;
            }
        };
        result.setRootVisible(false);
        result.setShowsRootHandles(true);
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)result.getCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        ToolTipManager.sharedInstance().registerComponent(result);
        result.addMouseListener(new MouseAdapter(){
            private final ToolTipManager manager = ToolTipManager.sharedInstance();
            private final int standardDelay = this.manager.getDismissDelay();

            @Override
            public void mouseClicked(MouseEvent e) {
                Object o;
                TreePath sel;
                if (e.getClickCount() > 1 && e.getButton() == 1 && (sel = result.getSelectionPath()) != null && (o = sel.getLastPathComponent()) instanceof DefaultMutableTreeNode && (o = ((DefaultMutableTreeNode)o).getUserObject()) instanceof CompoundTermTag) {
                    CompoundTermTag tag = (CompoundTermTag)o;
                    StringBuilder sb = new StringBuilder(PrologDisplay.this.getQueryField().getSelectedItem().toString());
                    if (sb.length() > 0 && !sb.toString().endsWith(",")) {
                        sb.append(',');
                    }
                    sb.append(tag.functor.value);
                    if (tag.arity > 0) {
                        sb.append('(');
                        int i = 0;
                        while (i < tag.arity) {
                            if (i > 0) {
                                sb.append(',');
                            }
                            sb.append('_');
                            ++i;
                        }
                        sb.append(')');
                    }
                    PrologDisplay.this.getQueryField().setSelectedItem(sb.toString());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getSource() == result) {
                    this.manager.setDismissDelay(Integer.MAX_VALUE);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.getSource() == result) {
                    this.manager.setDismissDelay(this.standardDelay);
                }
            }
        });
        return result;
    }

    @Override
    protected void updateGrammar(GrammarModel grammar, boolean fresh) {
        super.updateGrammar(grammar, fresh);
        this.environment = null;
        this.engine = null;
        this.loadSyntaxHelpTree(this.getUserTree(), this.getEnvironment().getUserTags());
    }

    public void executeQuery() {
        this.executeQuery(this.getQueryEdit().getText());
    }

    private GrooveEnvironment getEnvironment() {
        if (this.environment == null) {
            this.environment = this.getSimulatorModel().getGrammar() == null ? new GrooveEnvironment(null, this.getUserOutput()) : this.getSimulatorModel().getGrammar().getPrologEnvironment();
        }
        return this.environment;
    }

    private PrologEngine getEngine() {
        this.resultsStatus.setText(" ");
        if (this.engine == null) {
            try {
                this.engine = new PrologEngine(this.getEnvironment());
            }
            catch (FormatException e) {
                this.getResultsArea().append("\nError loading the prolog engine:\n");
                this.getResultsArea().append(e.getMessage());
            }
        }
        return this.engine;
    }

    public void executeQuery(String queryString) {
        if (this.getGrammar() == null) {
            this.getResultsArea().setText("Please first load a grammar and select a start graph.");
            return;
        }
        if (this.getGrammar().getStartGraphModel() == null) {
            this.getResultsArea().setText("Please first select a start graph.");
            return;
        }
        if (this.getEngine() == null) {
            this.getResultsArea().setText("Failed to initialize prolog.");
            return;
        }
        if (queryString == null) {
            return;
        }
        if ((queryString = queryString.trim()).length() == 0) {
            return;
        }
        if (queryString.endsWith(".")) {
            queryString = queryString.substring(0, queryString.length() - 1);
        }
        try {
            this.addQueryHistory(queryString);
            this.getResultsArea().setText("?- " + queryString + "\n");
            MatchResult match = this.getSimulatorModel().getMatch();
            this.getEngine().setGrooveState(new GrooveState(this.getGrammar().toGrammar(), this.getSimulatorModel().getGts(), this.getSimulatorModel().getState(), match == null ? null : match.getEvent()));
            this.solutionCount = 0;
            this.processResults(this.getEngine().newQuery(queryString));
        }
        catch (Exception e) {
            this.handlePrologException(e);
        }
    }

    private void addQueryHistory(String queryString) {
        JComboBox query = this.getQueryField();
        query.removeItem(queryString);
        query.insertItemAt(queryString, 0);
        query.setSelectedIndex(0);
        while (query.getItemCount() > 50) {
            query.removeItemAt(50);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < query.getItemCount()) {
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(query.getItemAt(i));
            ++i;
        }
        PREFS.put("queryHistory", sb.toString());
    }

    private void handlePrologException(Throwable e) {
        try {
            this.getUserOutput().flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (e.getCause() instanceof PrologException) {
            PrologException pe = (PrologException)e.getCause();
            if (pe.getCause() == null) {
                this.getResultsArea().append(e.getCause().getMessage());
                return;
            }
            e = pe;
        }
        this.getResultsArea().append(e.getMessage());
    }

    public void nextResults() {
        if (this.getEngine() != null) {
            this.getResultsArea().append("\n");
            try {
                this.processResults(this.getEngine().next());
            }
            catch (PrologException e) {
                this.handlePrologException(e);
            }
        }
    }

    public boolean hasNextResult() {
        return this.getEngine() != null && this.getEngine().hasNext();
    }

    public void giveFocusToNextResultButton() {
        assert (this.nextResultButton != null);
        this.nextResultButton.requestFocusInWindow();
    }

    private void processResults(QueryResult queryResult) {
        try {
            this.getUserOutput().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JTextArea results = this.getResultsArea();
        if (!results.getText().endsWith("\n")) {
            results.append("\n");
        }
        if (queryResult == null) {
            results.append("No\n");
            this.getNextResultAction().setEnabled(false);
        } else {
            switch (queryResult.getReturnValue()) {
                case SUCCESS: 
                case SUCCESS_LAST: {
                    ++this.solutionCount;
                    for (Map.Entry<String, Object> entry : queryResult.getVariables().entrySet()) {
                        results.append(entry.getKey());
                        results.append(" = ");
                        if (entry.getValue() instanceof Term) {
                            results.append(TermWriter.toString((Term)((Term)entry.getValue())));
                        } else {
                            results.append("" + entry.getValue());
                        }
                        results.append("\n");
                    }
                    results.append("Yes\n");
                    this.getNextResultAction().setEnabled(true);
                    break;
                }
                case FAIL: {
                    results.append("No\n");
                    this.getNextResultAction().setEnabled(false);
                    break;
                }
                case HALT: {
                    results.append("Interpreter was halted\n");
                    break;
                }
                default: {
                    results.append(String.format("Unexpected return value: %s", this.getEngine().lastReturnValue().toString()));
                }
            }
            this.resultsStatus.setText(String.format("%d solution(s); Executed in %fms", this.solutionCount, (double)queryResult.getExecutionTime() / 1000000.0));
        }
    }

    private GrammarModel getGrammar() {
        return this.getSimulatorModel().getGrammar();
    }

    static class JTextAreaOutputStream
    extends OutputStream {
        JTextArea dest;
        static final int BUFFER_SIZE = 512;
        int[] buffer = new int[512];
        int pos = 0;

        JTextAreaOutputStream(JTextArea toArea) {
            this.dest = toArea;
        }

        @Override
        public void write(int arg0) throws IOException {
            this.buffer[this.pos++] = arg0;
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.pos == 0) {
                return;
            }
            this.dest.append(new String(this.buffer, 0, this.pos));
            this.buffer = new int[512];
            this.pos = 0;
        }
    }
}

