/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.gui.Icons;
import groove.gui.display.Display;
import groove.gui.display.DisplaysPanel;
import groove.gui.display.ResourceTab;
import groove.gui.list.ListTabbedPane;
import groove.gui.look.Values;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public class TabLabel
extends JPanel {
    private final JLabel iconLabel;
    private final Kind kind;
    private final boolean hasButton;
    private TabButton button;
    private ResourceTab tab;
    private JTabbedPane parent;
    private Display display;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    private TabLabel(Kind tabKind, Icon icon, String title, boolean button) {
        super(new FlowLayout(0, 1, 0));
        this.setOpaque(false);
        this.setBorder(null);
        this.kind = tabKind;
        this.hasButton = button;
        this.iconLabel = new JLabel(title, icon, 2);
        this.iconLabel.setBackground(Values.ERROR_COLOR);
        this.iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, tabKind.getHGap()));
        if (tabKind != Kind.RESOURCE) {
            this.iconLabel.setFont(this.iconLabel.getFont().deriveFont(1));
        }
        this.add(this.iconLabel);
        if (button && title != null) {
            this.add(this.getButton());
        }
    }

    public TabLabel(ResourceTab tab, Icon icon, String title) {
        this(Kind.RESOURCE, icon, title, tab.isEditor());
        this.tab = tab;
    }

    public TabLabel(DisplaysPanel parent, Display display, Icon icon, String title) {
        this(Kind.DISPLAY, icon, title, true);
        this.display = display;
        this.parent = parent;
    }

    public TabLabel(Display display, ResourceTab tab, Icon icon, String title) {
        this(Kind.STATE, icon, title, false);
        this.display = display;
    }

    public TabLabel(ListTabbedPane parent, Icon icon, String title) {
        this(Kind.LIST, icon, title, true);
        this.parent = parent;
    }

    public void setTitle(String title) {
        this.iconLabel.setText(title);
        if (title == null) {
            this.remove(this.getButton());
        } else if (this.hasButton) {
            this.add(this.getButton());
        }
    }

    public void setError(boolean error) {
        this.iconLabel.setOpaque(error);
        this.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.iconLabel.setEnabled(enabled);
    }

    public JLabel getLabel() {
        return this.iconLabel;
    }

    protected JButton getButton() {
        if (this.button == null) {
            this.button = new TabButton();
        }
        return this.button;
    }

    protected void doButtonAction() {
        switch (this.kind) {
            case RESOURCE: {
                this.tab.saveEditor(true, true);
                break;
            }
            case DISPLAY: {
                ((DisplaysPanel)this.parent).detach(this.display);
                break;
            }
            case LIST: {
                ((ListTabbedPane)this.parent).closeSearchTab();
            }
        }
    }

    private static enum Kind {
        RESOURCE(1, "Cancel Edit"),
        DISPLAY(3, "Detach"),
        STATE(5, "Detach"),
        LIST(5, "Close");

        private final int hGap;
        private final String name;

        private Kind(int hGap, String name) {
            this.hGap = hGap;
            this.name = name;
        }

        public int getHGap() {
            return this.hGap;
        }

        public String getName() {
            return this.name;
        }
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        public TabButton() {
            int size = 17;
            this.setPreferredSize(new Dimension(size, size));
            this.setToolTipText(TabLabel.this.kind.getName());
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
            if (TabLabel.this.kind != Kind.RESOURCE && TabLabel.this.kind != Kind.LIST) {
                this.setIcon(Icons.PIN_ICON);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabLabel.this.doButtonAction();
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (TabLabel.this.kind == Kind.RESOURCE || TabLabel.this.kind == Kind.LIST) {
                Graphics2D g2 = (Graphics2D)g.create();
                if (this.getModel().isPressed()) {
                    g2.translate(1, 1);
                }
                g2.setStroke(new BasicStroke(2.0f));
                g2.setColor(Color.BLACK);
                if (this.getModel().isRollover()) {
                    g2.setColor(Color.MAGENTA);
                }
                int delta = 6;
                g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
                g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
                g2.dispose();
            }
        }
    }
}

