/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.grammar.model.FormatError;
import groove.gui.jgraph.AspectJCell;
import groove.gui.look.VisualKey;
import groove.util.collect.NestedIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class AspectJCellErrors
implements Iterable<FormatError> {
    private final AspectJCell jCell;
    private final List<FormatError> aspectErrors = new ArrayList<FormatError>();
    private final List<FormatError> extraErrors = new ArrayList<FormatError>();

    AspectJCellErrors(AspectJCell jCell) {
        this.jCell = jCell;
    }

    void addError(FormatError error, boolean aspect) {
        this.getErrors(aspect).add(error);
        this.jCell.setStale(VisualKey.ERROR);
    }

    void addErrors(Collection<FormatError> errors, boolean aspect) {
        this.getErrors(aspect).addAll(errors);
        this.jCell.setStale(VisualKey.ERROR);
    }

    void clear(boolean aspect) {
        this.getErrors(aspect).clear();
        this.jCell.setStale(VisualKey.ERROR);
    }

    @Override
    public Iterator<FormatError> iterator() {
        return new NestedIterator<FormatError>(this.getErrors(true).iterator(), this.getErrors(false).iterator());
    }

    public boolean isEmpty() {
        return this.aspectErrors.isEmpty() && this.extraErrors.isEmpty();
    }

    private List<FormatError> getErrors(boolean aspect) {
        return aspect ? this.aspectErrors : this.extraErrors;
    }
}

