/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectKind;
import groove.grammar.aspect.AspectNode;
import groove.grammar.model.FormatError;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.GraphBasedModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.TypeModel;
import groove.grammar.type.ImplicitTypeGraph;
import groove.grammar.type.TypeGraph;
import groove.graph.Edge;
import groove.graph.Element;
import groove.graph.GraphInfo;
import groove.graph.GraphProperties;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.gui.jgraph.AJCell;
import groove.gui.jgraph.AspectJCell;
import groove.gui.jgraph.AspectJEdge;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.AspectJVertex;
import groove.gui.jgraph.JModel;
import groove.gui.layout.JEdgeLayout;
import groove.gui.layout.LayoutMap;
import groove.gui.look.VisualMap;
import groove.util.ChangeCount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.undo.UndoableEdit;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.ParentMap;

public final class AspectJModel
extends JModel<AspectGraph> {
    private GrammarModel grammar;
    private final ChangeCount graphModCount;
    private final ChangeCount.Derived<GraphBasedModel<?>> resource;
    private final ChangeCount.Derived<TypeGraph> typeGraph;
    private boolean beingEdited = false;
    private GraphProperties properties;
    private Map<FormatError, AspectJCell> errorMap = new HashMap<FormatError, AspectJCell>();
    private Set<Integer> usedNrs;
    private boolean loading;
    static final Map<AspectKind, String> ROLE_NAMES = new EnumMap<AspectKind, String>(AspectKind.class);
    static final Map<AspectKind, String> ROLE_DESCRIPTIONS = new EnumMap<AspectKind, String>(AspectKind.class);
    private static final boolean GUI_DEBUG = false;

    static {
        ROLE_NAMES.put(AspectKind.EMBARGO, "Embargo");
        ROLE_NAMES.put(AspectKind.READER, "Reader");
        ROLE_NAMES.put(AspectKind.CREATOR, "Creator");
        ROLE_NAMES.put(AspectKind.ADDER, "Adder");
        ROLE_NAMES.put(AspectKind.ERASER, "Eraser");
        ROLE_NAMES.put(AspectKind.REMARK, "Remark");
        ROLE_DESCRIPTIONS.put(AspectKind.EMBARGO, "Must be absent from a graph for this rule to apply");
        ROLE_DESCRIPTIONS.put(AspectKind.READER, "Must be matched for this rule to apply");
        ROLE_DESCRIPTIONS.put(AspectKind.CREATOR, "Will be created by applying this rule");
        ROLE_DESCRIPTIONS.put(AspectKind.ADDER, "Must be absent from a graph for this rule to apply, and will be created when applying this rule");
        ROLE_DESCRIPTIONS.put(AspectKind.ERASER, "Will be deleted by applying this rule");
        ROLE_DESCRIPTIONS.put(AspectKind.REMARK, "Has no effect on the execution of the rule");
    }

    AspectJModel(AspectJGraph jGraph) {
        super(jGraph);
        this.graphModCount = new ChangeCount();
        this.resource = new ChangeCount.Derived<GraphBasedModel<?>>(this.graphModCount){

            @Override
            protected GraphBasedModel<?> computeValue() {
                GraphBasedModel<?> result = null;
                if (AspectJModel.this.getJGraph().isEditable() || AspectJModel.this.getJGraph().isForState()) {
                    result = AspectJModel.this.getGrammar().createGraphModel(AspectJModel.this.getGraph());
                } else {
                    ResourceKind kind = ResourceKind.toResource(AspectJModel.this.getJGraph().getGraphRole());
                    result = AspectJModel.this.getGrammar().getGraphResource(kind, AspectJModel.this.getName());
                }
                return result;
            }
        };
        this.typeGraph = new ChangeCount.Derived<TypeGraph>(this.graphModCount){

            @Override
            protected TypeGraph computeValue() {
                TypeGraph result;
                GraphBasedModel<?> resourceModel = AspectJModel.this.getResourceModel();
                if (resourceModel instanceof TypeModel) {
                    try {
                        result = (TypeGraph)((TypeModel)resourceModel).toResource();
                    }
                    catch (FormatException formatException) {
                        result = ImplicitTypeGraph.newInstance(resourceModel.getLabels());
                    }
                } else {
                    result = AspectJModel.this.getGrammar().getTypeGraph();
                }
                return result;
            }
        };
        this.graphModCount.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                AspectJModel.this.loadViewErrors();
            }
        });
    }

    public AspectJGraph getJGraph() {
        return (AspectJGraph)super.getJGraph();
    }

    @Override
    public List<? extends AspectJCell> getRoots() {
        return super.getRoots();
    }

    @Override
    public AspectGraph getGraph() {
        return (AspectGraph)super.getGraph();
    }

    public void setGrammar(GrammarModel grammar) {
        assert ((this.grammar == null || this.grammar == grammar) && grammar != null);
        this.grammar = grammar;
    }

    GrammarModel getGrammar() {
        return this.grammar;
    }

    public AspectJCell getJCell(Element elem) {
        return (AspectJCell)super.getJCell(elem);
    }

    public AspectJCell getJCellForEdge(Edge edge) {
        return (AspectJCell)super.getJCellForEdge(edge);
    }

    public AspectJVertex getJCellForNode(Node node) {
        return (AspectJVertex)super.getJCellForNode(node);
    }

    @Override
    public void loadGraph(AspectGraph graph) {
        this.setLoading(true);
        super.loadGraph(graph);
        for (AspectJCell aspectJCell : this.getRoots()) {
            aspectJCell.saveToUserObject();
        }
        this.properties = GraphInfo.getProperties(graph);
        this.graphModCount.increase();
        this.setLoading(false);
    }

    public AspectJModel cloneWithNewGraph(AspectGraph graph) {
        AspectJModel result = this.getJGraph().newModel();
        if (this.getGrammar() != null) {
            result.setGrammar(this.getGrammar());
        }
        result.beingEdited = this.beingEdited;
        result.loadGraph(graph);
        return result;
    }

    public void syncGraph() {
        if (this.isLoading()) {
            return;
        }
        GraphRole role = this.getGraph().getRole();
        HashMap<AspectNode, AspectJVertex> nodeJVertexMap = new HashMap<AspectNode, AspectJVertex>();
        HashMap<AspectEdge, AJCell> edgeJCellMap = new HashMap<AspectEdge, AJCell>();
        AspectGraph graph = new AspectGraph(this.getName(), role);
        for (AspectJCell aspectJCell : this.getRoots()) {
            if (!(aspectJCell instanceof AspectJVertex)) continue;
            AspectJVertex jVertex = (AspectJVertex)aspectJCell;
            jVertex.loadFromUserObject(role);
            graph.addNode(jVertex.getNode());
            nodeJVertexMap.put(jVertex.getNode(), jVertex);
            for (AspectEdge edge : jVertex.getEdges()) {
                edgeJCellMap.put(edge, jVertex);
                graph.addEdgeContext(edge);
            }
        }
        for (AspectJCell aspectJCell : this.getRoots()) {
            if (!(aspectJCell instanceof AspectJEdge)) continue;
            AspectJEdge jEdge = (AspectJEdge)aspectJCell;
            jEdge.loadFromUserObject(role);
            for (AspectEdge edge : jEdge.getEdges()) {
                edgeJCellMap.put(edge, jEdge);
                graph.addEdgeContext(edge);
            }
        }
        for (AspectJVertex aspectJVertex : nodeJVertexMap.values()) {
            aspectJVertex.setNodeFixed();
        }
        LayoutMap layoutMap = new LayoutMap();
        for (AspectJCell aspectJCell : this.getRoots()) {
            if (aspectJCell instanceof AspectJVertex) {
                AspectJVertex jVertex = (AspectJVertex)aspectJCell;
                layoutMap.putNode((Node)jVertex.getNode(), jVertex.getVisuals());
                continue;
            }
            AspectJEdge jEdge = (AspectJEdge)aspectJCell;
            VisualMap visuals = jEdge.getVisuals();
            if (JEdgeLayout.newInstance(visuals).isDefault()) continue;
            for (AspectEdge edge : jEdge.getEdges()) {
                layoutMap.putEdge((Edge)edge, visuals);
            }
        }
        GraphInfo.setLayoutMap(graph, layoutMap);
        GraphInfo.setProperties(graph, this.getProperties());
        graph.setFixed();
        this.setGraph(graph);
        this.nodeJCellMap.clear();
        this.nodeJCellMap.putAll(nodeJVertexMap);
        this.edgeJCellMap.clear();
        this.edgeJCellMap.putAll(edgeJCellMap);
        this.graphModCount.increase();
    }

    private void loadViewErrors() {
        if (this.getGrammar() == null) {
            return;
        }
        for (AspectJCell aspectJCell : this.getRoots()) {
            aspectJCell.getErrors().clear(false);
        }
        this.errorMap.clear();
        for (FormatError formatError : this.getResourceModel().getErrors()) {
            for (Element errorObject : formatError.getElements()) {
                AspectJCell errorCell = this.getJCell(errorObject);
                if (errorCell == null && errorObject instanceof Edge) {
                    errorCell = this.getJCell(((Edge)errorObject).source());
                }
                if (errorCell == null) continue;
                this.errorMap.put(formatError, errorCell);
                errorCell.getErrors().addError(formatError, true);
            }
        }
    }

    public GraphBasedModel<?> getResourceModel() {
        return this.resource.getValue();
    }

    public TypeGraph getTypeGraph() {
        return this.typeGraph.getValue();
    }

    public Map<FormatError, AspectJCell> getErrorMap() {
        return this.errorMap;
    }

    public void setName(String name) {
        this.setGraph(this.getGraph().rename(name));
    }

    public final GraphProperties getProperties() {
        if (this.properties == null) {
            this.properties = new GraphProperties();
        }
        return this.properties;
    }

    @Override
    public boolean isMergeBidirectionalEdges() {
        if (this.beingEdited || this.getGraph().getRole() != GraphRole.HOST) {
            return false;
        }
        return super.isMergeBidirectionalEdges();
    }

    public void setBeingEdited(boolean flag) {
        this.beingEdited = flag;
    }

    public boolean acceptsSource(Object edge, Object port) {
        return port != null;
    }

    public void remove(Object[] roots) {
        LinkedList<Object> removables = new LinkedList<Object>(Arrays.asList(roots));
        Object[] objectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof AspectJVertex) {
                AspectJVertex cell = (AspectJVertex)element;
                removables.addAll(cell.getPort().getEdges());
            }
            ++n2;
        }
        super.remove(removables.toArray());
    }

    public void insert(Object[] roots, Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        LinkedHashSet<Object> insertables = new LinkedHashSet<Object>();
        Object[] objectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Object root = objectArray[n2];
            boolean insert = true;
            if (root instanceof AspectJEdge) {
                AspectJEdge jEdge = (AspectJEdge)root;
                DefaultPort sourcePort = (DefaultPort)cs.getPort((Object)jEdge, true);
                DefaultPort targetPort = (DefaultPort)cs.getPort((Object)jEdge, false);
                boolean bl = insert = sourcePort != null && targetPort != null;
            }
            if (insert) {
                insertables.add(root);
            } else {
                attributes.remove(root);
            }
            ++n2;
        }
        if (cs != null) {
            Iterator it = cs.connections();
            while (it.hasNext()) {
                ConnectionSet.Connection conn = (ConnectionSet.Connection)it.next();
                if (insertables.contains(conn.getEdge())) continue;
                it.remove();
            }
        }
        super.insert(insertables.toArray(), attributes, cs, pm, edits);
    }

    public Map<?, ?> cloneCells(Object[] cells) {
        Map result = super.cloneCells(cells);
        this.collectNodeNrs();
        ArrayList<AspectJVertex> newJVertices = new ArrayList<AspectJVertex>();
        for (Object jCell : result.values()) {
            if (jCell instanceof AspectJVertex) {
                AspectJVertex jVertex = (AspectJVertex)jCell;
                jVertex.setJModel(this);
                jVertex.setNode(this.createAspectNode());
                newJVertices.add(jVertex);
                continue;
            }
            if (!(jCell instanceof AspectJEdge)) continue;
            AspectJEdge jEdge = (AspectJEdge)jCell;
            jEdge.setJModel(this);
        }
        for (AspectJVertex jVertex : newJVertices) {
            jVertex.setNodeFixed();
        }
        this.resetNodeNrs();
        return result;
    }

    public void setGraphModified() {
        this.graphModCount.increase();
    }

    @Override
    protected void fireGraphChanged(Object source, GraphModelEvent.GraphModelChange edit) {
        if (!this.isLoading()) {
            boolean changed;
            boolean bl = changed = edit.getInserted() != null && edit.getInserted().length > 0 || edit.getRemoved() != null && edit.getRemoved().length > 0 || edit.getConnectionSet() != null && !edit.getConnectionSet().isEmpty();
            if (!changed && edit.getAttributes() != null) {
                for (Object attrValue : edit.getAttributes().values()) {
                    AttributeMap attrMap = (AttributeMap)attrValue;
                    if (!attrMap.containsKey((Object)"value")) continue;
                    changed = true;
                    break;
                }
            }
            if (changed) {
                this.syncGraph();
            }
        }
        super.fireGraphChanged(source, edit);
    }

    @Override
    protected final boolean isLoading() {
        return this.loading;
    }

    private void setLoading(boolean loading) {
        this.loading = loading;
    }

    AspectNode createAspectNode() {
        return new AspectNode(this.createNewNodeNr(), this.getGraph().getRole());
    }

    private boolean collectNodeNrs() {
        boolean result;
        boolean bl = result = this.usedNrs == null;
        if (result) {
            this.usedNrs = new HashSet<Integer>();
            for (AspectJCell aspectJCell : this.getRoots()) {
                if (!(aspectJCell instanceof AspectJVertex)) continue;
                this.usedNrs.add(((AspectJVertex)aspectJCell).getNumber());
            }
        }
        return result;
    }

    private void resetNodeNrs() {
        this.usedNrs = null;
    }

    private int createNewNodeNr() {
        int result = 0;
        boolean collect = this.collectNodeNrs();
        while (this.usedNrs.contains(result)) {
            ++result;
        }
        if (collect) {
            this.resetNodeNrs();
        } else {
            this.usedNrs.add(result);
        }
        return result;
    }

    public void addGraphChangeListener(Observer listener) {
        this.graphModCount.addObserver(listener);
    }

    public void removeGraphChangeListener(Observer listener) {
        this.graphModCount.deleteObserver(listener);
    }
}

