/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.control.CtrlAut;
import groove.control.CtrlLabel;
import groove.control.CtrlState;
import groove.control.CtrlTransition;
import groove.graph.Edge;
import groove.gui.jgraph.AJEdge;
import groove.gui.jgraph.CtrlJGraph;
import groove.gui.jgraph.CtrlJVertex;
import groove.gui.jgraph.JModel;
import groove.gui.look.Look;
import groove.io.HTMLConverter;
import groove.util.Groove;

public class CtrlJEdge
extends AJEdge<CtrlAut, CtrlJGraph, JModel<CtrlAut>, CtrlJVertex> {
    private CtrlJEdge() {
    }

    @Override
    public CtrlTransition getEdge() {
        return (CtrlTransition)super.getEdge();
    }

    @Override
    public boolean isCompatible(Edge edge) {
        return super.isCompatible(edge) && ((CtrlTransition)edge).isStart() == this.getEdge().isStart();
    }

    @Override
    StringBuilder getEdgeKindDescription() {
        return new StringBuilder("transition");
    }

    @Override
    String getLabelDescription() {
        StringBuffer result = new StringBuffer(", generated by ");
        String[] displayedLabels = new String[this.getEdges().size()];
        int labelIndex = 0;
        for (Edge part : this.getEdges()) {
            CtrlTransition trans = (CtrlTransition)part;
            String description = ((CtrlLabel)trans.label()).text();
            displayedLabels[labelIndex] = HTMLConverter.STRONG_TAG.on(description, true);
            ++labelIndex;
        }
        if (displayedLabels.length == 1) {
            result.append(displayedLabels[0]);
        } else {
            result.append(Groove.toString(displayedLabels, "<br>- ", "", "<br>- "));
        }
        return result.toString();
    }

    @Override
    protected Look getStructuralLook() {
        boolean exitsRecipe;
        boolean omega = this.getEdge().getCall().isOmega();
        boolean bl = exitsRecipe = this.getEdge().isStart() && ((CtrlState)this.getEdge().source()).isTransient();
        Look result = exitsRecipe ? (omega ? Look.CTRL_OMEGA_EXIT_TRANS : Look.CTRL_EXIT_TRANS) : (omega ? Look.CTRL_OMEGA_TRANS : Look.BASIC);
        return result;
    }

    public static CtrlJEdge newInstance() {
        return new CtrlJEdge();
    }
}

