/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.graph.Edge;
import groove.graph.Element;
import groove.graph.Graph;
import groove.graph.GraphInfo;
import groove.graph.Node;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JVertex;
import groove.gui.layout.JEdgeLayout;
import groove.gui.layout.JVertexLayout;
import groove.gui.layout.LayoutMap;
import groove.gui.look.VisualKey;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.ParentMap;

public abstract class JModel<G extends Graph>
extends DefaultGraphModel {
    private final JGraph<G> jGraph;
    private G graph;
    private LayoutMap layoutMap;
    private boolean loading;
    protected Map<Node, JVertex<G>> nodeJCellMap = new HashMap<Node, JVertex<G>>();
    protected Map<Edge, JCell<G>> edgeJCellMap = new HashMap<Edge, JCell<G>>();
    protected final Map<JVertex<G>, Set<JEdge<G>>> addedJEdges = new HashMap<JVertex<G>, Set<JEdge<G>>>();
    protected final List<JCell<G>> addedJCells = new LinkedList<JCell<G>>();
    protected ConnectionSet connections;
    private boolean vetoFireGraphChanged;
    protected transient int nodeX;
    protected transient int nodeY;
    private static final Random randomGenerator = new Random();

    protected JModel(JGraph<G> jGraph) {
        this.jGraph = jGraph;
    }

    public JGraph<G> getJGraph() {
        return this.jGraph;
    }

    public List<? extends JCell<G>> getRoots() {
        return super.getRoots();
    }

    public void refreshVisuals() {
        for (JCell<G> jCell : this.getRoots()) {
            jCell.setStale(VisualKey.refreshables());
        }
    }

    public int size() {
        return this.nodeJCellMap.size() + this.edgeJCellMap.size();
    }

    void toBackSilent(Collection<? extends JCell<G>> jCells) {
        this.createLayerEdit(jCells.toArray(), -2).execute();
    }

    public AttributeMap getAttributes(Object node) {
        AttributeMap result = node instanceof JCell ? ((JCell)node).getAttributes() : super.getAttributes(node);
        assert (result != null) : String.format("Cell %s has no attributes", node);
        return result;
    }

    public String getName() {
        return this.getGraph() == null ? null : this.getGraph().getName();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public LayoutMap getLayoutMap() {
        return this.layoutMap;
    }

    void setGraph(G graph) {
        this.graph = graph;
        this.layoutMap = GraphInfo.getLayoutMap(graph);
    }

    public void loadGraph(G graph) {
        this.prepareLoad(graph);
        this.addElements(graph.nodeSet(), graph.edgeSet(), true);
    }

    protected void addElements(Collection<? extends Node> nodeSet, Collection<? extends Edge> edgeSet, boolean replace) {
        this.prepareInsert();
        this.getJGraph().notifyProgress("Loading");
        for (Node node : nodeSet) {
            this.addNode(node);
        }
        for (Edge edge : edgeSet) {
            this.addEdge(edge);
        }
        this.getJGraph().notifyProgress("Rendering");
        this.doInsert(replace);
        this.getJGraph().notifyProgress("");
    }

    protected void prepareLoad(G graph) {
        this.graph = graph;
        this.layoutMap = GraphInfo.getLayoutMap(graph);
        if (this.layoutMap == null) {
            this.layoutMap = new LayoutMap();
            GraphInfo.setLayoutMap(graph, this.layoutMap);
        }
        this.nodeJCellMap.clear();
        this.edgeJCellMap.clear();
    }

    public JCell<G> getJCell(Element elem) {
        if (elem instanceof Node) {
            return this.getJCellForNode((Node)elem);
        }
        return this.getJCellForEdge((Edge)elem);
    }

    public JCell<G> getJCellForEdge(Edge edge) {
        return this.edgeJCellMap.get(edge);
    }

    public JVertex<G> getJCellForNode(Node node) {
        return this.nodeJCellMap.get(node);
    }

    public void synchroniseLayout(JCell<G> jCell) {
        LayoutMap layoutMap = this.getLayoutMap();
        if (jCell instanceof JEdge) {
            for (Edge edge : ((JEdge)jCell).getEdges()) {
                layoutMap.putEdge(edge, jCell.getVisuals());
            }
        } else if (jCell instanceof JVertex) {
            layoutMap.putNode(((JVertex)jCell).getNode(), jCell.getVisuals());
        }
    }

    public void setLayoutable(boolean layoutable) {
        for (JCell<G> jCell : this.getRoots()) {
            jCell.setLayoutable(true);
        }
    }

    public Map<Node, Color> getColorMap() {
        HashMap<Node, Color> result = new HashMap<Node, Color>();
        for (JCell<G> jCell : this.getRoots()) {
            Color foreground;
            if (!(jCell instanceof JVertex) || (foreground = jCell.getVisuals().getForeground()) == null) continue;
            result.put(((JVertex)jCell).getNode(), foreground);
        }
        return result;
    }

    protected void fireGraphChanged(Object source, GraphModelEvent.GraphModelChange edit) {
        if (!this.isLoading()) {
            Object[] objectArray = edit.getChanged();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object jCell = objectArray[n2];
                if (jCell instanceof JCell) {
                    JCell graphJCell = (JCell)jCell;
                    this.synchroniseLayout(graphJCell);
                }
                ++n2;
            }
        }
        if (!this.vetoFireGraphChanged()) {
            super.fireGraphChanged(source, edit);
        }
    }

    protected boolean vetoFireGraphChanged() {
        return this.vetoFireGraphChanged;
    }

    protected void setVetoFireGraphChanged(boolean veto) {
        this.vetoFireGraphChanged = veto;
    }

    public boolean isMergeBidirectionalEdges() {
        return this.getJGraph().isShowBidirectionalEdges();
    }

    protected JVertex<G> addNode(Node node) {
        JVertex<G> jVertex = this.computeJVertex(node);
        this.addedJCells.add(0, jVertex);
        this.nodeJCellMap.put(node, jVertex);
        this.addedJEdges.put(jVertex, new HashSet());
        return jVertex;
    }

    protected JCell<G> addEdge(Edge edge) {
        JCell<G> result = this.edgeJCellMap.get(edge);
        JVertex<G> sourceJVertex = this.getJCellForNode(edge.source());
        assert (sourceJVertex != null) : "No vertex for source node of " + edge;
        if (result == null && sourceJVertex.isCompatible(edge)) {
            sourceJVertex.addEdge(edge);
            result = sourceJVertex;
        }
        if (result == null) {
            for (JEdge<G> jEdge : this.getJEdges(sourceJVertex)) {
                if (!jEdge.isCompatible(edge)) continue;
                jEdge.addEdge(edge);
                result = jEdge;
                break;
            }
        }
        if (result == null) {
            JEdge<G> jEdge;
            jEdge = this.computeJEdge(edge);
            result = jEdge;
            this.addedJCells.add(result);
            JVertex<G> targetJVertex = this.getJCellForNode(edge.target());
            assert (targetJVertex != null) : "No vertex for target node of " + edge;
            this.connections.connect(result, (Object)sourceJVertex.getPort(), (Object)targetJVertex.getPort());
            this.addJEdge(sourceJVertex, jEdge);
            this.addJEdge(targetJVertex, jEdge);
        }
        this.edgeJCellMap.put(edge, result);
        return result;
    }

    private Set<JEdge<G>> getJEdges(JVertex<G> jVertex) {
        Set<JEdge<G>> result = this.addedJEdges.get(jVertex);
        if (result == null) {
            result = Collections.unmodifiableSet(jVertex.getContext());
        }
        return result;
    }

    private void addJEdge(JVertex<G> jVertex, JEdge<G> jEdge) {
        Set<JEdge<G>> jEdges = this.addedJEdges.get(jVertex);
        if (jEdges != null) {
            jEdges.add(jEdge);
        }
    }

    protected JEdge<G> computeJEdge(Edge edge) {
        JEdge<G> result = this.createJEdge(edge);
        JEdgeLayout layout = this.getLayoutMap().getLayout(edge);
        if (layout != null) {
            result.putVisuals(layout.toVisuals());
        } else {
            result.setLayoutable(true);
        }
        return result;
    }

    protected JVertex<G> computeJVertex(Node node) {
        JVertex<G> result = this.createJVertex(node);
        result.setNode(node);
        JVertexLayout layout = this.getLayoutMap().getLayout(node);
        if (layout != null) {
            result.putVisuals(layout.toVisuals());
        } else {
            Point2D.Double nodePos = new Point2D.Double(this.nodeX, this.nodeY);
            result.putVisual(VisualKey.NODE_POS, nodePos);
            this.nodeX = this.randomCoordinate();
            this.nodeY = this.randomCoordinate();
            result.setLayoutable(true);
        }
        return result;
    }

    protected JEdge<G> createJEdge(Edge edge) {
        JEdge<G> result = this.getJGraph().getFactory().newJEdge(edge);
        result.setJModel(this);
        if (edge != null) {
            result.addEdge(edge);
        }
        return result;
    }

    protected JVertex<G> createJVertex(Node node) {
        JVertex<G> result = this.getJGraph().getFactory().newJVertex(node);
        result.setJModel(this);
        result.setNode(node);
        return result;
    }

    protected void prepareInsert() {
        this.addedJCells.clear();
        this.addedJEdges.clear();
        this.connections = new ConnectionSet();
        this.setLoading(true);
    }

    protected void doInsert(boolean replace) {
        Object[] addedCells = this.addedJCells.toArray();
        Object[] removedCells = replace ? this.getRoots().toArray() : null;
        this.createEdit(addedCells, removedCells, null, this.connections, this.getParentMap(), null).execute();
        ArrayList<JEdge> edges = new ArrayList<JEdge>();
        Object[] objectArray = addedCells;
        int n = addedCells.length;
        int n2 = 0;
        while (n2 < n) {
            Object jCell = objectArray[n2];
            if (jCell instanceof JEdge) {
                edges.add((JEdge)jCell);
            }
            ++n2;
        }
        this.toBackSilent(edges);
        this.setLoading(false);
    }

    protected ParentMap getParentMap() {
        return null;
    }

    protected int randomCoordinate() {
        Rectangle bounds = new Rectangle();
        Object[] objectArray = this.getJGraph().getSelectionCells();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object cell = objectArray[n2];
            if (cell instanceof JVertex) {
                bounds.add(((JVertex)cell).getVisuals().getNodePos());
            }
            ++n2;
        }
        return 25 + randomGenerator.nextInt((this.nodeJCellMap.size() + this.edgeJCellMap.size()) * 5 + 1);
    }

    private void setLoading(boolean loading) {
        this.loading = loading;
    }

    protected boolean isLoading() {
        return this.loading;
    }
}

