/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JModel;
import groove.gui.jgraph.JVertex;
import groove.gui.jgraph.LTSJGraph;
import groove.gui.look.Look;
import groove.gui.look.VisualKey;
import groove.lts.GTS;
import groove.lts.GTSListener;
import groove.lts.GraphState;
import groove.lts.GraphTransition;

public final class LTSJModel
extends JModel<GTS>
implements GTSListener {
    private boolean listening = true;
    private int stateBound;
    public static final String DEFAULT_LTS_NAME = "lts";

    LTSJModel(LTSJGraph jGraph) {
        super(jGraph);
    }

    public LTSJGraph getJGraph() {
        return (LTSJGraph)super.getJGraph();
    }

    @Override
    public GTS getGraph() {
        return (GTS)super.getGraph();
    }

    @Override
    public String getName() {
        String result = super.getName();
        if (result == null) {
            result = DEFAULT_LTS_NAME;
        }
        return result;
    }

    @Override
    public synchronized void addUpdate(GTS gts, GraphState state) {
        if (this.listening) {
            this.prepareInsert();
            this.addNode(state);
            this.doInsert(false);
        }
    }

    @Override
    public synchronized void addUpdate(GTS gts, GraphTransition transition) {
        if (this.listening) {
            this.prepareInsert();
            JCell edgeJCell = this.addEdge(transition);
            this.doInsert(false);
            JVertex stateJCell = this.getJCellForNode(transition.target());
            stateJCell.setStale(VisualKey.VISIBLE);
            edgeJCell.setStale(VisualKey.VISIBLE);
        }
    }

    @Override
    public void statusUpdate(GTS lts, GraphState explored, GraphState.Flag flag) {
        JVertex jCell = this.getJCellForNode(explored);
        switch (flag) {
            case ABSENT: {
                jCell.setLook(Look.ABSENT, true);
                break;
            }
            case CLOSED: {
                jCell.setLook(Look.OPEN, false);
                break;
            }
            case ERROR: {
                jCell.setStale(VisualKey.ERROR);
                break;
            }
            case DONE: {
                if (explored.isAbsent()) {
                    for (JEdge jEdge : jCell.getContext()) {
                        jEdge.setLook(Look.ABSENT, true);
                    }
                    jCell.setLook(Look.ABSENT, true);
                }
                if (explored.isTransient()) {
                    for (JEdge jEdge : jCell.getContext()) {
                        jEdge.setLook(Look.TRANSIENT, true);
                    }
                    jCell.setLook(Look.TRANSIENT, true);
                }
                jCell.setLook(Look.FINAL, lts.isFinal(explored));
                jCell.setLook(Look.RESULT, lts.isResult(explored));
            }
        }
    }

    @Override
    public void loadGraph(GTS gts) {
        this.listening = false;
        GTS oldGTS = this.getGraph();
        if (oldGTS != null && gts != oldGTS) {
            oldGTS.removeLTSListener(this);
        }
        super.loadGraph(gts);
        if (gts != null && gts != oldGTS) {
            gts.addLTSListener(this);
        }
        this.getJGraph().reactivate();
        this.listening = true;
    }

    public int setStateBound(int bound) {
        int result = this.stateBound;
        this.stateBound = bound;
        return result;
    }

    public int getStateBound() {
        return this.stateBound;
    }
}

