/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.layout;

import groove.graph.EdgeComparator;
import groove.graph.NodeComparator;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JVertex;
import groove.gui.layout.AbstractLayouter;
import groove.gui.layout.Layouter;
import groove.util.Pair;
import groove.util.collect.CollectionOfCollections;
import groove.util.collect.NestedIterator;
import groove.util.collect.TransformIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jgraph.graph.EdgeView;

public class ForestLayouter
extends AbstractLayouter {
    public static final String ACTION_NAME = "Forest layout";
    public static final int MIN_CHILD_DISTANCE = 60;
    public static final int MIN_NODE_DISTANCE = 40;
    public static final int VERTICAL_SPACE = 40;
    private final Map<Integer, Set<AbstractLayouter.Layoutable>> inDegreeMap = new TreeMap<Integer, Set<AbstractLayouter.Layoutable>>();
    private final Map<AbstractLayouter.Layoutable, Set<AbstractLayouter.Layoutable>> branchMap = new LinkedHashMap<AbstractLayouter.Layoutable, Set<AbstractLayouter.Layoutable>>();
    private final Collection<AbstractLayouter.Layoutable> roots = new LinkedList<AbstractLayouter.Layoutable>();
    private static final Comparator<JEdge<?>> edgeComparator = new Comparator<JEdge<?>>(){

        @Override
        public int compare(JEdge<?> o1, JEdge<?> o2) {
            int result = nodeComp.compare(o1.getTargetNode(), o2.getTargetNode());
            if (result != 0) {
                return result;
            }
            result = edgeComp.compare(o1.getEdge(), o2.getEdge());
            return result;
        }
    };
    private static final NodeComparator nodeComp = NodeComparator.instance();
    private static final EdgeComparator edgeComp = EdgeComparator.instance();

    public ForestLayouter() {
        super(ACTION_NAME);
    }

    protected ForestLayouter(String name, JGraph<?> jgraph) {
        super(name, jgraph);
    }

    @Override
    public Layouter newInstance(JGraph<?> jgraph) {
        return new ForestLayouter(this.getName(), jgraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        JGraph jGraph = this.jgraph;
        synchronized (jGraph) {
            this.prepare();
            this.computeBranchMap();
            this.computeRoots();
            this.layout(this.roots, 0);
            this.shift(this.roots, 40);
            this.finish();
        }
    }

    protected Collection<?> getSuggestedRoots() {
        return Arrays.asList(this.jgraph.getSelectionCells());
    }

    private void computeBranchMap() {
        this.inDegreeMap.clear();
        this.branchMap.clear();
        for (Map.Entry cellLayoutableEntry : this.toLayoutableMap.entrySet()) {
            Object key = cellLayoutableEntry.getKey();
            AbstractLayouter.Layoutable cellLayoutable = (AbstractLayouter.Layoutable)cellLayoutableEntry.getValue();
            LinkedHashSet<AbstractLayouter.Layoutable> branchSet = new LinkedHashSet<AbstractLayouter.Layoutable>();
            this.branchMap.put(cellLayoutable, branchSet);
            if (!(key instanceof JVertex) || !((JVertex)key).getVisuals().isVisible()) continue;
            int inEdgeCount = 0;
            TreeSet outEdges = new TreeSet(edgeComparator);
            Iterator edgeIter = ((JVertex)key).getPort().edges();
            while (edgeIter.hasNext()) {
                JEdge jEdge = (JEdge)edgeIter.next();
                EdgeView edgeView = (EdgeView)this.jgraph.getGraphLayoutCache().getMapping(jEdge, false);
                if (edgeView == null || !jEdge.getVisuals().isVisible() || jEdge.isGrayedOut()) continue;
                JVertex sourceVertex = jEdge.getSourceVertex();
                if (sourceVertex.equals(key)) {
                    outEdges.add(jEdge);
                    continue;
                }
                ++inEdgeCount;
            }
            for (JEdge jEdge : outEdges) {
                EdgeView edgeView = (EdgeView)this.jgraph.getGraphLayoutCache().getMapping(jEdge, false);
                List points = edgeView.getPoints();
                JVertex targetVertex = jEdge.getTargetVertex();
                int i = 1;
                while (i < points.size() - 1) {
                    branchSet.add((AbstractLayouter.Layoutable)this.toLayoutableMap.get(Pair.newPair(jEdge, i)));
                    ++i;
                }
                branchSet.add((AbstractLayouter.Layoutable)this.toLayoutableMap.get(targetVertex));
            }
            Integer n = inEdgeCount;
            Set<AbstractLayouter.Layoutable> cellsWithInEdgeCount = this.inDegreeMap.get(n);
            if (cellsWithInEdgeCount == null) {
                cellsWithInEdgeCount = new LinkedHashSet<AbstractLayouter.Layoutable>();
                this.inDegreeMap.put(n, cellsWithInEdgeCount);
            }
            cellsWithInEdgeCount.add(cellLayoutable);
        }
    }

    private void computeRoots() {
        Iterator<AbstractLayouter.Layoutable> rootIter = new CollectionOfCollections<AbstractLayouter.Layoutable>((Collection<Collection<AbstractLayouter.Layoutable>>)this.inDegreeMap.values()).iterator();
        Collection<?> suggestedRoots = this.getSuggestedRoots();
        if (suggestedRoots != null && !suggestedRoots.isEmpty()) {
            TransformIterator<Object, AbstractLayouter.Layoutable> suggestedRootIter = new TransformIterator<Object, AbstractLayouter.Layoutable>(suggestedRoots.iterator()){

                @Override
                public AbstractLayouter.Layoutable toOuter(Object in) {
                    AbstractLayouter.Layoutable result = (AbstractLayouter.Layoutable)ForestLayouter.this.toLayoutableMap.get(in);
                    if (result == null) {
                        throw new IllegalArgumentException("Suggested root " + in + " is not a known graph cell");
                    }
                    return result;
                }
            };
            rootIter = new NestedIterator<AbstractLayouter.Layoutable>(suggestedRootIter, rootIter);
        }
        this.roots.clear();
        LinkedHashSet<AbstractLayouter.Layoutable> leaves = new LinkedHashSet<AbstractLayouter.Layoutable>(this.branchMap.keySet());
        while (rootIter.hasNext()) {
            AbstractLayouter.Layoutable root = rootIter.next();
            if (!leaves.contains(root)) continue;
            this.roots.add(root);
            leaves.remove(root);
            LinkedHashSet<AbstractLayouter.Layoutable> reachableCells = new LinkedHashSet<AbstractLayouter.Layoutable>();
            reachableCells.add(root);
            while (!reachableCells.isEmpty()) {
                Iterator reachableCellIter = reachableCells.iterator();
                Object nextReachableCell = reachableCellIter.next();
                reachableCellIter.remove();
                Set<AbstractLayouter.Layoutable> branches = this.branchMap.get(nextReachableCell);
                branches.retainAll(leaves);
                reachableCells.addAll(branches);
                leaves.removeAll(branches);
            }
        }
    }

    private Object[] layout(Collection<AbstractLayouter.Layoutable> branches, int height) {
        int width = 0;
        int levelCount = 0;
        int[] leftIndent = new int[levelCount];
        int[] rightIndent = new int[levelCount];
        LinkedList<AbstractLayouter.Layoutable> previousBranches = new LinkedList<AbstractLayouter.Layoutable>();
        for (AbstractLayouter.Layoutable branch : branches) {
            Object[] rightLayout = this.layout(branch, height);
            int leftWidth = width;
            int leftLevelCount = levelCount;
            int[] leftLeftIndent = leftIndent;
            int[] leftRightIndent = rightIndent;
            int rightWidth = (Integer)rightLayout[0];
            int[] rightLeftIndent = (int[])rightLayout[1];
            int[] rightRightIndent = (int[])rightLayout[2];
            int rightLevelCount = rightLeftIndent.length;
            levelCount = Math.max(leftLevelCount, rightLevelCount);
            leftIndent = new int[levelCount];
            rightIndent = new int[levelCount];
            int fit = leftLevelCount == 0 ? 0 : leftRightIndent[0] + rightLeftIndent[0] - 60;
            int level = 0;
            while (level < levelCount) {
                if (level < leftLevelCount && level < rightLevelCount) {
                    fit = Math.min(fit, leftRightIndent[level] + rightLeftIndent[level] - 40);
                }
                ++level;
            }
            level = 0;
            while (level < levelCount) {
                leftIndent[level] = level < leftLevelCount ? leftLeftIndent[level] : rightLeftIndent[level] + leftWidth - fit;
                rightIndent[level] = level < rightLevelCount ? rightRightIndent[level] : leftRightIndent[level] + rightWidth - fit;
                ++level;
            }
            width = leftWidth + rightWidth - fit;
            if (fit < leftWidth) {
                this.shift(branch, leftWidth - fit);
            } else if (fit > leftWidth) {
                this.shift(previousBranches, fit - leftWidth);
                this.shift(leftIndent, fit - leftWidth);
                width = rightWidth;
            }
            if (fit > rightWidth) {
                this.shift(rightIndent, fit - rightWidth);
                width = leftWidth;
            }
            previousBranches.add(branch);
        }
        return new Object[]{width, leftIndent, rightIndent};
    }

    private Object[] layout(AbstractLayouter.Layoutable layoutable, int height) {
        Set<AbstractLayouter.Layoutable> branches = this.branchMap.get(layoutable);
        Object[] branchLayout = this.layout(branches, height + 40 + (int)layoutable.getHeight());
        int branchWidth = (Integer)branchLayout[0];
        int[] branchLeftIndent = (int[])branchLayout[1];
        int[] branchRightIndent = (int[])branchLayout[2];
        int branchLevelCount = branchLeftIndent.length;
        int cellWidth = (int)layoutable.getWidth();
        int branchLevel0LeftIndent = branchLevelCount == 0 ? 0 : branchLeftIndent[0];
        int branchLevel0RightIndent = branchLevelCount == 0 ? 0 : branchRightIndent[0];
        int branchLevel0Width = branchWidth - branchLevel0LeftIndent - branchLevel0RightIndent;
        int rootLeftIndent = branchLevel0LeftIndent + (branchLevel0Width - cellWidth) / 2;
        int rootRightIndent = branchWidth - rootLeftIndent - cellWidth;
        int levelCount = branchLevelCount + 1;
        int[] leftIndent = new int[levelCount];
        int[] rightIndent = new int[levelCount];
        leftIndent[0] = rootLeftIndent;
        rightIndent[0] = rootRightIndent;
        System.arraycopy(branchLeftIndent, 0, leftIndent, 1, branchLevelCount);
        System.arraycopy(branchRightIndent, 0, rightIndent, 1, branchLevelCount);
        if (rootLeftIndent < 0) {
            this.shift(branches, -rootLeftIndent);
            this.shift(leftIndent, -rootLeftIndent);
        }
        if (rootRightIndent < 0) {
            this.shift(rightIndent, -rootRightIndent);
        }
        layoutable.setLocation(leftIndent[0], height);
        int width = leftIndent[0] + cellWidth + rightIndent[0];
        return new Object[]{width, leftIndent, rightIndent};
    }

    private void shift(Collection<AbstractLayouter.Layoutable> branches, int shift) {
        for (AbstractLayouter.Layoutable branch : branches) {
            this.shift(branch, shift);
        }
    }

    private void shift(AbstractLayouter.Layoutable layoutable, int shift) {
        layoutable.setLocation(layoutable.getX() + (double)shift, layoutable.getY());
        this.shift((Collection<AbstractLayouter.Layoutable>)this.branchMap.get(layoutable), shift);
    }

    private void shift(int[] indents, int shift) {
        int i = 0;
        while (i < indents.length) {
            int n = i++;
            indents[n] = indents[n] + shift;
        }
    }
}

