/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.layout;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.JGraphLayout;
import groove.gui.layout.LayoutKind;
import groove.gui.layout.Layouter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JPanel;
import org.jgraph.JGraph;

public class LayouterItem
implements Layouter {
    private final LayoutKind kind;
    private final groove.gui.jgraph.JGraph<?> jGraph;
    private JGraphFacade facade;
    private final JPanel panel;

    public LayouterItem(LayoutKind kind) {
        this(kind, null, null);
    }

    private LayouterItem(LayoutKind kind, final groove.gui.jgraph.JGraph<?> jGraph, JGraphFacade facade) {
        this.kind = kind;
        this.jGraph = jGraph;
        this.facade = facade;
        JPanel jPanel = this.panel = jGraph == null ? null : LayoutKind.createLayoutPanel(this);
        if (jGraph != null) {
            jGraph.addPropertyChangeListener("model", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    LayouterItem.this.facade = new JGraphFacade((JGraph)jGraph);
                }
            });
        }
    }

    @Override
    public Layouter newInstance(groove.gui.jgraph.JGraph<?> jGraph) {
        return new LayouterItem(this.kind, jGraph, new JGraphFacade(jGraph));
    }

    @Override
    public String getName() {
        return this.kind.getDisplayString();
    }

    @Override
    public void start() {
        this.prepareLayouting();
        this.run();
        this.finishLayouting();
    }

    public JGraphLayout getLayout() {
        return this.kind.getLayout();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void prepareLayouting() {
        this.jGraph.setLayouting(true);
        this.jGraph.clearAllEdgePoints();
    }

    private void run() {
        this.getLayout().run(this.facade);
        Map nested = this.facade.createNestedMap(true, true);
        this.jGraph.getGraphLayoutCache().edit(nested);
    }

    private void finishLayouting() {
        this.jGraph.setLayouting(false);
    }
}

