/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.look;

import groove.grammar.aspect.AspectKind;
import groove.gui.jgraph.AspectJEdge;
import groove.gui.jgraph.JCell;
import groove.gui.look.EdgeEnd;
import groove.gui.look.Look;
import groove.gui.look.VisualMap;
import groove.gui.look.VisualValue;
import java.util.Set;

public class EdgeEndShapeValue
implements VisualValue<EdgeEnd> {
    private final boolean source;

    public EdgeEndShapeValue(boolean source) {
        this.source = source;
    }

    @Override
    public EdgeEnd get(JCell<?> cell) {
        VisualMap looksMap = Look.getVisualsFor(cell.getLooks());
        EdgeEnd result = this.source ? looksMap.getEdgeSourceShape() : looksMap.getEdgeTargetShape();
        Set<Look> looks = cell.getLooks();
        if (looks.contains((Object)Look.NO_ARROW)) {
            result = EdgeEnd.NONE;
        } else if (cell.getJGraph().isShowArrowsOnLabels()) {
            boolean show = false;
            if (cell instanceof AspectJEdge) {
                AspectJEdge jEdge = (AspectJEdge)cell;
                show |= jEdge.getAspect() == AspectKind.SUBTYPE;
                show |= this.source && jEdge.getEdge() != null && jEdge.getEdge().isComposite();
                show |= jEdge.isNodeEdgeOut();
            }
            if (!show) {
                result = EdgeEnd.NONE;
            }
        } else if (looks.contains((Object)Look.BIDIRECTIONAL)) {
            result = looksMap.getEdgeTargetShape();
        }
        return result;
    }
}

