/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.look;

import groove.algebra.SignatureKind;
import groove.control.CtrlState;
import groove.control.CtrlVar;
import groove.grammar.aspect.Aspect;
import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectKind;
import groove.grammar.aspect.AspectLabel;
import groove.grammar.aspect.AspectNode;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.model.FormatException;
import groove.grammar.model.GraphBasedModel;
import groove.grammar.type.LabelPattern;
import groove.graph.Edge;
import groove.graph.EdgeRole;
import groove.graph.GraphRole;
import groove.graph.Label;
import groove.gui.jgraph.AspectJEdge;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.AspectJModel;
import groove.gui.jgraph.AspectJVertex;
import groove.gui.jgraph.CtrlJVertex;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JVertex;
import groove.gui.jgraph.LTSJEdge;
import groove.gui.jgraph.LTSJGraph;
import groove.gui.jgraph.LTSJVertex;
import groove.gui.look.Line;
import groove.gui.look.Look;
import groove.gui.look.MultiLabel;
import groove.gui.look.VisualValue;
import groove.gui.tree.LabelTree;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.util.Colors;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class LabelValue
implements VisualValue<MultiLabel> {
    private final JGraph<?> jGraph;
    private final GraphRole role;
    private static final Map<SignatureKind, Line> sigLineMap;
    private static final Map<AspectKind, Line> rolePrefixMap;
    private static final String IMPORT_TEXT;
    private static final Line IMPORT_LINE;
    private static final Line EXISTS;
    private static final Line EXISTS_OPT;
    private static final Line FORALL;
    private static final Line FORALL_POS;
    private static final String ASSIGN_TEXT = " = ";
    private static final String TYPE_TEXT = ": ";
    static final char LEVEL_NAME_SEPARATOR = '@';

    static {
        Enum kind;
        EnumMap<Enum, Line> map = new EnumMap<SignatureKind, Line>(SignatureKind.class);
        Enum[] enumArray = SignatureKind.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            kind = enumArray[n2];
            map.put((SignatureKind)kind, Line.atom(((SignatureKind)kind).getName()).style(Line.Style.BOLD));
            ++n2;
        }
        sigLineMap = map;
        map = new EnumMap(AspectKind.class);
        enumArray = AspectKind.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Line prefix;
            kind = enumArray[n2];
            switch (LabelValue.$SWITCH_TABLE$groove$grammar$aspect$AspectKind()[kind.ordinal()]) {
                case 6: {
                    prefix = Line.atom("!+ ");
                    break;
                }
                case 5: {
                    prefix = Line.atom("+ ");
                    break;
                }
                case 7: {
                    prefix = Line.atom("! ");
                    break;
                }
                case 4: {
                    prefix = Line.atom("- ");
                    break;
                }
                case 2: {
                    prefix = Line.atom("// ");
                    break;
                }
                default: {
                    prefix = Line.empty();
                }
            }
            map.put((SignatureKind)kind, prefix);
            ++n2;
        }
        rolePrefixMap = map;
        IMPORT_TEXT = String.format("%simport%s", Character.valueOf('\u00ab'), Character.valueOf('\u00bb'));
        IMPORT_LINE = Line.atom(IMPORT_TEXT).style(Line.Style.ITALIC);
        EXISTS = Line.atom("\u2203");
        EXISTS_OPT = EXISTS.append(Line.atom("?").style(Line.Style.SUPER));
        FORALL = Line.atom("\u2200");
        FORALL_POS = FORALL.append(Line.atom(">0").style(Line.Style.SUPER));
    }

    public LabelValue(JGraph<?> jGraph) {
        this.jGraph = jGraph;
        this.role = jGraph.getGraphRole();
    }

    @Override
    public MultiLabel get(JCell<?> cell) {
        MultiLabel result = null;
        if (cell instanceof JVertex) {
            result = this.getJVertexLabel((JVertex)cell);
        } else if (cell instanceof JEdge) {
            result = this.getJEdgeLabel((JEdge)cell);
        }
        return result;
    }

    protected MultiLabel getJVertexLabel(JVertex<?> jVertex) {
        MultiLabel result;
        switch (this.role) {
            case HOST: {
                result = this.getHostNodeLabel((AspectJVertex)jVertex);
                break;
            }
            case RULE: {
                result = this.getRuleNodeLabel((AspectJVertex)jVertex);
                break;
            }
            case TYPE: {
                result = this.getTypeNodeLabel((AspectJVertex)jVertex);
                break;
            }
            case LTS: {
                result = this.getLTSJVertexLabel((LTSJVertex)jVertex);
                break;
            }
            case CTRL: {
                result = this.getCtrlJVertexLabel((CtrlJVertex)jVertex);
                break;
            }
            default: {
                result = this.getBasicVertexLabel(jVertex);
            }
        }
        return result;
    }

    private MultiLabel getBasicVertexLabel(JVertex<?> jVertex) {
        MultiLabel result = new MultiLabel();
        if (jVertex.getJGraph().isShowNodeIdentities()) {
            result.add(Line.atom(jVertex.getNode().toString()).style(Line.Style.ITALIC), MultiLabel.Direct.NONE);
        }
        for (Edge edge : jVertex.getEdges()) {
            if (this.isFiltered(jVertex, edge)) continue;
            result.add(Line.atom(edge.label().text()), MultiLabel.Direct.NONE);
        }
        return result;
    }

    private MultiLabel getHostNodeLabel(AspectJVertex jVertex) {
        AspectNode node = jVertex.getNode();
        node.testFixed(true);
        MultiLabel result = new MultiLabel();
        if (!jVertex.getLooks().contains((Object)Look.NODIFIED)) {
            if (((AspectJGraph)((Object)jVertex.getJGraph())).isShowNodeIdentities() && !node.hasId()) {
                result.add(this.getNodeIdLine(node));
            }
            if (((AspectJGraph)((Object)jVertex.getJGraph())).isShowAspects()) {
                result.add(jVertex.getUserObject().toLines(MultiLabel.Direct.NONE));
            } else {
                result.add(this.getDataLines(node));
                Line id = node.hasId() ? Line.atom(node.getId().getContentString()).style(Line.Style.ITALIC) : null;
                for (AspectEdge edge : jVertex.getEdges()) {
                    if (this.isFiltered(jVertex, edge)) continue;
                    Line line = this.getHostLine(edge);
                    if (id != null && edge.getDisplayLabel().getRole() == EdgeRole.NODE_TYPE) {
                        line = id.append(" : ").append(line);
                        id = null;
                    }
                    result.add(line, MultiLabel.Direct.NONE);
                }
                if (id != null) {
                    result.add(id, MultiLabel.Direct.NONE);
                }
            }
            for (AspectEdge edge : jVertex.getExtraSelfEdges()) {
                if (this.isFiltered(jVertex, edge)) continue;
                result.add(this.getHostLine(edge), MultiLabel.Direct.NONE);
            }
        }
        return result;
    }

    private Line getHostLine(AspectEdge edge) {
        edge.testFixed(true);
        Line result = this.getAspectEdgeLine(edge);
        if (edge.target() != edge.source()) {
            String suffix = ASSIGN_TEXT + ((AspectNode)edge.target()).getAttrAspect().getContentString();
            result = result.append(suffix);
        } else {
            result = this.addRoleIndicator(result, edge);
        }
        return result;
    }

    private MultiLabel getTypeNodeLabel(AspectJVertex jVertex) {
        AspectNode node = jVertex.getNode();
        node.testFixed(true);
        MultiLabel result = new MultiLabel();
        if (((AspectJGraph)((Object)jVertex.getJGraph())).isShowAspects()) {
            result.add(jVertex.getUserObject().toLines(MultiLabel.Direct.NONE));
            for (AspectEdge edge : jVertex.getExtraSelfEdges()) {
                if (this.isFiltered(jVertex, edge)) continue;
                result.add(this.getTypeLine(edge), MultiLabel.Direct.NONE);
            }
        } else {
            if (node.hasImport()) {
                result.add(IMPORT_LINE, MultiLabel.Direct.NONE);
            }
            result.add(this.getDataLines(node));
            for (AspectEdge edge : jVertex.getEdges()) {
                if (this.isFiltered(jVertex, edge)) continue;
                result.add(this.getTypeLine(edge), MultiLabel.Direct.NONE);
            }
            for (AspectEdge edge : jVertex.getExtraSelfEdges()) {
                if (this.isFiltered(jVertex, edge)) continue;
                result.add(this.getTypeLine(edge), MultiLabel.Direct.NONE);
            }
            if (node.isEdge()) {
                StringBuilder line = new StringBuilder();
                LabelPattern pattern = node.getEdgePattern();
                line.append(">> ");
                line.append(pattern.getLabel(pattern.getArgNames().toArray()));
                result.add(Line.atom(line.toString()), MultiLabel.Direct.NONE);
            }
        }
        return result;
    }

    private Line getTypeLine(AspectEdge edge) {
        edge.testFixed(true);
        Line result = this.getAspectEdgeLine(edge);
        if (edge.getKind() == AspectKind.ABSTRACT && ((AspectLabel)edge.label()).getRole() == EdgeRole.NODE_TYPE) {
            result = result.style(Line.Style.ITALIC);
        }
        if (edge.target() != edge.source()) {
            result = result.append(TYPE_TEXT);
            result = result.append(LabelValue.getSignatureLine(((AspectNode)edge.target()).getAttrKind().getSignature()));
        } else if (edge.getAttrKind().hasSignature()) {
            result = result.append(TYPE_TEXT);
            result = result.append(LabelValue.getSignatureLine(edge.getAttrKind().getSignature()));
        }
        result = this.addRoleIndicator(result, edge);
        return result;
    }

    private MultiLabel getRuleNodeLabel(AspectJVertex jVertex) {
        AspectNode node = jVertex.getNode();
        node.testFixed(true);
        MultiLabel result = new MultiLabel();
        if (((AspectJGraph)((Object)jVertex.getJGraph())).isShowNodeIdentities() && !node.hasId()) {
            result.add(this.getNodeIdLine(node));
        }
        if (((AspectJGraph)((Object)jVertex.getJGraph())).isShowAspects()) {
            result.add(jVertex.getUserObject().toLines(MultiLabel.Direct.NONE));
            for (AspectEdge edge : jVertex.getExtraSelfEdges()) {
                if (this.isFiltered(jVertex, edge)) continue;
                result.add(this.getRuleLine(edge), MultiLabel.Direct.NONE);
            }
            if (node.hasColor()) {
                result.add(Line.atom(node.getColor().toString()), MultiLabel.Direct.NONE);
            }
        } else {
            Line idLine;
            Line line = idLine = node.hasId() ? Line.atom(node.getId().getContentString()).style(Line.Style.ITALIC) : null;
            if (node.getKind().isQuantifier()) {
                result.add(this.getQuantifierLines(node, idLine));
                idLine = null;
            }
            result.add(this.getDataLines(node));
            for (AspectEdge edge : jVertex.getEdges()) {
                if (this.isFiltered(jVertex, edge)) continue;
                Line line2 = this.getRuleLine(edge);
                if (idLine != null && edge.getDisplayLabel().getRole() == EdgeRole.NODE_TYPE) {
                    line2 = idLine.append(" : ").append(line2);
                    idLine = null;
                }
                result.add(line2, MultiLabel.Direct.NONE);
            }
            if (idLine != null) {
                result.add(idLine, MultiLabel.Direct.NONE);
            }
            for (AspectEdge edge : jVertex.getExtraSelfEdges()) {
                if (this.isFiltered(jVertex, edge)) continue;
                result.add(this.getRuleLine(edge), MultiLabel.Direct.NONE);
            }
            if (node.hasColor()) {
                StringBuilder text = new StringBuilder("& ");
                text.append(AspectKind.COLOR.getName());
                Line colorLine = Line.atom(text.toString()).color(Colors.findColor(node.getColor().getContentString()));
                result.add(colorLine, MultiLabel.Direct.NONE);
            }
        }
        return result;
    }

    private Line getRuleLine(AspectEdge edge) {
        edge.testFixed(true);
        Line result = this.getAspectEdgeLine(edge);
        if (edge.target() != edge.source()) {
            String suffix = ASSIGN_TEXT + ((AspectNode)edge.target()).getAttrAspect().getContentString();
            result = result.append(suffix);
        }
        result = this.addRoleIndicator(result, edge);
        return result;
    }

    private MultiLabel getLTSJVertexLabel(LTSJVertex jVertex) {
        MultiLabel result = new MultiLabel();
        if (((LTSJGraph)jVertex.getJGraph()).isShowStateIdentities()) {
            GraphState state = jVertex.getNode();
            StringBuilder id = new StringBuilder(state.toString());
            CtrlState ctrlState = state.getCtrlState();
            if (!ctrlState.getAut().isDefault() || !ctrlState.isStart()) {
                id.append("|" + ctrlState.toString());
            }
            result.add(Line.atom(id.toString()).style(Line.Style.ITALIC), MultiLabel.Direct.NONE);
        }
        boolean isShowAnchors = ((LTSJGraph)jVertex.getJGraph()).isShowAnchors();
        for (Edge edge : jVertex.getEdges()) {
            if (this.isFiltered(jVertex, edge)) continue;
            String text = ((GraphTransition)edge).text(isShowAnchors);
            result.add(Line.atom(text), MultiLabel.Direct.NONE);
        }
        return result;
    }

    private MultiLabel getCtrlJVertexLabel(CtrlJVertex jVertex) {
        MultiLabel result = this.getBasicVertexLabel(jVertex);
        CtrlState state = jVertex.getNode();
        List<CtrlVar> boundVars = state.getBoundVars();
        if (boundVars.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(boundVars.toString());
            result.add(Line.atom(sb.toString()), MultiLabel.Direct.NONE);
        }
        if (jVertex.isTransient()) {
            StringBuilder action = new StringBuilder();
            action.append('<');
            action.append(state.getRecipe());
            action.append('>');
            result.add(Line.atom(action.toString()), MultiLabel.Direct.NONE);
        }
        return result;
    }

    protected MultiLabel getJEdgeLabel(JEdge<?> jEdge) {
        MultiLabel result;
        switch (this.role) {
            case HOST: 
            case RULE: 
            case TYPE: {
                result = this.getAspectJEdgeLabel((AspectJEdge)jEdge);
                break;
            }
            case LTS: {
                result = this.getLTSJEdgeLabel((LTSJEdge)jEdge);
                break;
            }
            default: {
                result = this.getBasicJEdgeLabel(jEdge);
            }
        }
        return result;
    }

    private MultiLabel getBasicJEdgeLabel(JEdge<?> jEdge) {
        MultiLabel result = new MultiLabel();
        for (Edge edge : jEdge.getEdges()) {
            if (this.isFiltered(jEdge, edge)) continue;
            result.add(Line.atom(edge.label().text()), jEdge.getDirect(edge));
        }
        return result;
    }

    private MultiLabel getAspectJEdgeLabel(AspectJEdge jEdge) {
        MultiLabel result = null;
        if (jEdge.isNodeEdgeOut()) {
            result = new MultiLabel();
        } else if (jEdge.isNodeEdgeIn()) {
            result = new MultiLabel();
            LabelPattern pattern = ((AspectJVertex)jEdge.getTargetVertex()).getEdgeLabelPattern();
            GraphBasedModel<?> resourceModel = ((AspectJModel)((Object)jEdge.getJModel())).getResourceModel();
            try {
                HostNode target = (HostNode)resourceModel.getMap().getNode(jEdge.getTargetNode());
                String label = pattern.getLabel((HostGraph)resourceModel.toResource(), target);
                result.add(Line.atom(label), jEdge.getDirect(null));
            }
            catch (FormatException formatException) {}
        } else if (jEdge.isSourceLabel()) {
            result = new MultiLabel();
        } else {
            result = new MultiLabel();
            for (AspectEdge edge : jEdge.getEdges()) {
                if (this.isFiltered(jEdge, edge)) continue;
                result.add(this.getAspectEdgeLine(edge), jEdge.getDirect(edge));
            }
        }
        return result;
    }

    private MultiLabel getLTSJEdgeLabel(LTSJEdge jEdge) {
        MultiLabel result = new MultiLabel();
        boolean isShowAnchors = ((LTSJGraph)jEdge.getJGraph()).isShowAnchors();
        for (Edge edge : jEdge.getEdges()) {
            if (this.isFiltered(jEdge, edge)) continue;
            GraphTransition trans = (GraphTransition)edge;
            result.add(Line.atom(trans.text(isShowAnchors)), jEdge.getDirect(edge));
        }
        return result;
    }

    private Line getAspectEdgeLine(AspectEdge edge) {
        Object label = ((AspectJGraph)this.getJGraph()).isShowAspects() ? edge.label() : edge.getDisplayLabel();
        Line result = Line.atom(label.text());
        switch (label.getRole()) {
            case FLAG: {
                result = result.style(Line.Style.ITALIC);
                break;
            }
            case NODE_TYPE: {
                result = result.style(Line.Style.BOLD);
            }
        }
        result = this.addLevelName(result, edge);
        return result;
    }

    private Line addLevelName(Line line, AspectEdge edge) {
        String name;
        Line result = line;
        if (edge.getKind().isRole() && (name = edge.getLevelName()) != null && name.length() != 0 && !name.equals(((AspectNode)edge.source()).getLevelName()) && !name.equals(((AspectNode)edge.source()).getLevelName())) {
            result = result.append(String.valueOf('@') + name);
        }
        return result;
    }

    private Line addRoleIndicator(Line text, AspectEdge edge) {
        Line result = text;
        Aspect aspect = edge.getAspect();
        if (aspect != null && !aspect.equals(((AspectNode)edge.source()).getAspect())) {
            AspectKind kind = aspect.getKind();
            result = LabelValue.getRolePrefix(kind).append(result);
            switch (kind) {
                case ERASER: {
                    result = result.color(Line.ColorType.ERASER);
                    break;
                }
                case ADDER: {
                    result = result.color(Line.ColorType.CREATOR);
                    break;
                }
                case LET: {
                    if (edge.getGraphRole() != GraphRole.RULE) break;
                    result = result.color(Line.ColorType.CREATOR);
                    break;
                }
                case CREATOR: {
                    result = result.color(Line.ColorType.CREATOR);
                    break;
                }
                case EMBARGO: {
                    result = result.color(Line.ColorType.EMBARGO);
                    break;
                }
                case REMARK: {
                    result = result.color(Line.ColorType.REMARK);
                }
            }
        }
        return result;
    }

    private MultiLabel getNodeIdLine(AspectNode node) {
        String id;
        MultiLabel result = new MultiLabel();
        if (node.getKind().isMeta()) {
            id = null;
        } else if (node.hasAttrAspect()) {
            AspectKind attrKind = node.getAttrKind();
            if (attrKind.hasSignature()) {
                Object content = node.getAttrAspect().getContent();
                id = content == null ? "x" + node.getNumber() : content.toString();
            } else {
                assert (attrKind == AspectKind.PRODUCT);
                id = "p" + node.getNumber();
            }
        } else {
            id = node.toString();
        }
        if (id != null) {
            result.add(Line.atom(id).style(Line.Style.ITALIC), MultiLabel.Direct.NONE);
        }
        return result;
    }

    private MultiLabel getQuantifierLines(AspectNode node, Line id) {
        Line line = Line.empty();
        if (id != null) {
            line = line.append(id).append(" : ");
        }
        switch (node.getKind()) {
            case FORALL: {
                line = line.append(FORALL);
                break;
            }
            case FORALL_POS: {
                line = line.append(FORALL_POS);
                break;
            }
            case EXISTS: {
                line = line.append(EXISTS);
                break;
            }
            case EXISTS_OPT: {
                line = line.append(EXISTS_OPT);
            }
        }
        return MultiLabel.singleton(line, MultiLabel.Direct.NONE);
    }

    private MultiLabel getDataLines(AspectNode node) {
        MultiLabel result = new MultiLabel();
        Aspect attrAspect = node.getAttrAspect();
        if (attrAspect.getKind().hasSignature()) {
            Line dataLine = null;
            if (!attrAspect.hasContent()) {
                dataLine = LabelValue.getSignatureLine(attrAspect.getKind().getSignature());
            } else if (!this.jGraph.isShowNodeIdentities()) {
                dataLine = Line.atom(attrAspect.getContentString());
            }
            if (dataLine != null) {
                result.add(dataLine, MultiLabel.Direct.NONE);
            }
        }
        return result;
    }

    private boolean isFiltered(JCell<?> jCell, Edge edge) {
        boolean result = false;
        LabelTree<?> labelTree = jCell.getJGraph().getLabelTree();
        if (edge != null && labelTree != null) {
            Label key = jCell.getKey(edge);
            result = key != null && labelTree.isFiltered(key);
        }
        return result;
    }

    public JGraph<?> getJGraph() {
        return this.jGraph;
    }

    private static Line getSignatureLine(SignatureKind kind) {
        return sigLineMap.get((Object)kind);
    }

    private static Line getRolePrefix(AspectKind kind) {
        return rolePrefixMap.get((Object)kind);
    }
}

