/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.look;

import groove.grammar.aspect.Aspect;
import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectKind;
import groove.grammar.aspect.AspectNode;
import groove.graph.Graph;
import groove.graph.GraphRole;
import groove.gui.jgraph.AspectJCell;
import groove.gui.jgraph.AspectJEdge;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.AspectJVertex;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JVertex;
import groove.gui.jgraph.LTSJCell;
import groove.gui.jgraph.LTSJEdge;
import groove.gui.jgraph.LTSJGraph;
import groove.gui.jgraph.LTSJModel;
import groove.gui.jgraph.LTSJVertex;
import groove.gui.look.VisualValue;
import groove.gui.tree.LabelTree;
import groove.gui.tree.RuleLevelTree;
import groove.lts.GraphState;
import groove.lts.GraphTransition;

public class VisibleValue
implements VisualValue<Boolean> {
    @Override
    public Boolean get(JCell<?> cell) {
        boolean result = true;
        boolean isVertex = cell instanceof JVertex;
        if (cell instanceof AspectJCell) {
            result = isVertex ? this.getAspectVertexValue((AspectJVertex)cell) : this.getAspectEdgeValue((AspectJEdge)cell);
        } else if (cell instanceof LTSJCell) {
            result = isVertex ? this.getLTSVertexValue((LTSJVertex)cell) : this.getLTSEdgeValue((LTSJEdge)cell);
        } else if (cell instanceof JVertex) {
            result = isVertex ? this.getBasicVertexValue((JVertex)cell) : this.getBasicEdgeValue((JEdge)cell);
        }
        return result;
    }

    private <G extends Graph> boolean getBasicVertexValue(JVertex<G> jVertex) {
        JGraph jGraph = jVertex.getJGraph();
        LabelTree<G> labelTree = jGraph.getLabelTree();
        if (labelTree == null || !labelTree.isFiltered(jVertex)) {
            return true;
        }
        if (!jGraph.isShowUnfilteredEdges()) {
            return false;
        }
        return this.hasVisibleIncidentEdge(jVertex);
    }

    private <G extends Graph> boolean getBasicEdgeValue(JEdge<G> jEdge) {
        boolean result = true;
        JVertex<G> source = jEdge.getSourceVertex();
        JVertex<G> target = jEdge.getTargetVertex();
        if (source == null || !source.getVisuals().isVisible()) {
            return false;
        }
        if (target == null || !target.getVisuals().isVisible()) {
            return false;
        }
        LabelTree<G> labelTree = jEdge.getJGraph().getLabelTree();
        if (labelTree != null) {
            result = !labelTree.isFiltered(jEdge);
        }
        return result;
    }

    private boolean getAspectVertexValue(AspectJVertex jVertex) {
        AspectNode node = jVertex.getNode();
        AspectKind aspect = jVertex.getAspect();
        if (aspect == AspectKind.REMARK) {
            return true;
        }
        RuleLevelTree levelTree = ((AspectJGraph)((Object)jVertex.getJGraph())).getLevelTree();
        if (levelTree != null && !levelTree.isVisible(jVertex)) {
            return false;
        }
        if (node.hasParam() || aspect.isQuantifier() || jVertex.hasErrors()) {
            return true;
        }
        if (!this.getBasicVertexValue(jVertex)) {
            return false;
        }
        Aspect attr = node.getAttrAspect();
        if (attr == null || !attr.getKind().hasSignature()) {
            return true;
        }
        if (((AspectJGraph)((Object)jVertex.getJGraph())).isShowValueNodes()) {
            return true;
        }
        if (node.getGraphRole() == GraphRole.TYPE) {
            return false;
        }
        if (!attr.hasContent()) {
            return true;
        }
        for (Object jEdge : jVertex.getPort().getEdges()) {
            AspectEdge edge = ((AspectJEdge)jEdge).getEdge();
            if (edge.getRuleLabel() == null || edge.getRuleLabel().isAtom()) continue;
            return true;
        }
        return false;
    }

    private boolean getAspectEdgeValue(AspectJEdge jEdge) {
        RuleLevelTree levelTree = ((AspectJGraph)((Object)jEdge.getJGraph())).getLevelTree();
        if (levelTree != null && !levelTree.isVisible(jEdge)) {
            return false;
        }
        return this.getBasicEdgeValue(jEdge);
    }

    private boolean getLTSVertexValue(LTSJVertex jVertex) {
        GraphState state = jVertex.getNode();
        if (!jVertex.hasVisibleFlag()) {
            return false;
        }
        if (!((LTSJGraph)jVertex.getJGraph()).isShowPartialTransitions() && jVertex.isTransient() && state.isDone()) {
            return false;
        }
        if (jVertex.getNumber() > ((LTSJModel)jVertex.getJModel()).getStateBound()) {
            return false;
        }
        if (jVertex.isStart() || jVertex.isFinal() || !jVertex.isClosed()) {
            return true;
        }
        return this.hasVisibleIncidentEdge(jVertex);
    }

    private boolean getLTSEdgeValue(LTSJEdge jEdge) {
        GraphTransition trans = jEdge.getEdge();
        if (!jEdge.hasVisibleFlag()) {
            return false;
        }
        if (!((LTSJGraph)jEdge.getJGraph()).isShowPartialTransitions() && trans.isPartial() && trans.source().isDone()) {
            return false;
        }
        return this.getBasicEdgeValue(jEdge);
    }

    private <G extends Graph> boolean hasVisibleIncidentEdge(JVertex<G> jVertex) {
        boolean result = false;
        LabelTree<G> labelTree = jVertex.getJGraph().getLabelTree();
        for (JEdge<G> jEdge : jVertex.getContext()) {
            if (labelTree != null && labelTree.isFiltered(jEdge)) continue;
            result = true;
            break;
        }
        return result;
    }
}

