/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.look;

import groove.gui.look.EdgeEnd;
import groove.gui.look.LineStyle;
import groove.gui.look.Look;
import groove.gui.look.MultiLabel;
import groove.gui.look.NodeShape;
import groove.gui.look.VisualAttributeMap;
import groove.gui.look.VisualKey;
import groove.util.DefaultFixable;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgraph.graph.AttributeMap;

public class VisualMap
extends DefaultFixable {
    private final Map<VisualKey, Object> map = new EnumMap<VisualKey, Object>(VisualKey.class);
    private final VisualAttributeMap attrMap = new VisualAttributeMap(this);
    private static final int BACKGROUND_WHITEWASH = 90;

    public void put(VisualKey key, Object value) {
        assert (key.getNature() != VisualKey.Nature.DERIVED);
        this.put(key, value, true);
    }

    void put(VisualKey key, Object value, boolean refresh) {
        boolean change;
        this.testFixed(false);
        Object oldValue = this.map.get((Object)key);
        if (oldValue == null) {
            change = value != null;
        } else {
            boolean bl = change = !oldValue.equals(value);
        }
        if (change) {
            key.test(value);
            this.map.put(key, value);
            if (refresh) {
                this.attrMap.setStale(key);
            }
        }
    }

    public void putAll(VisualMap other) {
        this.testFixed(false);
        this.map.putAll(other.map);
        this.attrMap.setStale(other.map.keySet());
    }

    public void putNonDerived(VisualMap other) {
        this.testFixed(false);
        VisualKey[] visualKeyArray = VisualKey.values();
        int n = visualKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            VisualKey key = visualKeyArray[n2];
            if (key.getNature() != VisualKey.Nature.DERIVED) {
                Object newValue = other.map.get((Object)key);
                if (newValue == null) {
                    this.map.remove((Object)key);
                } else {
                    this.map.put(key, newValue);
                }
            }
            this.attrMap.setStale(key);
            ++n2;
        }
    }

    public void setLooks(Set<Look> looks) {
        this.testFixed(false);
        VisualMap newValues = Look.getVisualsFor(looks);
        EnumSet<VisualKey> staleKeys = EnumSet.noneOf(VisualKey.class);
        VisualKey[] visualKeyArray = VisualKey.deriveds();
        int n = visualKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            VisualKey key = visualKeyArray[n2];
            if (key.getNature() == VisualKey.Nature.DERIVED) {
                boolean refresh;
                Object oldValue;
                Object newValue = newValues.map.get((Object)key);
                if (newValue == null) {
                    oldValue = this.map.remove((Object)key);
                    refresh = oldValue != null;
                } else {
                    oldValue = this.map.put(key, newValue);
                    boolean bl = refresh = !newValue.equals(oldValue);
                }
                if (refresh) {
                    staleKeys.add(key);
                }
            }
            ++n2;
        }
        this.attrMap.setStale(staleKeys);
    }

    public Object get(VisualKey key) {
        Object result = this.map.containsKey((Object)key) ? this.map.get((Object)key) : key.getDefaultValue();
        return result;
    }

    public void clear() {
        this.testFixed(false);
        this.attrMap.setStale(this.map.keySet());
        this.map.clear();
    }

    public Set<VisualKey> keySet() {
        return this.map.keySet();
    }

    public boolean containsKey(VisualKey key) {
        return this.map.containsKey((Object)key);
    }

    public void remove(VisualKey key) {
        this.remove(key, true);
    }

    void remove(VisualKey key, boolean refresh) {
        this.testFixed(false);
        this.map.remove((Object)key);
        if (refresh) {
            this.attrMap.setStale(key);
        }
    }

    public String getAdornment() {
        return (String)this.get(VisualKey.ADORNMENT);
    }

    public void setAdornment(String newValue) {
        this.put(VisualKey.ADORNMENT, newValue);
    }

    public NodeShape getNodeShape() {
        return (NodeShape)((Object)this.get(VisualKey.NODE_SHAPE));
    }

    public Color getBackground() {
        Color result = null;
        Color whitewash = this.getColor();
        if (whitewash == null && (result = (Color)this.get(VisualKey.BACKGROUND)) == null) {
            whitewash = (Color)this.get(VisualKey.FOREGROUND);
        }
        if (whitewash != null) {
            result = VisualMap.whitewash(whitewash);
        }
        return result;
    }

    public Color getColor() {
        return (Color)this.get(VisualKey.COLOR);
    }

    public void setColor(Color newValue) {
        this.put(VisualKey.COLOR, newValue);
    }

    public float[] getDash() {
        return (float[])this.get(VisualKey.DASH);
    }

    public EdgeEnd getEdgeSourceShape() {
        return (EdgeEnd)((Object)this.get(VisualKey.EDGE_SOURCE_SHAPE));
    }

    public String getEdgeSourceLabel() {
        return (String)this.get(VisualKey.EDGE_SOURCE_LABEL);
    }

    public void setEdgeSourceLabel(String newValue) {
        this.put(VisualKey.EDGE_SOURCE_LABEL, newValue);
    }

    public Point2D getEdgeSourcePos() {
        return (Point2D)this.get(VisualKey.EDGE_SOURCE_POS);
    }

    public void setEdgeSourcePos(Point2D newValue) {
        this.put(VisualKey.EDGE_SOURCE_POS, newValue);
    }

    public EdgeEnd getEdgeTargetShape() {
        return (EdgeEnd)((Object)this.get(VisualKey.EDGE_TARGET_SHAPE));
    }

    public String getEdgeTargetLabel() {
        return (String)this.get(VisualKey.EDGE_TARGET_LABEL);
    }

    public void setEdgeTargetLabel(String newValue) {
        this.put(VisualKey.EDGE_TARGET_LABEL, newValue);
    }

    public Point2D getEdgeTargetPos() {
        return (Point2D)this.get(VisualKey.EDGE_TARGET_POS);
    }

    public void setEdgeTargetPos(Point2D newValue) {
        this.put(VisualKey.EDGE_TARGET_POS, newValue);
    }

    public boolean isEmphasised() {
        return (Boolean)this.get(VisualKey.EMPHASIS);
    }

    public void setEmphasis(boolean newValue) {
        this.put(VisualKey.EMPHASIS, newValue);
    }

    public boolean isError() {
        return (Boolean)this.get(VisualKey.ERROR);
    }

    public void setError(boolean newValue) {
        this.put(VisualKey.ERROR, newValue);
    }

    public int getFont() {
        return (Integer)this.get(VisualKey.FONT);
    }

    public Color getForeground() {
        Color result = this.getColor();
        if (result == null) {
            result = (Color)this.get(VisualKey.FOREGROUND);
        }
        return result;
    }

    public Color getInnerLine() {
        return (Color)this.get(VisualKey.INNER_LINE);
    }

    public int getInset() {
        return (Integer)this.get(VisualKey.INSET);
    }

    public MultiLabel getLabel() {
        return (MultiLabel)this.get(VisualKey.LABEL);
    }

    public void setLabel(MultiLabel newValue) {
        this.put(VisualKey.LABEL, newValue);
    }

    public Point2D getLabelPos() {
        return (Point2D)this.get(VisualKey.LABEL_POS);
    }

    public void setLabelPos(Point2D newValue) {
        this.put(VisualKey.LABEL_POS, newValue);
    }

    public LineStyle getLineStyle() {
        return (LineStyle)((Object)this.get(VisualKey.LINE_STYLE));
    }

    public void setLineStyle(LineStyle newValue) {
        this.put(VisualKey.LINE_STYLE, (Object)newValue);
    }

    public float getLineWidth() {
        return ((Float)this.get(VisualKey.LINE_WIDTH)).floatValue();
    }

    public Point2D getNodePos() {
        return (Point2D)this.get(VisualKey.NODE_POS);
    }

    public void setNodePos(Point2D newValue) {
        this.put(VisualKey.NODE_POS, newValue);
    }

    public Dimension2D getNodeSize() {
        return (Dimension2D)this.get(VisualKey.NODE_SIZE);
    }

    public void setNodeSize(Dimension2D newValue) {
        this.put(VisualKey.NODE_SIZE, newValue);
    }

    public boolean isOpaque() {
        return (Boolean)this.get(VisualKey.OPAQUE);
    }

    public void setOpaque(boolean newValue) {
        this.put(VisualKey.OPAQUE, newValue);
    }

    public List<Point2D> getPoints() {
        return Collections.unmodifiableList((List)this.get(VisualKey.POINTS));
    }

    public void setPoints(List<Point2D> newValue) {
        this.put(VisualKey.POINTS, newValue);
    }

    public boolean isVisible() {
        return (Boolean)this.get(VisualKey.VISIBLE);
    }

    public void setVisible(boolean newValue) {
        this.put(VisualKey.VISIBLE, newValue);
    }

    Map<VisualKey, Object> getMap() {
        return this.map;
    }

    public AttributeMap getAttributes() {
        return this.attrMap;
    }

    public String toString() {
        return "VisualMap: " + this.map;
    }

    private static int whitewash(int value) {
        int distance = 255 - value;
        return value + distance * 90 / 100;
    }

    public static Color whitewash(Color color) {
        int red = VisualMap.whitewash(color.getRed());
        int green = VisualMap.whitewash(color.getGreen());
        int blue = VisualMap.whitewash(color.getBlue());
        int alpha = VisualMap.whitewash(color.getAlpha());
        return new Color(red, green, blue, alpha);
    }
}

