/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class CheckboxTree
extends JTree {
    private final DefaultMutableTreeNode topNode;
    private final DefaultTreeModel treeModel;
    private Color lastBackground;
    private transient boolean changing;
    private static final String CHECKBOX_ORIENTATION = "West";
    private static final int CHECKBOX_WIDTH = new JCheckBox().getPreferredSize().width;

    public CheckboxTree() {
        this.setCellRenderer(this.createRenderer());
        this.setCellEditor(this.createEditor());
        this.setEditable(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        BasicTreeUI ui = new BasicTreeUI(){

            @Override
            protected void selectPathForEvent(TreePath path, MouseEvent event) {
                if (!CheckboxTree.this.isOverCheckBox(path, event.getPoint().x)) {
                    super.selectPathForEvent(path, event);
                }
            }
        };
        this.setUI(ui);
        this.topNode = new DefaultMutableTreeNode();
        this.treeModel = new DefaultTreeModel(this.topNode);
        this.setModel(this.treeModel);
        this.getSelectionModel().setSelectionMode(4);
    }

    @Override
    public BasicTreeUI getUI() {
        return (BasicTreeUI)super.getUI();
    }

    @Override
    public void setBackground(Color background) {
        if (background != null) {
            this.lastBackground = background;
        }
        super.setBackground(background);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            this.setBackground(this.getColor(enabled));
        }
        super.setEnabled(enabled);
    }

    public boolean isOverCheckBox(int x, int y) {
        TreePath path = this.getPathForLocation(x, y);
        return this.isOverCheckBox(path, x);
    }

    private boolean isOverCheckBox(TreePath path, int x) {
        boolean result = false;
        if (path != null && path.getLastPathComponent() instanceof TreeNode) {
            TreeNode labelNode = (TreeNode)path.getLastPathComponent();
            Rectangle pathBounds = this.getPathBounds(path);
            if (CHECKBOX_ORIENTATION.equals(CHECKBOX_ORIENTATION)) {
                int checkboxBorder = pathBounds.x + CHECKBOX_WIDTH;
                result = labelNode.hasCheckbox() && x < checkboxBorder;
            } else {
                int checkboxBorder = pathBounds.x + pathBounds.width - CHECKBOX_WIDTH;
                result = labelNode.hasCheckbox() && x >= checkboxBorder;
            }
        }
        return result;
    }

    protected CellRenderer createRenderer() {
        return new CellRenderer(this);
    }

    protected CellEditor createEditor() {
        return new CellEditor(this);
    }

    Color getColor(boolean enabled) {
        return enabled ? this.lastBackground : null;
    }

    @Override
    protected void fireValueChanged(TreeSelectionEvent e) {
        if (!this.changing) {
            this.changing = true;
            super.fireValueChanged(e);
            this.changing = false;
        }
    }

    @Override
    public void clearSelection() {
        if (!this.changing) {
            this.changing = true;
            super.clearSelection();
            this.changing = false;
        }
    }

    @Override
    public DefaultTreeModel getModel() {
        return this.treeModel;
    }

    public DefaultMutableTreeNode getTopNode() {
        return this.topNode;
    }

    protected static class CellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final CheckboxTree tree;
        private final CellRenderer editor;

        public CellEditor(CheckboxTree tree) {
            this.tree = tree;
            this.editor = tree.createRenderer();
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (!CellEditor.this.editor.isInitialising()) {
                        CellEditor.this.stopCellEditing();
                        TreeNode editedNode = CellEditor.this.getInner().getTreeNode();
                        editedNode.setSelected(itemEvent.getStateChange() == 1);
                    }
                }
            };
            this.getInner().getCheckbox().addItemListener(itemListener);
        }

        @Override
        public TreeNode getCellEditorValue() {
            return this.editor.getTreeNode();
        }

        CellRenderer getInner() {
            return this.editor;
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            boolean result = false;
            if (event instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)event;
                result = this.tree.isOverCheckBox(mouseEvent.getX(), mouseEvent.getY());
            }
            return result;
        }

        @Override
        public boolean shouldSelectCell(EventObject event) {
            return false;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            JComponent result = this.editor.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, false);
            return result;
        }
    }

    protected static class CellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private boolean initialising;
        private final JCheckBox checkbox;
        private final CheckboxTree tree;
        private final DefaultTreeCellRenderer jLabel;
        private TreeNode labelNode;
        private static final Border INSET_BORDER = new EmptyBorder(0, 2, 0, 7);

        CellRenderer(CheckboxTree tree) {
            this.tree = tree;
            this.jLabel = new DefaultTreeCellRenderer();
            this.jLabel.setOpenIcon(null);
            this.jLabel.setLeafIcon(null);
            this.jLabel.setClosedIcon(null);
            this.jLabel.setBorder(INSET_BORDER);
            this.checkbox = new JCheckBox();
            this.checkbox.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)this.jLabel, "Center");
            this.add((Component)this.checkbox, CheckboxTree.CHECKBOX_ORIENTATION);
            this.setBorder(new EmptyBorder(0, 2, 0, 0));
            this.setComponentOrientation(this.tree.getComponentOrientation());
            this.setOpaque(false);
        }

        @Override
        public JComponent getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JComponent result;
            this.initialising = true;
            this.jLabel.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Color background = this.tree.getColor(tree.isEnabled());
            this.jLabel.setOpaque(!sel);
            this.jLabel.setBackground(background);
            TreeNode treeNode = this.labelNode = value instanceof TreeNode ? (TreeNode)value : null;
            if (this.labelNode != null && this.labelNode.hasCheckbox()) {
                this.checkbox.setSelected(this.labelNode.isSelected());
                this.setBackground(background);
                this.add((Component)this.jLabel, "Center");
                result = this;
            } else {
                result = this.jLabel;
            }
            this.initialising = false;
            return result;
        }

        public TreeNode getTreeNode() {
            return this.labelNode;
        }

        boolean isInitialising() {
            return this.initialising;
        }

        public JCheckBox getCheckbox() {
            return this.checkbox;
        }

        public DefaultTreeCellRenderer getInner() {
            return this.jLabel;
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if ("text".equals(propertyName) || ("font".equals(propertyName) || "foreground".equals(propertyName)) && oldValue != newValue && this.getClientProperty("html") != null) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public static abstract class TreeNode
    extends DefaultMutableTreeNode {
        public abstract boolean hasCheckbox();

        public abstract boolean isSelected();

        public abstract void setSelected(boolean var1);
    }
}

