/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import groove.gui.look.Values;
import groove.gui.tree.DisplayTreeNode;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class DisplayTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final Component displayList;

    DisplayTreeCellRenderer(Component displayList) {
        this.displayList = displayList;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        boolean cellSelected = isSelected || hasFocus;
        boolean cellFocused = cellSelected && this.displayList.isFocusOwner();
        Component result = super.getTreeCellRendererComponent(tree, value, cellSelected, expanded, leaf, row, false);
        Icon icon = null;
        String tip = null;
        String text = value.toString();
        boolean enabled = true;
        boolean error = false;
        boolean isTransient = false;
        if (value instanceof DisplayTreeNode) {
            DisplayTreeNode node = (DisplayTreeNode)value;
            tip = node.getTip();
            icon = node.getIcon();
            text = node.getText();
            enabled = node.isEnabled();
            error = node.isError();
            isTransient = node.isTransient();
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        this.setText(text);
        this.setToolTipText(tip);
        Values.ColorSet colors = isTransient ? Values.TRANSIENT_COLORS : (error ? Values.ERROR_COLORS : Values.NORMAL_COLORS);
        Color background = colors.getBackground(cellSelected, cellFocused);
        Color foreground = colors.getForeground(cellSelected, cellFocused);
        this.setForeground(enabled ? foreground : this.transparent(foreground));
        if (background == Color.WHITE) {
            background = null;
        }
        if (cellSelected) {
            this.setBackgroundSelectionColor(background);
        } else {
            this.setBackgroundNonSelectionColor(background);
        }
        this.setOpaque(false);
        return result;
    }

    private Color transparent(Color c) {
        if (c.equals(Color.WHITE)) {
            return c;
        }
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), 125);
    }
}

