/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import groove.gui.Icons;
import groove.gui.SimulatorModel;
import groove.gui.tree.DisplayTreeNode;
import groove.io.HTMLConverter;
import groove.lts.GraphState;
import groove.lts.MatchResult;
import groove.lts.RuleTransition;
import groove.lts.RuleTransitionLabel;
import javax.swing.Icon;

class MatchTreeNode
extends DisplayTreeNode {
    private final SimulatorModel model;
    private final GraphState source;
    private final int nr;
    private final boolean anchored;
    private String label;
    private static final String RIGHTARROW = "-->";
    private static final String TRACE_SUFFIX = " " + HTMLConverter.STRONG_TAG.on("(*)");

    public MatchTreeNode(SimulatorModel model, GraphState source, MatchResult match, int nr, boolean anchored) {
        super(match, false);
        this.source = source;
        this.nr = nr;
        this.model = model;
        this.anchored = anchored;
    }

    private boolean isTransition() {
        return this.getMatch().hasRuleTransitionFrom(this.source);
    }

    @Override
    public boolean isTransient() {
        return this.getMatch().getCtrlTransition().hasRecipe();
    }

    public MatchResult getMatch() {
        return (MatchResult)this.getUserObject();
    }

    public GraphState getSource() {
        return this.source;
    }

    @Override
    public Icon getIcon() {
        return Icons.GRAPH_MATCH_ICON;
    }

    @Override
    public boolean isEnabled() {
        return this.isTransition();
    }

    @Override
    public String getTip() {
        if (this.isEnabled()) {
            return super.getTip();
        }
        return "Doubleclick to apply match";
    }

    @Override
    public String getText() {
        if (this.label == null) {
            this.label = this.computeText();
        }
        return this.label;
    }

    private String computeText() {
        StringBuilder result = new StringBuilder();
        result.append(this.nr);
        result.append(": ");
        if (this.isTransition()) {
            RuleTransition trans = this.getMatch().getRuleTransition();
            result.append(trans.text(this.anchored));
            result.append(RIGHTARROW);
            result.append(HTMLConverter.ITALIC_TAG.on(trans.target().toString()));
            if (this.model.getTrace().contains(trans)) {
                result.append(TRACE_SUFFIX);
            }
            if (trans.target().isAbsent()) {
                HTMLConverter.STRIKETHROUGH_TAG.on(result);
            }
            HTMLConverter.HTML_TAG.on(result);
        } else {
            result.append(RuleTransitionLabel.text(this.source, this.getMatch(), this.anchored));
            result.append(RIGHTARROW);
            result.append("?");
        }
        return result.toString();
    }
}

