/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.RuleModel;
import groove.graph.GraphInfo;
import groove.graph.GraphProperties;
import groove.gui.display.ResourceDisplay;
import groove.gui.tree.ActionTreeNode;
import groove.gui.tree.RecipeTreeNode;
import groove.gui.tree.ResourceTreeNode;
import groove.gui.tree.StateTree;
import groove.io.HTMLConverter;
import java.util.LinkedHashMap;
import java.util.Map;

class RuleTreeNode
extends ResourceTreeNode
implements ActionTreeNode {
    private boolean tried = true;

    public RuleTreeNode(ResourceDisplay display, String ruleName) {
        super(display, ruleName, true);
    }

    public RuleModel getRule() {
        return (RuleModel)this.getResource();
    }

    public boolean hasRecipe() {
        return this.getRule().hasRecipes();
    }

    @Override
    public String getTip() {
        StringBuilder result = new StringBuilder();
        result.append("Rule ");
        result.append(HTMLConverter.STRONG_TAG.on(this.getName()));
        AspectGraph source = this.getRule().getSource();
        String remark = GraphInfo.getRemark(source);
        if (!remark.isEmpty()) {
            result.append(": ");
            result.append(HTMLConverter.toHtml(remark));
        }
        GraphProperties properties = GraphInfo.getProperties(source);
        LinkedHashMap<String, String> filteredProps = new LinkedHashMap<String, String>();
        GraphProperties.Key[] keyArray = GraphProperties.Key.values();
        int n = keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphProperties.Key key = keyArray[n2];
            String value = properties.getProperty(key);
            if (key != GraphProperties.Key.REMARK && !key.isSystem() && value != null && !value.isEmpty()) {
                filteredProps.put(key.getDescription(), value);
            }
            ++n2;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String keyword = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (GraphProperties.isKey(keyword) || value.isEmpty()) continue;
            filteredProps.put(keyword, value);
        }
        for (Map.Entry<Object, Object> entry : filteredProps.entrySet()) {
            result.append(HTMLConverter.HTML_LINEBREAK);
            result.append(this.propertyToString(entry));
        }
        if (!this.isTried() && GraphInfo.isEnabled(source)) {
            result.append(HTMLConverter.HTML_LINEBREAK);
            result.append("Not scheduled in this state, due to rule priorities or control");
        }
        HTMLConverter.HTML_TAG.on(result);
        return result.toString();
    }

    private String propertyToString(Map.Entry<String, String> entry) {
        return "<b>" + entry.getKey() + "</b> = " + entry.getValue();
    }

    @Override
    public boolean isEnabled() {
        return this.tried;
    }

    @Override
    public String getText() {
        boolean showEnabled = this.getRule().isEnabled();
        if (showEnabled) {
            showEnabled = !this.hasRecipe() || this.getParent() instanceof RecipeTreeNode || this.getParent() instanceof StateTree.StateTreeNode;
        }
        return this.getDisplay().getLabelText(this.getName(), showEnabled);
    }

    public boolean isTried() {
        return this.tried;
    }

    public void setTried(boolean tried) {
        this.tried = tried;
    }
}

