/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.Label;
import groove.gui.tree.LabelFilter;
import java.util.HashMap;
import java.util.Map;

public class TypeFilter
extends LabelFilter<AspectGraph> {
    private final Map<TypeLabel, TypeEntry> nodeTypeEntryMap = new HashMap<TypeLabel, TypeEntry>();
    private final Map<TypeLabel, Map<TypeLabel, TypeEntry>> edgeTypeEntryMap = new HashMap<TypeLabel, Map<TypeLabel, TypeEntry>>();
    private TypeGraph typeGraph;

    @Override
    public void clear() {
        super.clear();
        this.nodeTypeEntryMap.clear();
        this.edgeTypeEntryMap.clear();
        this.typeGraph = null;
    }

    @Override
    public TypeEntry getEntry(Label element) {
        TypeEntry result = null;
        if (element instanceof TypeNode) {
            TypeElement key = (TypeElement)element;
            TypeLabel keyLabel = key.label();
            result = this.nodeTypeEntryMap.get(keyLabel);
            if (result == null) {
                result = this.createEntry(key);
                this.nodeTypeEntryMap.put(keyLabel, result);
            }
        } else if (element instanceof TypeEdge) {
            TypeLabel edgeKeyLabel;
            TypeEdge key = (TypeEdge)element;
            TypeLabel nodeKeyLabel = ((TypeNode)key.source()).label();
            Map<TypeLabel, TypeEntry> entryMap = this.edgeTypeEntryMap.get(nodeKeyLabel);
            if (entryMap == null) {
                entryMap = new HashMap<TypeLabel, TypeEntry>();
                this.edgeTypeEntryMap.put(nodeKeyLabel, entryMap);
            }
            if ((result = entryMap.get(edgeKeyLabel = (TypeLabel)key.label())) == null) {
                result = this.createEntry(key);
                entryMap.put(edgeKeyLabel, result);
            }
        }
        return result;
    }

    private TypeEntry createEntry(TypeElement type) {
        TypeEntry result = new TypeEntry(type);
        assert (this.isTypeGraphConsistent(result));
        return result;
    }

    private boolean isTypeGraphConsistent(TypeEntry entry) {
        TypeGraph typeGraph = entry.getType().getGraph();
        if (this.typeGraph == null) {
            this.typeGraph = typeGraph;
            return true;
        }
        return this.typeGraph == typeGraph;
    }

    public static class TypeEntry
    implements LabelFilter.Entry {
        private final TypeElement type;

        public TypeEntry(TypeElement type) {
            this.type = type;
        }

        public TypeElement getType() {
            return this.type;
        }

        @Override
        public Label getLabel() {
            return this.type.label();
        }

        @Override
        public int compareTo(LabelFilter.Entry o) {
            TypeEntry other = (TypeEntry)o;
            TypeElement type = this.getType();
            TypeElement otherType = other.getType();
            if (type instanceof TypeNode) {
                return type.compareTo(otherType);
            }
            if (otherType instanceof TypeNode) {
                return otherType.compareTo(type);
            }
            TypeEdge edge = (TypeEdge)type;
            TypeEdge otherEdge = (TypeEdge)otherType;
            int result = ((TypeNode)edge.source()).label().compareTo(((TypeNode)otherEdge.source()).label());
            if (result == 0) {
                result = ((TypeLabel)edge.label()).compareTo((Label)otherEdge.label());
            }
            return result;
        }

        public int hashCode() {
            if (this.type instanceof TypeNode) {
                return this.type.hashCode();
            }
            TypeEdge edge = (TypeEdge)this.type;
            return ((TypeNode)edge.source()).label().hashCode() ^ ((TypeLabel)edge.label()).hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TypeEntry)) {
                return false;
            }
            TypeEntry other = (TypeEntry)obj;
            if (!this.type.label().equals(other.type.label())) {
                return false;
            }
            if (this.type instanceof TypeNode) {
                return other.type instanceof TypeNode;
            }
            if (other.type instanceof TypeNode) {
                return false;
            }
            TypeEdge edge = (TypeEdge)this.type;
            TypeEdge otherEdge = (TypeEdge)other.type;
            return ((TypeNode)edge.source()).label().equals(((TypeNode)otherEdge.source()).label());
        }

        public String toString() {
            return this.type.toString();
        }
    }
}

