/*
 * Decompiled with CFR 0.152.
 */
package groove.io;

import java.io.File;
import java.io.FileFilter;

public abstract class ExtensionFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private final String description;
    private boolean acceptDirectories;
    public static final char SEPARATOR = '.';

    public ExtensionFilter(String description, boolean acceptDirectories) {
        this.description = description;
        this.setAcceptDirectories(acceptDirectories);
    }

    @Override
    public boolean accept(File file) {
        return this.acceptExtension(file) || this.isAcceptDirectories() && file.isDirectory();
    }

    public abstract boolean acceptExtension(File var1);

    @Override
    public String getDescription() {
        return this.description;
    }

    public abstract String getExtension();

    public String stripExtension(String filename) {
        if (filename.endsWith(this.getExtension())) {
            return filename.substring(0, filename.lastIndexOf(this.getExtension()));
        }
        return filename;
    }

    public String addExtension(String filename) {
        if (this.hasExtension(filename)) {
            return filename;
        }
        return String.valueOf(filename) + this.getExtension();
    }

    public boolean hasExtension(String filename) {
        return filename.endsWith(this.getExtension());
    }

    public boolean isAcceptDirectories() {
        return this.acceptDirectories;
    }

    public final void setAcceptDirectories(boolean accept) {
        this.acceptDirectories = accept;
    }

    public final int getFileSelectionMode() {
        int result = this.isAcceptDirectories() ? 2 : 0;
        return result;
    }

    public static String getExtension(File file) {
        String name = file.getName();
        return name.substring(name.lastIndexOf(46));
    }

    public static String getPureName(File file) {
        return ExtensionFilter.getPureName(file.getName());
    }

    public static String getPureName(String filename) {
        int index = filename.lastIndexOf(46);
        if (index < 0) {
            return filename;
        }
        return filename.substring(0, index);
    }
}

