/*
 * Decompiled with CFR 0.152.
 */
package groove.io;

import groove.io.ExtensionFilter;
import groove.io.GrooveFileView;
import groove.util.Groove;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileView;

public class GrooveFileChooser
extends JFileChooser {
    private boolean askOverwrite = true;
    private static final Map<ExtensionFilter, GrooveFileChooser> simpleMap = new HashMap<ExtensionFilter, GrooveFileChooser>();
    private static final Map<List<ExtensionFilter>, GrooveFileChooser> listMap = new HashMap<List<ExtensionFilter>, GrooveFileChooser>();

    protected GrooveFileChooser() {
        this(Groove.CURRENT_WORKING_DIR);
    }

    private GrooveFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.setFileView(this.createFileView());
        this.setAcceptAllFileFilterUsed(false);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public boolean isTraversable(File file) {
        return super.isTraversable(file) && (!(this.getFileFilter() instanceof ExtensionFilter) || !((ExtensionFilter)this.getFileFilter()).acceptExtension(file));
    }

    @Override
    public File getSelectedFile() {
        File result;
        File currDir = super.getCurrentDirectory();
        if (currDir != null) {
            Groove.CURRENT_WORKING_DIR = currDir.getAbsolutePath();
        }
        if ((result = super.getSelectedFile()) != null && !result.exists() && this.getFileFilter() instanceof ExtensionFilter) {
            ExtensionFilter fileFilter = (ExtensionFilter)this.getFileFilter();
            String resultName = fileFilter.addExtension(result.getName());
            result = new File(result.getParentFile(), resultName);
        }
        return result;
    }

    @Override
    public void approveSelection() {
        if (this.getDialogType() == 1 && this.isAskOverwrite()) {
            File f = this.getSelectedFile();
            if (f.exists()) {
                int result = JOptionPane.showConfirmDialog(this, String.valueOf(f.getName()) + " already exists, overwrite?", "Overwrite existing file", 0);
                switch (result) {
                    case 0: {
                        super.approveSelection();
                        return;
                    }
                }
                return;
            }
            super.approveSelection();
            return;
        }
        super.approveSelection();
    }

    public void setAskOverwrite(boolean askOverwrite) {
        this.askOverwrite = askOverwrite;
    }

    public boolean isAskOverwrite() {
        return this.askOverwrite;
    }

    protected FileView createFileView() {
        return new GrooveFileView();
    }

    public static GrooveFileChooser getFileChooser(ExtensionFilter filter) {
        GrooveFileChooser chooser = simpleMap.get(filter);
        if (chooser == null) {
            chooser = new GrooveFileChooser();
            chooser.addChoosableFileFilter(filter);
            chooser.setFileSelectionMode(filter.getFileSelectionMode());
            simpleMap.put(filter, chooser);
        }
        chooser.setCurrentDirectory(chooser.getFileSystemView().createFileObject(Groove.CURRENT_WORKING_DIR));
        return chooser;
    }

    public static GrooveFileChooser getFileChooser(List<ExtensionFilter> filters) {
        GrooveFileChooser chooser = listMap.get(filters);
        if (chooser == null) {
            chooser = new GrooveFileChooser();
            for (ExtensionFilter filter : filters) {
                chooser.addChoosableFileFilter(filter);
            }
            chooser.setFileFilter(filters.get(0));
            chooser.setFileSelectionMode(filters.get(0).getFileSelectionMode());
            listMap.put(filters, chooser);
        }
        chooser.setCurrentDirectory(chooser.getFileSystemView().createFileObject(Groove.CURRENT_WORKING_DIR));
        return chooser;
    }
}

