/*
 * Decompiled with CFR 0.152.
 */
package groove.io;

import groove.gui.Icons;
import groove.io.FileType;
import java.io.File;
import javax.swing.Icon;
import javax.swing.filechooser.FileView;

public class GrooveFileView
extends FileView {
    private boolean gpsTraversable;

    GrooveFileView() {
        this.setGpsTraversable(true);
    }

    @Override
    public Icon getIcon(File f) {
        if (GrooveFileView.isGpsFolder(f)) {
            return Icons.GPS_FOLDER_ICON;
        }
        if (GrooveFileView.isCompressedGpsFolder(f)) {
            return Icons.GPS_COMPRESSED_FOLDER_ICON;
        }
        if (GrooveFileView.isGraphFile(f)) {
            return Icons.GRAPH_FILE_ICON;
        }
        if (GrooveFileView.isRuleFile(f)) {
            return Icons.RULE_FILE_ICON;
        }
        if (GrooveFileView.isTypeFile(f)) {
            return Icons.TYPE_FILE_ICON;
        }
        if (GrooveFileView.isControlFile(f)) {
            return Icons.CONTROL_FILE_ICON;
        }
        if (GrooveFileView.isPrologFile(f)) {
            return Icons.PROLOG_FILE_ICON;
        }
        return null;
    }

    @Override
    public String getDescription(File f) {
        if (GrooveFileView.isControlFile(f)) {
            return "A control program";
        }
        if (GrooveFileView.isRuleFile(f)) {
            return "A graph production rule";
        }
        if (GrooveFileView.isTypeFile(f)) {
            return "A graph type";
        }
        if (GrooveFileView.isStateFile(f)) {
            return "A state graph";
        }
        if (GrooveFileView.isGpsFolder(f)) {
            return "A graph production system";
        }
        if (GrooveFileView.isGxlFile(f)) {
            return "A GXL-formatted graph";
        }
        return null;
    }

    @Override
    public String getTypeDescription(File f) {
        return this.getDescription(f);
    }

    @Override
    public Boolean isTraversable(File f) {
        Boolean superTraversable = super.isTraversable(f);
        if (this.isGpsTraversable()) {
            return superTraversable;
        }
        return (superTraversable == null || superTraversable != false) && !GrooveFileView.isGpsFolder(f);
    }

    public boolean isGpsTraversable() {
        return this.gpsTraversable;
    }

    public void setGpsTraversable(boolean gpsTraversable) {
        this.gpsTraversable = gpsTraversable;
    }

    protected static boolean isControlFile(File f) {
        return FileType.CONTROL_FILTER.acceptExtension(f);
    }

    protected static boolean isGraphFile(File f) {
        return GrooveFileView.isStateFile(f) || GrooveFileView.isGxlFile(f);
    }

    protected static boolean isStateFile(File f) {
        return FileType.STATE_FILTER.acceptExtension(f);
    }

    protected static boolean isGxlFile(File f) {
        return FileType.GXL_FILTER.acceptExtension(f);
    }

    protected static boolean isPrologFile(File f) {
        return FileType.PROLOG_FILTER.acceptExtension(f);
    }

    protected static boolean isRuleFile(File f) {
        return FileType.RULE_FILTER.acceptExtension(f);
    }

    protected static boolean isTypeFile(File f) {
        return FileType.TYPE_FILTER.acceptExtension(f);
    }

    protected static boolean isGpsFolder(File f) {
        return FileType.GRAMMAR_FILTER.acceptExtension(f);
    }

    protected static boolean isCompressedGpsFolder(File f) {
        return FileType.ZIP_FILTER.acceptExtension(f) || FileType.JAR_FILTER.acceptExtension(f);
    }
}

