/*
 * Decompiled with CFR 0.152.
 */
package groove.io;

import groove.grammar.QualName;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.GraphBasedModel;
import groove.grammar.model.ResourceKind;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.display.DisplayKind;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.AspectJModel;
import groove.io.ExtensionFilter;
import groove.io.FileType;
import groove.io.GrooveFileChooser;
import groove.io.external.Exporter;
import groove.io.external.Format;
import groove.io.external.FormatExporter;
import groove.io.external.PortException;
import groove.io.external.format.NativePorter;
import groove.util.CommandLineOption;
import groove.util.CommandLineTool;
import groove.util.Groove;
import groove.util.Pair;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jgraph.graph.GraphModel;

public class Imager
extends CommandLineTool {
    private File inFile;
    private File outFile;
    private String imageFormat;
    private boolean editorView;
    private final ImagerFrame imagerFrame;
    private EditorViewOption editorViewOption;
    private FormatOption formatOption;
    private static Map<String, Format> formatMap;
    public static final String APPLICATION_NAME = "Imager";
    public static final String BROWSE_LABEL = "Browse...";
    private static final List<ExtensionFilter> acceptFilters;

    static {
        acceptFilters = new ArrayList<ExtensionFilter>(4);
        acceptFilters.add(FileType.GRAMMAR_FILTER);
        acceptFilters.add(FileType.TYPE_FILTER);
        acceptFilters.add(FileType.STATE_FILTER);
        acceptFilters.add(FileType.RULE_FILTER);
        acceptFilters.add(FileType.GXL_FILTER);
    }

    public Imager(String ... args) {
        this(false, args);
    }

    public Imager(boolean gui, String ... args) {
        super(args);
        Options.initLookAndFeel();
        if (gui) {
            this.imagerFrame = new ImagerFrame();
            this.imagerFrame.pack();
            this.imagerFrame.setVisible(true);
        } else {
            this.imagerFrame = null;
            this.addOption(this.getEditorViewOption());
            this.addOption(this.getFormatOption());
        }
    }

    public void start() {
        try {
            File inFile = this.getInFile();
            File outFile = this.getOutFile();
            if (inFile == null) {
                this.println("No input file specified");
            } else if (!inFile.exists()) {
                this.println("Input file " + inFile + " does not exist");
            } else if (outFile == null) {
                this.makeImage(inFile, inFile);
            } else {
                this.makeImage(inFile, outFile);
            }
        }
        catch (IOException e) {
            this.println(e.getMessage());
        }
    }

    public void makeImage(File inFile, File outFile) throws IOException {
        if (!inFile.exists()) {
            throw new IOException("Input file " + inFile + " does not exist");
        }
        File grammarFile = Imager.getGrammarFile(inFile);
        if (grammarFile == null) {
            throw new IOException("Input file " + inFile + " is not part of a grammar");
        }
        try {
            GrammarModel grammar = GrammarModel.newInstance(grammarFile, false);
            this.makeImage(grammar, inFile, outFile);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void makeImage(GrammarModel grammar, File inFile, File outFile) throws IOException {
        if (inFile.isDirectory()) {
            File[] files = inFile.listFiles();
            if (!outFile.exists() && !outFile.mkdir()) throw new IOException("Directory " + outFile + " could not be created");
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                if (element.isDirectory() || Imager.parse(element) != null) {
                    this.makeImage(grammar, element, new File(outFile, element.getName()));
                }
                ++n2;
            }
            return;
        } else {
            String outFileName;
            File outParent = outFile.getParentFile();
            if (outParent == null) {
                outParent = inFile.getParentFile();
            } else if (!outParent.exists() && !outParent.mkdir()) {
                JOptionPane.showMessageDialog(null, "Output directory " + outParent + " cannot be created");
                return;
            }
            Pair<ResourceKind, QualName> resource = Imager.parse(inFile);
            if (resource == null) {
                throw new IOException("Input file " + inFile + " is not a resource file");
            }
            String imageFormat = this.getImageFormat();
            if (imageFormat == null) {
                imageFormat = outFile.toString();
            }
            Map<String, Format> formats = Imager.getFormatMap();
            Format outputFormat = null;
            String extension = null;
            for (Map.Entry<String, Format> e : formats.entrySet()) {
                if (!imageFormat.endsWith(e.getKey())) continue;
                extension = e.getKey();
                outputFormat = e.getValue();
                break;
            }
            if (outputFormat == null) {
                Map.Entry<String, Format> e = Imager.getFormatMap().entrySet().iterator().next();
                extension = e.getKey();
                outputFormat = e.getValue();
                outFileName = outFile.getName();
            } else {
                outFileName = outputFormat.stripExtension(outFile.getName());
            }
            outFile = new File(outParent, String.valueOf(outFileName) + '.' + extension);
            GraphBasedModel resourceModel = (GraphBasedModel)grammar.getResource(resource.one(), resource.two().toString());
            AspectGraph aspectGraph = resourceModel.getSource();
            Options options = new Options();
            options.getItem("Show data values as nodes").setSelected(this.isEditorView());
            options.getItem("Show aspect prefixes").setSelected(this.isEditorView());
            DisplayKind displayKind = DisplayKind.toDisplay(ResourceKind.toResource(aspectGraph.getRole()));
            AspectJGraph jGraph = new AspectJGraph(null, displayKind, false);
            AspectJModel model = jGraph.newModel();
            model.setGrammar(grammar);
            model.loadGraph(aspectGraph);
            jGraph.setModel((GraphModel)model);
            Dimension oldPrefSize = jGraph.getPreferredSize();
            Dimension newPrefSize = new Dimension(oldPrefSize.width * 2, oldPrefSize.height * 2);
            jGraph.setSize(newPrefSize);
            this.printlnMedium("Imaging " + inFile + " as " + outFile);
            try {
                Exporter.Exportable exportable = new Exporter.Exportable(jGraph);
                ((FormatExporter)outputFormat.getFormatter()).doExport(outFile, outputFormat, exportable);
                return;
            }
            catch (PortException e1) {
                this.println("Error exporting graph: " + e1.getMessage());
            }
        }
    }

    public File getInFile() {
        return this.inFile;
    }

    public File getOutFile() {
        return this.outFile;
    }

    public void setInFile(String fileName) {
        this.inFile = new File(fileName);
    }

    public void setOutFile(String outFileName) {
        this.outFile = new File(outFileName);
    }

    @Override
    protected void processArguments() {
        super.processArguments();
        List<String> argsList = this.getArgs();
        if (argsList.size() > 0) {
            this.setInFile(argsList.get(0));
            argsList.remove(0);
        }
        if (argsList.size() > 0) {
            this.setOutFile(argsList.get(0));
            argsList.remove(0);
        }
        if (argsList.size() > 0) {
            this.printError("Invalid number of arguments", true);
        }
    }

    @Override
    protected String getUsageMessage() {
        return "Usage: Imager [options] inputfile";
    }

    @Override
    protected boolean supportsLogOption() {
        return false;
    }

    @Override
    protected boolean supportsOutputOption() {
        return true;
    }

    @Override
    protected void print(String text) {
        if (this.imagerFrame == null) {
            super.print(text);
        } else {
            this.imagerFrame.print(text);
        }
    }

    @Override
    protected void println() {
        if (this.imagerFrame == null) {
            super.println();
        } else {
            this.imagerFrame.println("");
        }
    }

    @Override
    protected void println(String text) {
        if (this.imagerFrame == null) {
            super.println(text);
        } else {
            this.imagerFrame.println(text);
        }
    }

    private String getImageFormat() {
        return this.imageFormat;
    }

    private void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    public final boolean isEditorView() {
        return this.editorView;
    }

    public final void setEditorView(boolean editorView) {
        this.editorView = editorView;
    }

    private EditorViewOption getEditorViewOption() {
        if (this.editorViewOption == null) {
            this.editorViewOption = new EditorViewOption();
        }
        return this.editorViewOption;
    }

    private FormatOption getFormatOption() {
        if (this.formatOption == null) {
            this.formatOption = new FormatOption();
        }
        return this.formatOption;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            new Imager(true, new String[0]);
        } else {
            Imager imager = new Imager(args);
            imager.processArguments();
            imager.start();
        }
    }

    private static File getGrammarFile(File file) {
        while (file != null && !FileType.GRAMMAR_FILTER.accept(file)) {
            file = file.getParentFile();
        }
        return file;
    }

    private static Pair<ResourceKind, QualName> parse(File file) {
        ResourceKind kind = null;
        ResourceKind[] resourceKindArray = ResourceKind.values();
        int n = resourceKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceKind k = resourceKindArray[n2];
            if (k.isGraphBased() && k.getFilter().accept(file)) {
                kind = k;
                break;
            }
            ++n2;
        }
        QualName qualName = null;
        if (kind != null) {
            file = new File(kind.getFilter().stripExtension(file.toString()));
            LinkedList<String> fragments = new LinkedList<String>();
            while (file != null && !FileType.GRAMMAR_FILTER.accept(file)) {
                fragments.add(0, file.getName());
                file = file.getParentFile();
            }
            if (file != null) {
                try {
                    qualName = new QualName(fragments);
                }
                catch (FormatException formatException) {}
            }
        }
        return qualName == null ? null : Pair.newPair(kind, qualName);
    }

    public static Map<String, Format> getFormatMap() {
        Map<String, Format> result = formatMap;
        if (result == null) {
            result = formatMap = new HashMap<String, Format>();
            for (FormatExporter exporter : Exporter.getExporters()) {
                if (exporter instanceof NativePorter) continue;
                for (Format format : exporter.getSupportedFormats()) {
                    for (String ext : format.getExtensions()) {
                        result.put(ext.substring(1), format);
                    }
                }
            }
        }
        return result;
    }

    private class EditorViewOption
    implements CommandLineOption {
        public static final String NAME = "e";
        public static final String DESCRIPTION = "Enforces editor view export";

        private EditorViewOption() {
        }

        @Override
        public String[] getDescription() {
            return new String[]{DESCRIPTION};
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public String getParameterName() {
            return null;
        }

        @Override
        public boolean hasParameter() {
            return false;
        }

        @Override
        public void parse(String parameter) throws IllegalArgumentException {
            Imager.this.setEditorView(true);
        }
    }

    private class FormatOption
    implements CommandLineOption {
        public static final String NAME = "f";
        public static final String DESCRIPTION = "Output format extension. Supported formats are:";
        public static final String PARAMETER_NAME = "name";

        private FormatOption() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public String[] getDescription() {
            LinkedList<String> result = new LinkedList<String>();
            result.add(DESCRIPTION);
            Map<String, Format> exts = Imager.getFormatMap();
            for (String formatName : exts.keySet()) {
                String format = "* " + formatName;
                result.add(format);
            }
            return result.toArray(new String[result.size()]);
        }

        @Override
        public String getParameterName() {
            return PARAMETER_NAME;
        }

        @Override
        public boolean hasParameter() {
            return true;
        }

        @Override
        public void parse(String parameter) {
            String extension = parameter;
            Map<String, Format> exts = Imager.getFormatMap();
            if (!exts.containsKey(extension)) {
                throw new IllegalArgumentException("Unknown format: " + parameter);
            }
            Imager.this.setImageFormat(extension);
        }
    }

    private class ImagerFrame
    extends JFrame {
        final JTextField inFileField;
        final JTextField outFileField;
        final JButton inFileBrowseButton;
        final JButton outFileBrowseButton;
        private final JButton imageButton;
        private final JButton closeButton;
        final JCheckBox outFileEnabler;
        final JFileChooser browseChooser;
        private final JTextArea logArea;
        final JComboBox formatBox;

        public ImagerFrame() {
            super(Imager.APPLICATION_NAME);
            this.inFileField = new JTextField();
            this.outFileField = new JTextField();
            this.inFileBrowseButton = new JButton(Imager.BROWSE_LABEL);
            this.outFileBrowseButton = new JButton(Imager.BROWSE_LABEL);
            this.imageButton = new JButton("Image");
            this.closeButton = new JButton("Close");
            this.outFileEnabler = new JCheckBox();
            this.browseChooser = GrooveFileChooser.getFileChooser(acceptFilters);
            this.logArea = new JTextArea();
            this.formatBox = new JComboBox<Object>(Imager.getFormatMap().keySet().toArray());
            this.setIconImage(Icons.GROOVE_ICON_16x16.getImage());
            this.initComponents();
            this.initActions();
            this.setContentPane(this.createContentPane());
            Imager.this.setVerbosity(2);
        }

        public void setInFile(String fileName) {
            this.inFileField.setText(fileName);
        }

        public void setOutFile(String fileName) {
            this.outFileField.setText(fileName);
        }

        public void handleImageAction() {
            String error = null;
            try {
                File inFile = new File(this.inFileField.getText());
                File outFile = this.outFileField.isEditable() ? new File(this.outFileField.getText()) : inFile;
                Imager.this.makeImage(inFile, outFile);
            }
            catch (IOException e) {
                error = e.getMessage();
            }
            if (error != null) {
                JOptionPane.showMessageDialog(this, error, "Error", 0);
            }
        }

        public void handleBrowseAction(JTextField fileField) {
            this.browseChooser.setSelectedFile(new File(fileField.getText()));
            int answer = this.browseChooser.showOpenDialog(this);
            if (answer == 0) {
                fileField.setText(this.browseChooser.getSelectedFile().getAbsolutePath());
            }
        }

        public void println(String text) {
            this.logArea.append(String.valueOf(text) + "\n");
            this.validate();
        }

        public void print(String text) {
            this.logArea.append(text);
            this.validate();
        }

        protected JOptionPane createOptionPane(JPanel messagePane, JButton[] buttonRow) {
            return new JOptionPane(messagePane, -1, -1, null, buttonRow);
        }

        protected JComponent createContentPane() {
            this.formatBox.setSelectedIndex(1);
            this.formatBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Imager.this.setImageFormat((String)ImagerFrame.this.formatBox.getSelectedItem());
                }
            });
            JPanel central = new JPanel(new GridBagLayout(), false);
            GridBagConstraints constraint = new GridBagConstraints();
            constraint.ipadx = 1;
            constraint.ipady = 2;
            constraint.gridwidth = 2;
            constraint.anchor = 21;
            central.add((Component)new JLabel("Input filename"), constraint);
            constraint.fill = 1;
            constraint.weightx = 1.0;
            constraint.anchor = 10;
            constraint.gridwidth = 1;
            central.add((Component)this.inFileField, constraint);
            constraint.fill = 0;
            constraint.weightx = 0.0;
            central.add((Component)this.inFileBrowseButton, constraint);
            constraint.gridwidth = 1;
            constraint.weighty = 0.0;
            constraint.gridy = 1;
            constraint.anchor = 21;
            constraint.fill = 0;
            central.add((Component)new JLabel("Output filename"), constraint);
            central.add((Component)this.outFileEnabler, constraint);
            constraint.fill = 1;
            constraint.weightx = 1.0;
            constraint.anchor = 10;
            central.add((Component)this.outFileField, constraint);
            constraint.gridwidth = 0;
            constraint.fill = 0;
            constraint.weightx = 0.0;
            central.add((Component)this.outFileBrowseButton, constraint);
            constraint.anchor = 21;
            constraint.gridx = 0;
            constraint.gridy = 2;
            constraint.gridwidth = 2;
            central.add((Component)new JLabel("Output format"), constraint);
            constraint.gridx = -1;
            constraint.gridwidth = 1;
            constraint.fill = 2;
            central.add((Component)this.formatBox, constraint);
            constraint.gridy = 3;
            constraint.anchor = 21;
            constraint.gridheight = 1;
            constraint.ipady = 9;
            constraint.gridwidth = 0;
            constraint.weightx = 0.0;
            central.add((Component)new JLabel("Imaging log"), constraint);
            constraint.gridy = -1;
            constraint.weightx = 1.0;
            constraint.weighty = 1.0;
            constraint.fill = 1;
            JScrollPane logPane = new JScrollPane(this.logArea);
            logPane.setVerticalScrollBarPolicy(22);
            central.add((Component)logPane, constraint);
            return this.createOptionPane(central, new JButton[]{this.imageButton, this.closeButton});
        }

        protected Action createBrowseAction(final JTextField fileField) {
            return new AbstractAction(Imager.BROWSE_LABEL){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ImagerFrame.this.handleBrowseAction(fileField);
                    if (evt.getSource() == ImagerFrame.this.inFileBrowseButton && !ImagerFrame.this.outFileEnabler.isSelected()) {
                        File file = new File(ImagerFrame.this.inFileField.getText());
                        File dir = file.isDirectory() ? file : file.getParentFile();
                        ImagerFrame.this.outFileField.setText(dir.getPath());
                    }
                }
            };
        }

        protected void initComponents() {
            this.setInFile(Groove.WORKING_DIR);
            this.setOutFile(Groove.WORKING_DIR);
            this.inFileField.setPreferredSize(new Dimension(300, 0));
            this.outFileField.setEditable(false);
            this.logArea.setEditable(false);
            this.logArea.setRows(10);
        }

        protected void initActions() {
            this.setDefaultCloseOperation(3);
            AbstractAction closeAction = new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    System.exit(0);
                }
            };
            AbstractAction imageAction = new AbstractAction("Image"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ImagerFrame.this.handleImageAction();
                }
            };
            ItemListener enableItemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    ImagerFrame.this.outFileField.setEditable(ImagerFrame.this.outFileEnabler.isSelected());
                    ImagerFrame.this.outFileBrowseButton.setEnabled(ImagerFrame.this.outFileEnabler.isSelected());
                }
            };
            this.closeButton.setAction(closeAction);
            this.imageButton.setAction(imageAction);
            this.outFileEnabler.addItemListener(enableItemListener);
            this.inFileBrowseButton.setAction(this.createBrowseAction(this.inFileField));
            this.outFileBrowseButton.setAction(this.createBrowseAction(this.outFileField));
            this.outFileBrowseButton.setEnabled(false);
        }
    }
}

