/*
 * Decompiled with CFR 0.152.
 */
package groove.io;

import au.com.bytecode.opencsv.CSVReader;
import groove.util.Groove;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;

public class Util {
    private static final long FIFTY_MB = 0x3200000L;
    public static final char EXISTS = '\u2203';
    public static final char FORALL = '\u2200';
    public static final char WEDGE = '\u2227';
    public static final char VEE = '\u2228';
    public static final char NEG = '\u00ac';
    public static final char LC_PI = '\u03c0';
    public static final char LC_TAU = '\u03c4';
    public static final char LC_EPSILON = '\u03b5';
    public static final char LC_LAMBDA = '\u03bb';
    public static final char FRENCH_QUOTES_OPEN = '\u00ab';
    public static final char FRENCH_QUOTES_CLOSED = '\u00bb';
    public static final char GT = '>';
    public static final char LANGLE = '<';
    public static final char RANGLE = '>';
    public static final char TIMES = '\u2a09';
    public static final char RT = '\u25b8';
    public static final char LT = '\u25c2';
    public static final char UT = '\u25b4';
    public static final char DT = '\u25be';
    public static final char RA = '\u2192';
    public static final char LA = '\u2190';
    public static final char UA = '\u2191';
    public static final char DA = '\u2193';
    public static final char URA = '\u2197';
    public static final char ULA = '\u2196';
    public static final char DRA = '\u2198';
    public static final char DLA = '\u2199';
    public static final char THIN_SPACE = '\u2009';

    public static void copyDirectory(File srcDir, File destDir, boolean preserveFileDate) throws IOException {
        File[] srcFiles;
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcDir.exists()) {
            throw new FileNotFoundException("Source '" + srcDir + "' does not exist");
        }
        if (!srcDir.isDirectory()) {
            throw new IOException("Source '" + srcDir + "' exists but is not a directory");
        }
        if (srcDir.getCanonicalPath().equals(destDir.getCanonicalPath())) {
            throw new IOException("Source '" + srcDir + "' and destination '" + destDir + "' are the same");
        }
        ArrayList<String> exclusionList = null;
        if (destDir.getCanonicalPath().startsWith(srcDir.getCanonicalPath()) && (srcFiles = srcDir.listFiles()) != null && srcFiles.length > 0) {
            exclusionList = new ArrayList<String>(srcFiles.length);
            File[] fileArray = srcFiles;
            int n = srcFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File srcFile = fileArray[n2];
                File copiedFile = new File(destDir, srcFile.getName());
                exclusionList.add(copiedFile.getCanonicalPath());
                ++n2;
            }
        }
        Util.doCopyDirectory(srcDir, destDir, preserveFileDate, exclusionList);
    }

    private static void doCopyDirectory(File srcDir, File destDir, boolean preserveFileDate, List<String> exclusionList) throws IOException {
        File[] files = srcDir.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + srcDir);
        }
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + destDir + "' exists but is not a directory");
            }
        } else if (!destDir.mkdirs()) {
            throw new IOException("Destination '" + destDir + "' directory cannot be created");
        }
        if (!destDir.canWrite()) {
            throw new IOException("Destination '" + destDir + "' cannot be written to");
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            File copiedFile = new File(destDir, file.getName());
            if (exclusionList == null || !exclusionList.contains(file.getCanonicalPath())) {
                if (file.isDirectory()) {
                    Util.doCopyDirectory(file, copiedFile, preserveFileDate, exclusionList);
                } else {
                    Util.doCopyFile(file, copiedFile, preserveFileDate);
                }
            }
            ++n2;
        }
        if (preserveFileDate) {
            destDir.setLastModified(srcDir.lastModified());
        }
    }

    private static void doCopyFile(File srcFile, File destFile, boolean preserveFileDate) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel input = null;
        AbstractInterruptibleChannel output = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = ((FileChannel)input).size();
            long pos = 0L;
            long count = 0L;
            while (pos < size) {
                count = size - pos > 0x3200000L ? 0x3200000L : size - pos;
                pos += ((FileChannel)output).transferFrom((ReadableByteChannel)((Object)input), pos, count);
            }
        }
        finally {
            output.close();
            fos.close();
            input.close();
            fis.close();
        }
        if (srcFile.length() != destFile.length()) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
        }
        if (preserveFileDate) {
            destFile.setLastModified(srcFile.lastModified());
        }
    }

    public static String readFileToString(File file) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            fileData.append(buf, 0, numRead);
        }
        reader.close();
        return fileData.toString();
    }

    public static String readInputStreamToString(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder result = new StringBuilder();
        String nextLine = reader.readLine();
        while (nextLine != null) {
            result.append(nextLine);
            result.append("\n");
            nextLine = reader.readLine();
        }
        reader.close();
        return result.toString();
    }

    public static File getRelativePath(File currentDir, File target) {
        if (currentDir.isFile()) {
            currentDir = new File(currentDir.getParent());
        }
        if (!currentDir.isAbsolute() || !target.isAbsolute()) {
            return null;
        }
        String[] dirParts = currentDir.toString().split("\\Q" + File.pathSeparator + "\\E");
        String[] targetParts = target.toString().split("\\Q" + File.pathSeparator + "\\E");
        int i = 0;
        int max = Math.max(dirParts.length, targetParts.length);
        while (i < max && dirParts[i].equals(targetParts[i])) {
            ++i;
        }
        StringBuilder relPath = new StringBuilder();
        int j = i;
        while (j < dirParts.length) {
            relPath.append(".." + File.pathSeparator);
            ++j;
        }
        while (i < targetParts.length) {
            relPath.append(targetParts[i]);
            if (++i >= targetParts.length) continue;
            relPath.append(File.pathSeparator);
        }
        return new File(relPath.toString());
    }

    public static final List<String[]> readCSV(String name, char sep) {
        List result = null;
        try {
            CSVReader reader = new CSVReader((Reader)new FileReader(Groove.getResource(String.valueOf(name) + ".csv").getFile()), sep);
            result = reader.readAll();
            reader.close();
        }
        catch (IOException iOException) {}
        return result;
    }
}

