/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual;

import groove.io.conceptual.Acceptor;
import groove.io.conceptual.Name;
import groove.io.conceptual.Visitor;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.Type;

public class Field
implements Acceptor {
    private Name m_name;
    private Type m_type;
    private int m_lowerBound;
    private int m_upperBound;
    private Class m_class;

    public Field(Name name, Type type, int lower, int upper) {
        this.m_name = name;
        if (type instanceof Class) {
            if (lower == 0 && upper == 1) {
                type = ((Class)type).getNullableClass();
            } else if (upper > 1) {
                type = ((Class)type).getProperClass();
            }
        }
        if ((upper > 1 || upper == -1 || !(type instanceof Class) && lower == 0) && !(type instanceof Container)) {
            type = new Container(Container.Kind.SET, type);
        }
        if (type instanceof Container) {
            assert (((Container)type).getField() == null);
            ((Container)type).setField(this);
        }
        this.m_type = type;
        this.m_lowerBound = lower;
        this.m_upperBound = upper;
    }

    public Name getName() {
        return this.m_name;
    }

    public int getUpperBound() {
        return this.m_upperBound;
    }

    public int getLowerBound() {
        return this.m_lowerBound;
    }

    public Type getType() {
        return this.m_type;
    }

    public void setDefiningClass(Class cmClass) {
        this.m_class = cmClass;
    }

    public Class getDefiningClass() {
        return this.m_class;
    }

    @Override
    public boolean doVisit(Visitor v, Object param) {
        v.visit(this, param);
        return true;
    }

    public String toString() {
        return this.m_class.getId().getName() + "." + this.m_name;
    }
}

