/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public class Timer {
    private static int[] counts = new int[128];
    private static long[] times = new long[128];
    private static long[] wall = new long[128];
    private static boolean ENABLED = true;
    public static boolean PRINT_MSG = true;
    private static Map<Integer, String> messages = new HashMap<Integer, String>();

    public static int start(String message) {
        int index = messages.size();
        if (messages.containsValue(message)) {
            for (Map.Entry<Integer, String> e : messages.entrySet()) {
                if (!e.getValue().equals(message)) continue;
                index = e.getKey();
                break;
            }
        }
        Timer.start(index, message);
        return index;
    }

    public static void start(int timer) {
        if (!messages.containsKey(timer)) {
            throw new IllegalArgumentException("Nonexistant timer");
        }
        Timer.start(timer, "");
    }

    public static void start(int timer, String message) {
        if (!messages.containsKey(timer)) {
            messages.put(timer, message);
        }
        int n = timer;
        counts[n] = counts[n] + 1;
        Timer.wall[timer] = System.nanoTime();
    }

    public static void stop(int timer) {
        long delta = System.nanoTime() - wall[timer];
        int n = timer;
        times[n] = times[n] + delta;
    }

    public static void cont(int timer) {
        Timer.wall[timer] = System.nanoTime();
    }

    public static int cont(String message) {
        int index = messages.size();
        if (messages.containsValue(message)) {
            for (Map.Entry<Integer, String> e : messages.entrySet()) {
                if (!e.getValue().equals(message)) continue;
                index = e.getKey();
                break;
            }
        } else {
            throw new IllegalArgumentException();
        }
        Timer.wall[index] = System.nanoTime();
        return index;
    }

    public static void reset() {
        for (Map.Entry<Integer, String> e : messages.entrySet()) {
            Timer.printTime(e.getKey(), e.getValue());
        }
        messages.clear();
        times = new long[128];
        wall = new long[128];
        counts = new int[128];
    }

    public static void printTime(int timer) {
        Timer.printTime(timer, "");
    }

    public static void printTime(int timer, String message) {
        if (!ENABLED) {
            return;
        }
        if (PRINT_MSG && message.length() > 0) {
            System.out.print(String.valueOf(message) + ": ");
        }
        double time = (double)times[timer] / (double)counts[timer] / 1000000.0;
        System.out.println(new DecimalFormat("##0.00").format(time));
    }
}

