/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual;

import groove.io.conceptual.Id;
import groove.io.conceptual.property.Property;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.CustomDataType;
import groove.io.conceptual.type.Enum;
import groove.io.conceptual.type.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeModel
implements Serializable {
    private String m_name;
    private Map<Id, Class> m_classes = new HashMap<Id, Class>();
    private Map<Id, Enum> m_enums = new HashMap<Id, Enum>();
    private Map<Id, CustomDataType> m_datatypes = new HashMap<Id, CustomDataType>();
    private List<Property> m_properties = new ArrayList<Property>();
    private Map<Tuple, String> m_tupleNames = new HashMap<Tuple, String>();
    private Set<Id> m_usedIds = new HashSet<Id>();
    private Id m_commonPrefix;

    public TypeModel(String name) {
        this.m_name = name;
        this.m_commonPrefix = Id.ROOT;
    }

    public String getName() {
        return this.m_name;
    }

    public void resolve() {
        for (Property p : this.m_properties) {
            p.resolveFields();
        }
    }

    public boolean idInUse(Id id) {
        return this.m_usedIds.contains(id);
    }

    private void addUsedId(Id id) {
        if (this.m_usedIds.size() == 0) {
            this.m_commonPrefix = id;
        }
        this.m_usedIds.add(id);
        this.m_commonPrefix = this.m_commonPrefix.getCommonPart(id);
    }

    public Class getClass(Id id) {
        return this.getClass(id, false);
    }

    public Class getClass(Id id, boolean create) {
        if (this.m_classes.containsKey(id)) {
            return this.m_classes.get(id);
        }
        if (!create) {
            return null;
        }
        if (this.idInUse(id)) {
            return null;
        }
        this.addUsedId(id);
        Class newClass = new Class(id);
        this.m_classes.put(id, newClass);
        return newClass;
    }

    public boolean hasClass(Id id) {
        return this.m_classes.containsKey(id);
    }

    public Enum getEnum(Id id) {
        return this.getEnum(id, false);
    }

    public Enum getEnum(Id id, boolean create) {
        if (this.m_enums.containsKey(id)) {
            return this.m_enums.get(id);
        }
        if (!create) {
            return null;
        }
        if (this.idInUse(id)) {
            return null;
        }
        this.addUsedId(id);
        Enum newEnum = new Enum(id);
        this.m_enums.put(id, newEnum);
        return newEnum;
    }

    public boolean hasEnum(Id id) {
        return this.m_enums.containsKey(id);
    }

    public CustomDataType getDatatype(Id id) {
        return this.getDatatype(id, false);
    }

    public CustomDataType getDatatype(Id id, boolean create) {
        if (this.m_datatypes.containsKey(id)) {
            return this.m_datatypes.get(id);
        }
        if (!create) {
            return null;
        }
        if (this.idInUse(id)) {
            return null;
        }
        this.addUsedId(id);
        CustomDataType newDatatype = new CustomDataType(id);
        this.m_datatypes.put(id, newDatatype);
        return newDatatype;
    }

    public boolean hasDatatype(Id id) {
        return this.m_datatypes.containsKey(id);
    }

    public void addProperty(Property p) {
        this.m_properties.add(p);
    }

    public Collection<Class> getClasses() {
        return this.m_classes.values();
    }

    public Collection<Enum> getEnums() {
        return this.m_enums.values();
    }

    public Collection<CustomDataType> getDatatypes() {
        return this.m_datatypes.values();
    }

    public Collection<Property> getProperties() {
        return this.m_properties;
    }

    public Set<Id> getUsedIds() {
        return this.m_usedIds;
    }

    public Id getShortId(Id id) {
        return id.removePrefix(this.m_commonPrefix);
    }

    public Map<Id, Id> getShortIds() {
        HashMap<Id, Id> mappedIds = new HashMap<Id, Id>();
        if (this.m_usedIds.size() == 0) {
            return mappedIds;
        }
        for (Id id : this.m_usedIds) {
            if (id == this.m_commonPrefix) continue;
            mappedIds.put(id, id.removePrefix(this.m_commonPrefix));
        }
        return mappedIds;
    }

    public Id getCommonPrefix() {
        return this.m_commonPrefix;
    }

    public String getTupleName(Tuple tup) {
        if (!this.m_tupleNames.containsKey(tup)) {
            this.m_tupleNames.put(tup, "tup" + this.m_tupleNames.size() + 1);
        }
        return this.m_tupleNames.get(tup);
    }
}

