/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.ecore;

import groove.io.ExtensionFilter;
import groove.io.conceptual.Field;
import groove.io.conceptual.Id;
import groove.io.conceptual.InstanceModel;
import groove.io.conceptual.Name;
import groove.io.conceptual.Timer;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.lang.ImportException;
import groove.io.conceptual.lang.InstanceImporter;
import groove.io.conceptual.lang.InvalidTypeException;
import groove.io.conceptual.lang.Message;
import groove.io.conceptual.lang.ecore.EcoreToType;
import groove.io.conceptual.lang.ecore.EcoreUtil;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.Type;
import groove.io.conceptual.value.ContainerValue;
import groove.io.conceptual.value.Value;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class EcoreToInstance
extends InstanceImporter {
    private final EcoreToType m_ecoreType;
    private final Resource m_resource;
    private final TypeModel m_typeModel;
    private InstanceModel m_instanceModel;
    private final String m_instanceName;
    private Map<EObject, groove.io.conceptual.value.Object> m_objects = new HashMap<EObject, groove.io.conceptual.value.Object>();

    public EcoreToInstance(EcoreToType typeModel, String filename) throws ImportException {
        this.m_ecoreType = typeModel;
        this.m_typeModel = this.m_ecoreType.getTypeModel("ecore");
        if (this.m_typeModel == null) {
            throw new ImportException("Cannot load type model from given EcoreToType");
        }
        ResourceSet rs = this.m_ecoreType.getResourceSet();
        File file = new File(filename);
        try {
            this.m_resource = rs.createResource(URI.createURI((String)filename));
            FileInputStream in = new FileInputStream(file);
            int timer = Timer.cont("Load Ecore");
            try {
                this.m_resource.load((InputStream)in, null);
            }
            finally {
                in.close();
            }
            Timer.stop(timer);
        }
        catch (FileNotFoundException e) {
            throw new ImportException("Cannot find file " + typeModel, e);
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
        int timer = Timer.start("Ecore to IM");
        this.m_instanceName = ExtensionFilter.getPureName(file);
        this.getInstanceModel(this.m_instanceName);
        Timer.stop(timer);
    }

    @Override
    public InstanceModel getInstanceModel(String modelName) {
        if (!this.m_instanceName.equals(modelName)) {
            return null;
        }
        if (this.m_instanceModel != null) {
            return this.m_instanceModel;
        }
        InstanceModel m = new InstanceModel(this.m_typeModel, modelName);
        TreeIterator it = this.m_resource.getAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!obj.eClass().eClass().getName().equals("EClass")) continue;
            this.visitObject(m, obj);
        }
        this.m_instanceModel = m;
        this.addInstanceModel(m);
        return m;
    }

    private groove.io.conceptual.value.Object visitObject(InstanceModel m, EObject eObject) {
        if (this.m_objects.containsKey(eObject)) {
            return this.m_objects.get(eObject);
        }
        Name objName = this.getObjectName(eObject);
        Id clsId = EcoreUtil.idFromClassifier((EClassifier)eObject.eClass());
        Class cmClass = this.m_typeModel.getClass(clsId);
        if (cmClass == null) {
            this.addMessage(new Message("Cannot find class " + clsId + " in type model", Message.MessageType.ERROR));
            return null;
        }
        groove.io.conceptual.value.Object cmObject = new groove.io.conceptual.value.Object(cmClass, objName);
        m.addObject(cmObject);
        this.m_objects.put(eObject, cmObject);
        for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
            if (feature.eClass().getName().equals("EReference")) {
                this.visitReference(m, cmObject, (EReference)feature, eObject.eGet(feature));
                continue;
            }
            if (!feature.eClass().getName().equals("EAttribute")) continue;
            this.visitAttribute(m, cmObject, (EAttribute)feature, eObject.eGet(feature));
        }
        return cmObject;
    }

    private Value visitReference(InstanceModel m, groove.io.conceptual.value.Object cmObject, EReference eReference, Object value) {
        if (value == null) {
            return null;
        }
        Id classId = EcoreUtil.idFromClassifier((EClassifier)eReference.getEContainingClass());
        Class refClass = this.m_typeModel.getClass(classId);
        if (refClass == null) {
            this.addMessage(new Message("Cannot find class of reference " + eReference, Message.MessageType.ERROR));
            return null;
        }
        Field f = refClass.getField(Name.getName(eReference.getName()));
        if (eReference.isMany()) {
            ContainerValue cv = new ContainerValue((Container)f.getType());
            for (EObject target : (EList)value) {
                groove.io.conceptual.value.Object refObj = this.visitObject(m, target);
                cv.addValue(refObj);
            }
            cmObject.setFieldValue(f, cv);
            return cv;
        }
        EObject target = (EObject)value;
        groove.io.conceptual.value.Object refObj = this.visitObject(m, target);
        if (refObj == null) {
            return null;
        }
        cmObject.setFieldValue(f, refObj);
        return refObj;
    }

    private Value visitAttribute(InstanceModel m, groove.io.conceptual.value.Object cmObject, EAttribute eAttribute, Object value) {
        if (value == null) {
            return null;
        }
        Id classId = EcoreUtil.idFromClassifier((EClassifier)eAttribute.getEContainingClass());
        Class attrClass = this.m_typeModel.getClass(classId);
        if (attrClass == null) {
            this.addMessage(new Message("Cannot find class of attribute " + eAttribute, Message.MessageType.ERROR));
            return null;
        }
        Field f = attrClass.getField(Name.getName(eAttribute.getName()));
        if (f.getType() instanceof Container) {
            Container containerType = (Container)f.getType();
            ContainerValue cv = new ContainerValue(containerType);
            cmObject.setFieldValue(f, cv);
            Type subType = containerType.getType();
            if (eAttribute.isMany()) {
                for (Object target : (EList)value) {
                    try {
                        Value cmVal = this.m_ecoreType.objectToDataType(this.m_typeModel, subType, target);
                        cv.addValue(cmVal);
                    }
                    catch (InvalidTypeException e) {
                        this.addMessage(new Message(e.getMessage(), Message.MessageType.ERROR));
                    }
                }
            } else {
                try {
                    Value cmVal = this.m_ecoreType.objectToDataType(this.m_typeModel, subType, value);
                    cv.addValue(cmVal);
                }
                catch (InvalidTypeException e) {
                    this.addMessage(new Message(e.getMessage(), Message.MessageType.ERROR));
                    return null;
                }
            }
            return cv;
        }
        try {
            Value cmVal = this.m_ecoreType.objectToDataType(this.m_typeModel, f.getType(), value);
            cmObject.setFieldValue(f, cmVal);
            return cmVal;
        }
        catch (InvalidTypeException e) {
            this.addMessage(new Message(e.getMessage(), Message.MessageType.ERROR));
            return null;
        }
    }

    private Name getObjectName(EObject eObject) {
        String fragment = "";
        EObject current = eObject;
        while (current.eContainer() != null && current.eContainer() instanceof InternalEObject) {
            fragment = "/" + ((InternalEObject)current.eContainer()).eURIFragmentSegment(current.eContainingFeature(), current) + fragment;
            current = current.eContainer();
        }
        fragment = "/" + fragment;
        return Name.getName(fragment);
    }
}

