/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.graphviz;

import com.alexmerz.graphviz.ParseException;
import com.alexmerz.graphviz.Parser;
import com.alexmerz.graphviz.objects.Edge;
import com.alexmerz.graphviz.objects.Graph;
import com.alexmerz.graphviz.objects.Node;
import groove.io.ExtensionFilter;
import groove.io.conceptual.Field;
import groove.io.conceptual.Id;
import groove.io.conceptual.InstanceModel;
import groove.io.conceptual.Name;
import groove.io.conceptual.Timer;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.lang.ImportException;
import groove.io.conceptual.lang.InstanceImporter;
import groove.io.conceptual.lang.Message;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.StringType;
import groove.io.conceptual.type.Type;
import groove.io.conceptual.value.ContainerValue;
import groove.io.conceptual.value.StringValue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphvizToInstance
extends InstanceImporter {
    private Map<Node, groove.io.conceptual.value.Object> m_nodeMap = new HashMap<Node, groove.io.conceptual.value.Object>();

    public GraphvizToInstance(String filename) throws ImportException {
        int timer;
        ArrayList graphs = null;
        File file = new File(filename);
        try {
            FileReader in = new FileReader(file);
            Parser p = new Parser();
            try {
                try {
                    timer = Timer.start("Load DOT");
                    p.parse((Reader)in);
                    graphs = p.getGraphs();
                    Timer.stop(timer);
                }
                catch (ParseException e) {
                    throw new ImportException(e);
                }
            }
            finally {
                in.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new ImportException(e);
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
        TypeModel typeModel = new TypeModel("DOTType");
        InstanceModel instanceModel = new InstanceModel(typeModel, ExtensionFilter.getPureName(file));
        timer = Timer.start("DOT to IM");
        this.visitGraphs(instanceModel, graphs, Id.ROOT);
        Timer.stop(timer);
        this.addInstanceModel(instanceModel);
    }

    private void visitGraphs(InstanceModel model, List<Graph> graphs, Id graphId) {
        for (Graph graph : graphs) {
            String graphName = graph.getId().getLabel();
            if (graphName.equals("")) {
                graphName = graph.getId().getId();
            }
            if (graphName.equals("")) {
                graphName = graph.getAttribute("label");
            }
            if (graphName == null) {
                graphName = "graph";
            }
            Id graphNS = Id.getId(graphId, Name.getName(graphName));
            for (Node node : graph.getNodes(true)) {
                if (node.isSubgraph()) continue;
                this.visitNode(model, node, graphNS);
            }
            this.visitGraphs(model, graph.getSubgraphs(), graphNS);
            for (Edge edge : graph.getEdges()) {
                this.visitEdge(model, edge);
            }
        }
    }

    private groove.io.conceptual.value.Object visitNode(InstanceModel model, Node node, Id graphId) {
        String nodeName;
        if (this.m_nodeMap.containsKey(node)) {
            return this.m_nodeMap.get(node);
        }
        if (graphId == null) {
            this.addMessage(new Message("Attempting to add edge for unvisited node" + node.toString(), Message.MessageType.ERROR));
        }
        if ((nodeName = node.getId().getLabel()).equals("")) {
            nodeName = node.getId().getId();
        }
        if (nodeName.equals("")) {
            nodeName = node.getAttribute("label");
        }
        if (nodeName == null) {
            nodeName = "node";
        }
        Class c = model.getTypeModel().getClass(Id.getId(graphId, Name.getName(nodeName)), true);
        groove.io.conceptual.value.Object object = new groove.io.conceptual.value.Object(c, Name.getName(nodeName));
        this.m_nodeMap.put(node, object);
        for (Map.Entry entry : node.getAttributes().entrySet()) {
            if (((String)entry.getKey()).equals("label")) continue;
            Field f = new Field(Name.getName((String)entry.getKey()), new Container(Container.Kind.SET, StringType.instance()), 0, 1);
            c.addField(f);
            ContainerValue v = new ContainerValue((Container)f.getType());
            v.addValue(new StringValue((String)entry.getValue()));
            object.setFieldValue(f, v);
        }
        model.addObject(object);
        return object;
    }

    private void visitEdge(InstanceModel model, Edge edge) {
        Node source = edge.getSource().getNode();
        Node target = edge.getTarget().getNode();
        if (source.isSubgraph() || target.isSubgraph()) {
            return;
        }
        groove.io.conceptual.value.Object sourceObj = this.visitNode(model, source, null);
        groove.io.conceptual.value.Object targetObj = this.visitNode(model, target, null);
        String label = edge.getAttribute("label");
        if (label == null) {
            label = "edge";
        }
        Field f = null;
        Type fType = null;
        Type targetType = targetObj.getType();
        int index = 0;
        do {
            if ((f = ((Class)sourceObj.getType()).getField(Name.getName(index == 0 ? label : String.valueOf(label) + index))) != null) {
                ++index;
                fType = ((Container)f.getType()).getType();
                continue;
            }
            fType = null;
        } while (f != null && fType != targetType);
        if (f == null) {
            Container ctype = new Container(Container.Kind.SET, targetObj.getType());
            f = new Field(Name.getName(index == 0 ? label : String.valueOf(label) + index), ctype, 0, -1);
            ((Class)sourceObj.getType()).addField(f);
            sourceObj.setFieldValue(f, new ContainerValue(ctype));
        }
        ContainerValue cv = (ContainerValue)sourceObj.getValue().get(f);
        cv.addValue(targetObj);
    }
}

