/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.groove;

import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeNode;
import groove.io.conceptual.configuration.Config;
import groove.io.conceptual.lang.ImportException;
import groove.io.conceptual.lang.Message;
import groove.io.conceptual.lang.Messenger;
import groove.io.conceptual.lang.groove.GraphNodeTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GrooveToMeta
implements Messenger {
    private Config m_cfg;
    List<Message> m_messages = new ArrayList<Message>();
    private Map<TypeNode, MetaType> m_metaNodes = new HashMap<TypeNode, MetaType>();
    private GraphNodeTypes m_types;

    public GrooveToMeta(TypeGraph grooveTypeGraph, GraphNodeTypes types, Config cfg) throws ImportException {
        this.m_types = types;
        this.m_cfg = cfg;
        for (TypeNode node : grooveTypeGraph.nodeSet()) {
            this.getNodeType(node);
        }
        for (TypeNode node : grooveTypeGraph.nodeSet()) {
            if (this.getNodeType(node) != MetaType.None) continue;
            Set<TypeNode> superTypes = node.getGraph().getDirectSupertypeMap().get(node);
            if (superTypes.size() > 1) {
                this.addMessage(new Message("Node has multiple supertypes in meta type graph: " + node.toString(), Message.MessageType.WARNING));
                continue;
            }
            if (superTypes.size() == 0) {
                this.addMessage(new Message("Node has no meta type: " + node.toString(), Message.MessageType.WARNING));
                continue;
            }
            this.m_types.addModelType(node.label().text(), this.getModelType(this.getNodeType(superTypes.iterator().next())));
        }
    }

    private MetaType getNodeType(TypeNode node) {
        if (this.m_metaNodes.containsKey(node)) {
            return this.m_metaNodes.get(node);
        }
        String label = node.label().text();
        MetaType type = MetaType.None;
        if (label == null) {
            return MetaType.None;
        }
        if (label.equals(this.m_cfg.getStrings().getMetaType())) {
            type = MetaType.Type;
        } else if (label.equals(this.m_cfg.getStrings().getMetaClass())) {
            type = MetaType.Class;
        } else if (label.equals(this.m_cfg.getStrings().getMetaClassNullable())) {
            type = MetaType.ClassNullable;
        } else if (label.equals(this.m_cfg.getStrings().getMetaEnum())) {
            type = MetaType.Enum;
        } else if (label.equals(this.m_cfg.getStrings().getMetaDataType())) {
            type = MetaType.DataType;
        } else if (label.equals(this.m_cfg.getStrings().getMetaTuple())) {
            type = MetaType.Tuple;
        } else if (label.equals(this.m_cfg.getStrings().getMetaContainerSet())) {
            type = MetaType.ContainerSet;
        } else if (label.equals(this.m_cfg.getStrings().getMetaContainerBag())) {
            type = MetaType.ContainerBag;
        } else if (label.equals(this.m_cfg.getStrings().getMetaContainerSeq())) {
            type = MetaType.ContainerSeq;
        } else if (label.equals(this.m_cfg.getStrings().getMetaContainerOrd())) {
            type = MetaType.ContainerOrd;
        } else if (label.equals(this.m_cfg.getStrings().getMetaIntermediate())) {
            type = MetaType.Intermediate;
        }
        this.m_metaNodes.put(node, type);
        return type;
    }

    private GraphNodeTypes.ModelType getModelType(MetaType metaType) {
        switch (metaType) {
            case Class: {
                return GraphNodeTypes.ModelType.TypeClass;
            }
            case ClassNullable: {
                return GraphNodeTypes.ModelType.TypeClassNullable;
            }
            case Enum: {
                return GraphNodeTypes.ModelType.TypeEnum;
            }
            case Intermediate: {
                return GraphNodeTypes.ModelType.TypeIntermediate;
            }
            case ContainerSet: {
                return GraphNodeTypes.ModelType.TypeContainerSet;
            }
            case ContainerBag: {
                return GraphNodeTypes.ModelType.TypeContainerBag;
            }
            case ContainerSeq: {
                return GraphNodeTypes.ModelType.TypeContainerSeq;
            }
            case ContainerOrd: {
                return GraphNodeTypes.ModelType.TypeContainerOrd;
            }
            case DataType: {
                return GraphNodeTypes.ModelType.TypeDatatype;
            }
            case Tuple: {
                return GraphNodeTypes.ModelType.TypeTuple;
            }
        }
        return GraphNodeTypes.ModelType.TypeNone;
    }

    @Override
    public List<Message> getMessages() {
        return this.m_messages;
    }

    @Override
    public void clearMessages() {
        this.m_messages.clear();
    }

    private void addMessage(Message msg) {
        this.m_messages.add(msg);
    }

    private static enum MetaType {
        Type,
        Class,
        ClassNullable,
        Enum,
        Intermediate,
        ContainerSet,
        ContainerBag,
        ContainerSeq,
        ContainerOrd,
        DataType,
        Tuple,
        None;

    }
}

