/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.type;

import groove.io.conceptual.Field;
import groove.io.conceptual.Visitor;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Type;

public class Container
extends Type {
    private Kind m_ctype;
    private Type m_contentType;
    private Field m_containingField;
    private Container m_parent;

    public Container(Kind ctype, Type contentType) {
        this.m_ctype = ctype;
        if (contentType instanceof Class) {
            contentType = ((Class)contentType).getProperClass();
        }
        if (contentType instanceof Container) {
            ((Container)contentType).m_parent = this;
        }
        this.m_contentType = contentType;
        this.m_parent = null;
    }

    public void setField(Field field) {
        this.m_containingField = field;
    }

    public Field getField() {
        return this.m_containingField;
    }

    public Container getParent() {
        return this.m_parent;
    }

    public void setOrdered(boolean ordered) {
        if (ordered) {
            if (this.m_ctype == Kind.SET) {
                this.m_ctype = Kind.ORD;
            }
            if (this.m_ctype == Kind.BAG) {
                this.m_ctype = Kind.SEQ;
            }
        } else {
            if (this.m_ctype == Kind.ORD) {
                this.m_ctype = Kind.SET;
            }
            if (this.m_ctype == Kind.SEQ) {
                this.m_ctype = Kind.BAG;
            }
        }
    }

    public void setUnique(boolean unique) {
        if (unique) {
            if (this.m_ctype == Kind.BAG) {
                this.m_ctype = Kind.SET;
            }
            if (this.m_ctype == Kind.SEQ) {
                this.m_ctype = Kind.ORD;
            }
        } else {
            if (this.m_ctype == Kind.SET) {
                this.m_ctype = Kind.BAG;
            }
            if (this.m_ctype == Kind.ORD) {
                this.m_ctype = Kind.SEQ;
            }
        }
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public String typeString() {
        return "Container";
    }

    @Override
    public String toString() {
        return String.valueOf(this.typeString()) + "<" + (Object)((Object)this.m_ctype) + ">(" + (this.m_contentType.isComplex() ? this.m_contentType.typeString() : this.m_contentType.toString()) + ")";
    }

    public Kind getContainerType() {
        return this.m_ctype;
    }

    public Type getType() {
        return this.m_contentType;
    }

    public boolean isUnique() {
        return this.m_ctype == Kind.SET || this.m_ctype == Kind.ORD;
    }

    public boolean isOrdered() {
        return this.m_ctype == Kind.SEQ || this.m_ctype == Kind.ORD;
    }

    @Override
    public boolean doVisit(Visitor v, Object param) {
        v.visit(this, param);
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Container)) {
            return false;
        }
        Container c = (Container)o;
        return c.getContainerType() == this.getContainerType() && c.getType().equals(this.getType());
    }

    public static enum Kind {
        BAG,
        SET,
        SEQ,
        ORD;

    }
}

