/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.type;

import groove.grammar.model.FormatException;
import groove.io.conceptual.Id;
import groove.io.conceptual.Name;
import groove.io.conceptual.Visitor;
import groove.io.conceptual.type.DataType;
import groove.io.conceptual.value.StringValue;
import groove.io.conceptual.value.Value;
import groove.util.ExprParser;

public class StringType
extends DataType {
    private static final StringType instance = new StringType();
    public static final String NAME = "string";

    private StringType() {
        super(Id.getId(Id.ROOT, Name.getName(NAME)));
    }

    @Override
    public String typeString() {
        return NAME;
    }

    @Override
    public boolean doVisit(Visitor v, Object param) {
        v.visit(this, param);
        return true;
    }

    @Override
    public Value valueFromString(String valueString) {
        try {
            return new StringValue(ExprParser.toUnquoted(valueString, '\"'));
        }
        catch (FormatException formatException) {
            return null;
        }
    }

    @Override
    public boolean acceptValue(Value v) {
        return v instanceof StringValue;
    }

    public static StringType instance() {
        return instance;
    }
}

