/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.format;

import groove.gui.jgraph.JGraph;
import groove.io.FileType;
import groove.io.external.AbstractFormatExporter;
import groove.io.external.Exporter;
import groove.io.external.Format;
import groove.io.external.FormatPorter;
import groove.io.external.PortException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class RasterExporter
extends AbstractFormatExporter {
    private final Map<Format, String> formats;
    private static final RasterExporter instance = new RasterExporter();

    private RasterExporter() {
        Format pngformat = new Format((FormatPorter)this, FileType.PNG);
        Format jpgformat = new Format((FormatPorter)this, FileType.JPG);
        this.formats = new LinkedHashMap<Format, String>();
        this.formats.put(pngformat, "png");
        this.formats.put(jpgformat, "jpg");
    }

    @Override
    public FormatPorter.Kind getFormatKind() {
        return FormatPorter.Kind.JGRAPH;
    }

    @Override
    public Collection<? extends Format> getSupportedFormats() {
        return this.formats.keySet();
    }

    @Override
    public void doExport(File file, Format format, Exporter.Exportable exportable) throws PortException {
        JGraph<?> jGraph = exportable.getJGraph();
        BufferedImage image = jGraph.toImage();
        if (image == null) {
            throw new PortException("Cannot export blank image");
        }
        try {
            ImageIO.write((RenderedImage)image, this.formats.get(format), file);
        }
        catch (IOException e) {
            throw new PortException(e);
        }
    }

    public static final RasterExporter getInstance() {
        return instance;
    }
}

